/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.channeling.edges;

import org.chocosolver.graphsolver.variables.GraphEventType;
import org.chocosolver.graphsolver.variables.GraphVar;
import org.chocosolver.graphsolver.variables.IncidentSet;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.tools.ArrayUtils;

public class PropNeighBoolChannel
extends Propagator<Variable> {
    private BoolVar[] bools;
    private GraphVar g;
    private int vertex;
    private IncidentSet inc;

    public PropNeighBoolChannel(BoolVar[] neigh, int vertex, GraphVar gV, IncidentSet incSet) {
        super((Variable[])ArrayUtils.append((Object[][])new Variable[][]{neigh, {gV}}), PropagatorPriority.LINEAR, true);
        this.vertex = vertex;
        this.bools = neigh;
        this.g = gV;
        this.inc = incSet;
        super.linkVariables();
    }

    public int getPropagationConditions(int vIdx) {
        if (vIdx == this.bools.length) {
            return GraphEventType.ADD_ARC.getMask() + GraphEventType.REMOVE_ARC.getMask();
        }
        return IntEventType.all();
    }

    public void propagate(int evtmask) throws ContradictionException {
        ISetIterator iSetIterator = this.inc.getPotSet(this.g, this.vertex).iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            if (this.bools[i].getUB() == 0) {
                this.inc.remove(this.g, this.vertex, i, (ICause)this);
                continue;
            }
            if (this.bools[i].getLB() != 1) continue;
            this.inc.enforce(this.g, this.vertex, i, (ICause)this);
        }
        for (int i = 0; i < this.bools.length; ++i) {
            if (!this.inc.getPotSet(this.g, this.vertex).contains(i)) {
                this.bools[i].setToFalse((ICause)this);
                continue;
            }
            if (!this.inc.getMandSet(this.g, this.vertex).contains(i)) continue;
            this.bools[i].setToTrue((ICause)this);
        }
    }

    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (idxVarInProp < this.bools.length) {
            if (this.bools[idxVarInProp].getLB() == 1) {
                this.inc.enforce(this.g, this.vertex, idxVarInProp, (ICause)this);
            } else {
                this.inc.remove(this.g, this.vertex, idxVarInProp, (ICause)this);
            }
        } else {
            for (int i = 0; i < this.bools.length; ++i) {
                if (!this.inc.getPotSet(this.g, this.vertex).contains(i)) {
                    this.bools[i].setToFalse((ICause)this);
                    continue;
                }
                if (!this.inc.getMandSet(this.g, this.vertex).contains(i)) continue;
                this.bools[i].setToTrue((ICause)this);
            }
        }
    }

    public ESat isEntailed() {
        for (int i = 0; i < this.bools.length; ++i) {
            if (this.bools[i].getLB() != 1 || this.inc.getPotSet(this.g, this.vertex).contains(i)) continue;
            return ESat.FALSE;
        }
        ISetIterator iSetIterator = this.inc.getMandSet(this.g, this.vertex).iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            if (this.bools[i].getUB() != 0) continue;
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

