/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.channeling.edges;

import org.chocosolver.graphsolver.variables.GraphEventType;
import org.chocosolver.graphsolver.variables.GraphVar;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public class PropArcBoolChannel
extends Propagator<Variable> {
    private BoolVar bool;
    private int from;
    private int to;
    private GraphVar g;

    public PropArcBoolChannel(BoolVar isIn, int from, int to, GraphVar gV) {
        super(new Variable[]{isIn, gV}, PropagatorPriority.UNARY, false);
        this.bool = isIn;
        this.from = from;
        this.to = to;
        this.g = gV;
    }

    public int getPropagationConditions(int vIdx) {
        if (vIdx == 1) {
            return GraphEventType.ADD_ARC.getMask() + GraphEventType.REMOVE_ARC.getMask();
        }
        return IntEventType.all();
    }

    public void propagate(int evtmask) throws ContradictionException {
        if (this.from < 0 || this.to < 0 || this.from >= this.g.getNbMaxNodes() || this.to >= this.g.getNbMaxNodes() || !this.g.getPotSuccOrNeighOf(this.from).contains(this.to)) {
            this.bool.setToFalse((ICause)this);
        } else if (this.g.getMandSuccOrNeighOf(this.from).contains(this.to)) {
            this.bool.setToTrue((ICause)this);
        } else if (this.bool.getLB() == 1) {
            this.g.enforceArc(this.from, this.to, (ICause)this);
        } else if (this.bool.getUB() == 0) {
            this.g.removeArc(this.from, this.to, (ICause)this);
        }
    }

    public ESat isEntailed() {
        if (this.from < 0 || this.from >= this.g.getNbMaxNodes() || this.to < 0 || this.to >= this.g.getNbMaxNodes() || this.bool.getLB() == 1 && !this.g.getPotSuccOrNeighOf(this.from).contains(this.to) || this.bool.getUB() == 0 && this.g.getMandSuccOrNeighOf(this.from).contains(this.to)) {
            return ESat.FALSE;
        }
        if (this.bool.isInstantiated() && this.g.getMandSuccOrNeighOf(this.from).contains(this.to) == this.g.getPotSuccOrNeighOf(this.from).contains(this.to)) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

