/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.basic;

import gnu.trove.list.array.TIntArrayList;
import org.chocosolver.graphsolver.variables.GraphEventType;
import org.chocosolver.graphsolver.variables.GraphVar;
import org.chocosolver.graphsolver.variables.delta.GraphDeltaMonitor;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.PairProcedure;

public class PropTransitivity<V extends GraphVar>
extends Propagator<V> {
    private V g;
    private GraphDeltaMonitor gdm;
    private PairProcedure arcEnforced;
    private PairProcedure arcRemoved;
    private TIntArrayList eF;
    private TIntArrayList eT;
    private TIntArrayList rF;
    private TIntArrayList rT;

    public PropTransitivity(V graph) {
        super((Variable[])new GraphVar[]{graph}, PropagatorPriority.LINEAR, true);
        this.g = graph;
        this.gdm = ((GraphVar)((Object)this.g)).monitorDelta((ICause)this);
        int n = ((GraphVar)((Object)this.g)).getNbMaxNodes();
        this.eF = new TIntArrayList(n);
        this.eT = new TIntArrayList(n);
        this.rF = new TIntArrayList(n);
        this.rT = new TIntArrayList(n);
        this.arcEnforced = this::_enfArc;
        this.arcRemoved = this::_remArc;
    }

    public void propagate(int evtmask) throws ContradictionException {
        int n = ((GraphVar)((Object)this.g)).getNbMaxNodes();
        ISetIterator iSetIterator = ((GraphVar)((Object)this.g)).getPotentialNodes().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            for (int j = 0; j < n; ++j) {
                if (((GraphVar)((Object)this.g)).getMandSuccOrNeighOf(i).contains(j)) {
                    this._enfArc(i, j);
                    continue;
                }
                if (((GraphVar)((Object)this.g)).getPotSuccOrNeighOf(i).contains(j)) continue;
                this._remArc(i, j);
            }
        }
        this.filter();
        this.gdm.unfreeze();
    }

    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.gdm.freeze();
        this.rT.clear();
        this.rF.clear();
        this.eT.clear();
        this.eF.clear();
        this.gdm.forEachArc(this.arcEnforced, GraphEventType.ADD_ARC);
        this.gdm.forEachArc(this.arcRemoved, GraphEventType.REMOVE_ARC);
        this.filter();
        this.gdm.unfreeze();
    }

    private void filter() throws ContradictionException {
        assert (this.eF.size() == this.eT.size());
        while (!this.eF.isEmpty()) {
            assert (this.eF.size() == this.eT.size());
            this.enfArc(this.eF.removeAt(this.eF.size() - 1), this.eT.removeAt(this.eT.size() - 1));
        }
        assert (this.rF.size() == this.rT.size());
        while (!this.rF.isEmpty()) {
            assert (this.rF.size() == this.rT.size());
            this.remArc(this.rF.removeAt(this.rF.size() - 1), this.rT.removeAt(this.rT.size() - 1));
        }
        assert (this.eF.size() == this.eT.size());
        if (!this.eF.isEmpty()) {
            this.filter();
        }
    }

    public int getPropagationConditions(int vIdx) {
        return GraphEventType.REMOVE_ARC.getMask() + GraphEventType.ADD_ARC.getMask();
    }

    public ESat isEntailed() {
        int n = ((GraphVar)((Object)this.g)).getNbMaxNodes();
        for (int i = 0; i < n; ++i) {
            ISetIterator iSetIterator = ((GraphVar)((Object)this.g)).getMandSuccOrNeighOf(i).iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (i == j) continue;
                ISetIterator iSetIterator2 = ((GraphVar)((Object)this.g)).getMandSuccOrNeighOf(j).iterator();
                while (iSetIterator2.hasNext()) {
                    int j2 = (Integer)iSetIterator2.next();
                    if (j2 == i || ((GraphVar)((Object)this.g)).getPotSuccOrNeighOf(i).contains(j2)) continue;
                    return ESat.FALSE;
                }
            }
        }
        if (((GraphVar)((Object)this.g)).isInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    private void _enfArc(int x, int y) {
        this.eF.add(x);
        this.eT.add(y);
    }

    private void _remArc(int x, int y) {
        this.rF.add(x);
        this.rT.add(y);
    }

    private void enfArc(int from, int to) throws ContradictionException {
        if (from != to) {
            int i;
            ISet ker = ((GraphVar)((Object)this.g)).getMandSuccOrNeighOf(to);
            ISet env = ((GraphVar)((Object)this.g)).getPotSuccOrNeighOf(to);
            ISetIterator iSetIterator = env.iterator();
            while (iSetIterator.hasNext()) {
                i = (Integer)iSetIterator.next();
                if (i == to || i == from) continue;
                if (ker.contains(i)) {
                    if (!((GraphVar)((Object)this.g)).enforceArc(from, i, (ICause)this)) continue;
                    this._enfArc(from, i);
                    continue;
                }
                if (((GraphVar)((Object)this.g)).getPotSuccOrNeighOf(from).contains(i) || !((GraphVar)((Object)this.g)).removeArc(to, i, (ICause)this)) continue;
                this._remArc(to, i);
            }
            ker = ((GraphVar)((Object)this.g)).getMandPredOrNeighOf(from);
            env = ((GraphVar)((Object)this.g)).getPotPredOrNeighOf(from);
            iSetIterator = env.iterator();
            while (iSetIterator.hasNext()) {
                i = (Integer)iSetIterator.next();
                if (i == to || i == from) continue;
                if (ker.contains(i)) {
                    if (!((GraphVar)((Object)this.g)).enforceArc(i, to, (ICause)this)) continue;
                    this._enfArc(i, to);
                    continue;
                }
                if (((GraphVar)((Object)this.g)).getPotSuccOrNeighOf(i).contains(to) || !((GraphVar)((Object)this.g)).removeArc(i, from, (ICause)this)) continue;
                this._remArc(i, from);
            }
        }
    }

    private void remArc(int from, int to) throws ContradictionException {
        if (from != to) {
            int i;
            ISetIterator iSetIterator = ((GraphVar)((Object)this.g)).getMandSuccOrNeighOf(from).iterator();
            while (iSetIterator.hasNext()) {
                i = (Integer)iSetIterator.next();
                if (!((GraphVar)((Object)this.g)).removeArc(i, to, (ICause)this)) continue;
                this._remArc(i, to);
            }
            iSetIterator = ((GraphVar)((Object)this.g)).getMandPredOrNeighOf(to).iterator();
            while (iSetIterator.hasNext()) {
                i = (Integer)iSetIterator.next();
                if (!((GraphVar)((Object)this.g)).removeArc(from, i, (ICause)this)) continue;
                this._remArc(from, i);
            }
        }
    }
}

