/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.basic;

import org.chocosolver.graphsolver.variables.GraphEventType;
import org.chocosolver.graphsolver.variables.GraphVar;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropNbArcs
extends Propagator<Variable> {
    protected GraphVar g;
    protected IntVar k;

    public PropNbArcs(GraphVar graph, IntVar k) {
        super(new Variable[]{graph, k}, PropagatorPriority.LINEAR, false);
        this.g = graph;
        this.k = k;
    }

    public void propagate(int evtmask) throws ContradictionException {
        int nbK = 0;
        int nbE = 0;
        ISet env = this.g.getPotentialNodes();
        ISetIterator iSetIterator = env.iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            nbE += this.g.getPotSuccOrNeighOf(i).size();
            nbK += this.g.getMandSuccOrNeighOf(i).size();
        }
        if (!this.g.isDirected()) {
            nbK /= 2;
            nbE /= 2;
        }
        this.filter(nbK, nbE);
    }

    private void filter(int nbK, int nbE) throws ContradictionException {
        this.k.updateLowerBound(nbK, (ICause)this);
        this.k.updateUpperBound(nbE, (ICause)this);
        if (nbK != nbE && this.k.isInstantiated()) {
            ISet nei;
            ISet env = this.g.getPotentialNodes();
            if (this.k.getValue() == nbE) {
                ISetIterator iSetIterator = env.iterator();
                while (iSetIterator.hasNext()) {
                    int i = (Integer)iSetIterator.next();
                    nei = this.g.getUB().getSuccOrNeighOf(i);
                    ISetIterator iSetIterator2 = nei.iterator();
                    while (iSetIterator2.hasNext()) {
                        int j = (Integer)iSetIterator2.next();
                        this.g.enforceArc(i, j, (ICause)this);
                    }
                }
            }
            if (this.k.getValue() == nbK) {
                ISetIterator iSetIterator = env.iterator();
                while (iSetIterator.hasNext()) {
                    int i = (Integer)iSetIterator.next();
                    nei = this.g.getUB().getSuccOrNeighOf(i);
                    ISet neiKer = this.g.getLB().getSuccOrNeighOf(i);
                    ISetIterator iSetIterator3 = nei.iterator();
                    while (iSetIterator3.hasNext()) {
                        int j = (Integer)iSetIterator3.next();
                        if (neiKer.contains(j)) continue;
                        this.g.removeArc(i, j, (ICause)this);
                    }
                }
            }
        }
    }

    public int getPropagationConditions(int vIdx) {
        if (vIdx == 0) {
            return GraphEventType.REMOVE_ARC.getMask() + GraphEventType.ADD_ARC.getMask();
        }
        return IntEventType.boundAndInst();
    }

    public ESat isEntailed() {
        int nbK = 0;
        int nbE = 0;
        ISet env = this.g.getPotentialNodes();
        ISetIterator iSetIterator = env.iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            nbE += this.g.getUB().getSuccOrNeighOf(i).size();
            nbK += this.g.getLB().getSuccOrNeighOf(i).size();
        }
        if (!this.g.isDirected()) {
            nbK /= 2;
            nbE /= 2;
        }
        if (nbK > this.k.getUB() || nbE < this.k.getLB()) {
            return ESat.FALSE;
        }
        if (this.k.isInstantiated() && this.g.isInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

