/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.basic;

import gnu.trove.list.array.TIntArrayList;
import java.util.BitSet;
import org.chocosolver.graphsolver.variables.GraphVar;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropDiameter
extends Propagator<GraphVar> {
    private GraphVar g;
    private IntVar diameter;
    private BitSet visited;
    private TIntArrayList set;
    private TIntArrayList nextSet;

    public PropDiameter(GraphVar graph, IntVar maxDiam) {
        super((Variable[])new GraphVar[]{graph}, PropagatorPriority.LINEAR, false);
        this.g = graph;
        this.diameter = maxDiam;
        this.visited = new BitSet(this.g.getNbMaxNodes());
        this.set = new TIntArrayList();
        this.nextSet = new TIntArrayList();
    }

    public void propagate(int evtmask) throws ContradictionException {
        int max = -1;
        ISetIterator iSetIterator = this.g.getPotentialNodes().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            if (this.g.getMandatoryNodes().contains(i)) {
                this.diameter.updateLowerBound(this.BFS(i, true), (ICause)this);
            }
            max = Math.max(max, this.BFS(i, false));
        }
        this.diameter.updateUpperBound(max, (ICause)this);
    }

    private int BFS(int root, boolean min) {
        this.nextSet.clear();
        this.set.clear();
        this.visited.clear();
        int i = root;
        this.set.add(i);
        this.visited.set(i);
        int depth = 0;
        int nbMand = this.g.getMandatoryNodes().size();
        int count = 1;
        while (!this.set.isEmpty()) {
            for (i = this.set.size() - 1; i >= 0; --i) {
                ISet nei = this.g.getPotSuccOrNeighOf(this.set.get(i));
                ISetIterator iSetIterator = nei.iterator();
                while (iSetIterator.hasNext()) {
                    int j = (Integer)iSetIterator.next();
                    if (this.visited.get(j)) continue;
                    this.visited.set(j);
                    this.nextSet.add(j);
                    if (!min || !this.g.getMandatoryNodes().contains(j) || ++count != nbMand) continue;
                    return depth + 1;
                }
            }
            ++depth;
            TIntArrayList tmp = this.nextSet;
            this.nextSet = this.set;
            this.set = tmp;
            this.nextSet.clear();
        }
        return depth;
    }

    public ESat isEntailed() {
        throw new UnsupportedOperationException("isEntail() not implemented yet");
    }
}

