/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.basic;

import org.chocosolver.graphsolver.variables.DirectedGraphVar;
import org.chocosolver.graphsolver.variables.GraphEventType;
import org.chocosolver.graphsolver.variables.delta.GraphDeltaMonitor;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.PairProcedure;

public class PropAntiSymmetric
extends Propagator<DirectedGraphVar> {
    private DirectedGraphVar g;
    private GraphDeltaMonitor gdm;
    private PairProcedure enf;

    public PropAntiSymmetric(DirectedGraphVar graph) {
        super((Variable[])new DirectedGraphVar[]{graph});
        this.g = graph;
        this.gdm = this.g.monitorDelta((ICause)this);
        this.enf = (from, to) -> {
            if (from != to) {
                this.g.removeArc(to, from, (ICause)this);
            }
        };
    }

    public void propagate(int evtmask) throws ContradictionException {
        ISet ker = this.g.getMandatoryNodes();
        ISetIterator iSetIterator = ker.iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            ISet succ = this.g.getMandSuccOf(i);
            ISetIterator iSetIterator2 = succ.iterator();
            while (iSetIterator2.hasNext()) {
                int j = (Integer)iSetIterator2.next();
                this.g.removeArc(j, i, (ICause)this);
            }
        }
        this.gdm.unfreeze();
    }

    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.gdm.freeze();
        this.gdm.forEachArc(this.enf, GraphEventType.ADD_ARC);
        this.gdm.unfreeze();
    }

    public int getPropagationConditions(int vIdx) {
        return GraphEventType.ADD_ARC.getMask();
    }

    public ESat isEntailed() {
        ISet ker = this.g.getMandatoryNodes();
        ISetIterator iSetIterator = ker.iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            ISet succ = this.g.getMandSuccOf(i);
            ISetIterator iSetIterator2 = succ.iterator();
            while (iSetIterator2.hasNext()) {
                int j = (Integer)iSetIterator2.next();
                if (!this.g.getMandSuccOf(j).contains(i)) continue;
                return ESat.FALSE;
            }
        }
        if (this.g.isInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

