/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs;

import org.chocosolver.graphsolver.GraphModel;
import org.chocosolver.graphsolver.cstrs.basic.PropAntiSymmetric;
import org.chocosolver.graphsolver.cstrs.basic.PropDiameter;
import org.chocosolver.graphsolver.cstrs.basic.PropLoopSet;
import org.chocosolver.graphsolver.cstrs.basic.PropNbArcs;
import org.chocosolver.graphsolver.cstrs.basic.PropNbCliques;
import org.chocosolver.graphsolver.cstrs.basic.PropNbLoops;
import org.chocosolver.graphsolver.cstrs.basic.PropNbNodes;
import org.chocosolver.graphsolver.cstrs.basic.PropSymmetric;
import org.chocosolver.graphsolver.cstrs.basic.PropTransitivity;
import org.chocosolver.graphsolver.cstrs.channeling.edges.PropArcBoolChannel;
import org.chocosolver.graphsolver.cstrs.channeling.edges.PropNeighBoolChannel;
import org.chocosolver.graphsolver.cstrs.channeling.edges.PropNeighBoolsChannel1;
import org.chocosolver.graphsolver.cstrs.channeling.edges.PropNeighBoolsChannel2;
import org.chocosolver.graphsolver.cstrs.channeling.edges.PropNeighIntsChannel1;
import org.chocosolver.graphsolver.cstrs.channeling.edges.PropNeighIntsChannel2;
import org.chocosolver.graphsolver.cstrs.channeling.edges.PropNeighSetChannel;
import org.chocosolver.graphsolver.cstrs.channeling.edges.PropNeighSetsChannel1;
import org.chocosolver.graphsolver.cstrs.channeling.edges.PropNeighSetsChannel2;
import org.chocosolver.graphsolver.cstrs.channeling.edges.PropSuccIntsChannel1;
import org.chocosolver.graphsolver.cstrs.channeling.nodes.PropNodeBoolChannel;
import org.chocosolver.graphsolver.cstrs.channeling.nodes.PropNodeBoolsChannel;
import org.chocosolver.graphsolver.cstrs.channeling.nodes.PropNodeSetChannel;
import org.chocosolver.graphsolver.cstrs.connectivity.PropBiconnected;
import org.chocosolver.graphsolver.cstrs.connectivity.PropConnected;
import org.chocosolver.graphsolver.cstrs.connectivity.PropNbCC;
import org.chocosolver.graphsolver.cstrs.connectivity.PropNbSCC;
import org.chocosolver.graphsolver.cstrs.cost.trees.PropMaxDegVarTree;
import org.chocosolver.graphsolver.cstrs.cost.trees.PropTreeCostSimple;
import org.chocosolver.graphsolver.cstrs.cost.trees.lagrangianRelaxation.PropLagr_DCMST_generic;
import org.chocosolver.graphsolver.cstrs.cost.tsp.PropCycleCostSimple;
import org.chocosolver.graphsolver.cstrs.cost.tsp.lagrangianRelaxation.PropLagr_OneTree;
import org.chocosolver.graphsolver.cstrs.cycles.PropACyclic;
import org.chocosolver.graphsolver.cstrs.cycles.PropCircuit;
import org.chocosolver.graphsolver.cstrs.cycles.PropCycle;
import org.chocosolver.graphsolver.cstrs.cycles.PropHamiltonianCycle;
import org.chocosolver.graphsolver.cstrs.cycles.PropPathNoCircuit;
import org.chocosolver.graphsolver.cstrs.degree.PropNodeDegree_AtLeast_Coarse;
import org.chocosolver.graphsolver.cstrs.degree.PropNodeDegree_AtLeast_Incr;
import org.chocosolver.graphsolver.cstrs.degree.PropNodeDegree_AtMost_Coarse;
import org.chocosolver.graphsolver.cstrs.degree.PropNodeDegree_AtMost_Incr;
import org.chocosolver.graphsolver.cstrs.degree.PropNodeDegree_Var;
import org.chocosolver.graphsolver.cstrs.inclusion.PropInclusion;
import org.chocosolver.graphsolver.cstrs.symmbreaking.PropIncrementalAdjacencyMatrix;
import org.chocosolver.graphsolver.cstrs.symmbreaking.PropIncrementalAdjacencyUndirectedMatrix;
import org.chocosolver.graphsolver.cstrs.symmbreaking.PropSymmetryBreaking;
import org.chocosolver.graphsolver.cstrs.symmbreaking.PropSymmetryBreakingEx;
import org.chocosolver.graphsolver.cstrs.tree.PropArborescence;
import org.chocosolver.graphsolver.cstrs.tree.PropArborescences;
import org.chocosolver.graphsolver.cstrs.tree.PropReachability;
import org.chocosolver.graphsolver.variables.DirectedGraphVar;
import org.chocosolver.graphsolver.variables.GraphVar;
import org.chocosolver.graphsolver.variables.IncidentSet;
import org.chocosolver.graphsolver.variables.UndirectedGraphVar;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.util.objects.graphs.Orientation;
import org.chocosolver.util.tools.ArrayUtils;

public interface IGraphConstraintFactory {
    public GraphModel _me();

    default public Constraint nbNodes(GraphVar g, IntVar nb) {
        return new Constraint("nbNodes", new Propagator[]{new PropNbNodes(g, nb)});
    }

    default public Constraint nbArcs(DirectedGraphVar g, IntVar nb) {
        return new Constraint("nbArcs", new Propagator[]{new PropNbArcs(g, nb)});
    }

    default public Constraint nbEdges(UndirectedGraphVar g, IntVar nb) {
        return new Constraint("nbEdges", new Propagator[]{new PropNbArcs(g, nb)});
    }

    default public Constraint loopSet(GraphVar g, SetVar loops) {
        return new Constraint("loopSet", new Propagator[]{new PropLoopSet(g, loops)});
    }

    default public Constraint nbLoops(GraphVar g, IntVar nb) {
        return new Constraint("nbLoops", new Propagator[]{new PropNbLoops(g, nb)});
    }

    default public Constraint symmetric(DirectedGraphVar g) {
        return new Constraint("symmetric", new Propagator[]{new PropSymmetric(g)});
    }

    default public Constraint antisymmetric(DirectedGraphVar g) {
        return new Constraint("antisymmetric", new Propagator[]{new PropAntiSymmetric(g)});
    }

    default public Constraint transitivity(UndirectedGraphVar g) {
        return new Constraint("transitivity", new Propagator[]{new PropTransitivity<UndirectedGraphVar>(g)});
    }

    default public Constraint transitivity(DirectedGraphVar g) {
        return new Constraint("transitivity", new Propagator[]{new PropTransitivity<DirectedGraphVar>(g)});
    }

    default public Constraint subGraph(UndirectedGraphVar g1, UndirectedGraphVar g2) {
        return new Constraint("subGraph", new Propagator[]{new PropInclusion(g1, g2)});
    }

    default public Constraint subGraph(DirectedGraphVar g1, DirectedGraphVar g2) {
        return new Constraint("subGraph", new Propagator[]{new PropInclusion(g1, g2)});
    }

    default public Constraint nodesChanneling(GraphVar g, SetVar nodes) {
        return new Constraint("nodesSetChanneling", new Propagator[]{new PropNodeSetChannel(nodes, g)});
    }

    default public Constraint nodesChanneling(GraphVar g, BoolVar[] nodes) {
        return new Constraint("nodesBoolsChanneling", new Propagator[]{new PropNodeBoolsChannel(nodes, g)});
    }

    default public Constraint nodeChanneling(GraphVar g, BoolVar isIn, int vertex) {
        return new Constraint("nodesBoolChanneling", new Propagator[]{new PropNodeBoolChannel(isIn, vertex, g)});
    }

    default public Constraint arcChanneling(DirectedGraphVar g, BoolVar isArc, int from, int to) {
        return new Constraint("arcChanneling", new Propagator[]{new PropArcBoolChannel(isArc, from, to, g)});
    }

    default public Constraint edgeChanneling(UndirectedGraphVar g, BoolVar isEdge, int i, int j) {
        return new Constraint("arcChanneling", new Propagator[]{new PropArcBoolChannel(isEdge, i, j, g)});
    }

    default public Constraint neighborsChanneling(UndirectedGraphVar g, IntVar[] successors) {
        return new Constraint("neighIntsChanneling", new Propagator[]{new PropNeighIntsChannel1(successors, g), new PropNeighIntsChannel2(successors, g)});
    }

    default public Constraint neighborsChanneling(UndirectedGraphVar g, SetVar[] neighbors) {
        return new Constraint("neighSetsChanneling", new Propagator[]{new PropNeighSetsChannel1(neighbors, g), new PropNeighSetsChannel2(neighbors, g)});
    }

    default public Constraint neighborsChanneling(UndirectedGraphVar g, BoolVar[][] neighbors) {
        return new Constraint("neighBoolsChanneling", new Propagator[]{new PropNeighBoolsChannel1(neighbors, g), new PropNeighBoolsChannel2(neighbors, g)});
    }

    default public Constraint neighborsChanneling(UndirectedGraphVar g, SetVar neighborsOf, int node) {
        return new Constraint("neighSetChanneling", new Propagator[]{new PropNeighSetChannel(neighborsOf, node, g, new IncidentSet.SuccOrNeighSet())});
    }

    default public Constraint neighborsChanneling(UndirectedGraphVar g, BoolVar[] neighborsOf, int node) {
        return new Constraint("neighBoolChanneling", new Propagator[]{new PropNeighBoolChannel(neighborsOf, node, g, new IncidentSet.SuccOrNeighSet())});
    }

    default public Constraint successorsChanneling(DirectedGraphVar g, IntVar[] successors) {
        return new Constraint("succIntsChanneling", new Propagator[]{new PropSuccIntsChannel1(successors, g), new PropNeighIntsChannel2(successors, g)});
    }

    default public Constraint successorsChanneling(DirectedGraphVar g, SetVar[] successors) {
        return new Constraint("succSetsChanneling", new Propagator[]{new PropNeighSetsChannel1(successors, g), new PropNeighSetsChannel2(successors, g)});
    }

    default public Constraint successorsChanneling(DirectedGraphVar g, BoolVar[][] successors) {
        return new Constraint("succBoolsChanneling", new Propagator[]{new PropNeighBoolsChannel1(successors, g), new PropNeighBoolsChannel2(successors, g)});
    }

    default public Constraint successorsChanneling(DirectedGraphVar g, SetVar successorsOf, int node) {
        return new Constraint("succSetChanneling", new Propagator[]{new PropNeighSetChannel(successorsOf, node, g, new IncidentSet.SuccOrNeighSet())});
    }

    default public Constraint successorsChanneling(DirectedGraphVar g, BoolVar[] successorsOf, int node) {
        return new Constraint("succBoolChanneling", new Propagator[]{new PropNeighBoolChannel(successorsOf, node, g, new IncidentSet.SuccOrNeighSet())});
    }

    default public Constraint predecessorsChanneling(DirectedGraphVar g, SetVar predecessorsOf, int node) {
        return new Constraint("predSetChanneling", new Propagator[]{new PropNeighSetChannel(predecessorsOf, node, g, new IncidentSet.PredOrNeighSet())});
    }

    default public Constraint predecessorsChanneling(DirectedGraphVar g, BoolVar[] predecessorsOf, int node) {
        return new Constraint("predBoolChanneling", new Propagator[]{new PropNeighBoolChannel(predecessorsOf, node, g, new IncidentSet.PredOrNeighSet())});
    }

    default public Constraint minDegrees(UndirectedGraphVar g, int minDegree) {
        return new Constraint("minDegrees", new Propagator[]{new PropNodeDegree_AtLeast_Incr(g, minDegree)});
    }

    default public Constraint minDegrees(UndirectedGraphVar g, int[] minDegrees) {
        return new Constraint("minDegrees", new Propagator[]{new PropNodeDegree_AtLeast_Incr(g, minDegrees)});
    }

    default public Constraint maxDegrees(UndirectedGraphVar g, int maxDegree) {
        return new Constraint("maxDegrees", new Propagator[]{new PropNodeDegree_AtMost_Coarse(g, maxDegree)});
    }

    default public Constraint maxDegrees(UndirectedGraphVar g, int[] maxDegrees) {
        return new Constraint("maxDegrees", new Propagator[]{new PropNodeDegree_AtMost_Coarse(g, maxDegrees)});
    }

    default public Constraint degrees(UndirectedGraphVar g, IntVar[] degrees) {
        return new Constraint("degrees", new Propagator[]{new PropNodeDegree_Var(g, degrees)});
    }

    default public Constraint minInDegrees(DirectedGraphVar g, int minDegree) {
        return new Constraint("minInDegrees", new Propagator[]{new PropNodeDegree_AtLeast_Incr(g, Orientation.PREDECESSORS, minDegree)});
    }

    default public Constraint minInDegrees(DirectedGraphVar g, int[] minDegrees) {
        return new Constraint("minInDegrees", new Propagator[]{new PropNodeDegree_AtLeast_Incr(g, Orientation.PREDECESSORS, minDegrees)});
    }

    default public Constraint maxInDegrees(DirectedGraphVar g, int maxDegree) {
        return new Constraint("maxInDegrees", new Propagator[]{new PropNodeDegree_AtMost_Coarse(g, Orientation.PREDECESSORS, maxDegree)});
    }

    default public Constraint maxInDegrees(DirectedGraphVar g, int[] maxDegrees) {
        return new Constraint("maxInDegrees", new Propagator[]{new PropNodeDegree_AtMost_Coarse(g, Orientation.PREDECESSORS, maxDegrees)});
    }

    default public Constraint inDegrees(DirectedGraphVar g, IntVar[] degrees) {
        return new Constraint("inDegrees", new Propagator[]{new PropNodeDegree_Var(g, Orientation.PREDECESSORS, degrees)});
    }

    default public Constraint minOutDegrees(DirectedGraphVar g, int minDegree) {
        return new Constraint("minOutDegrees", new Propagator[]{new PropNodeDegree_AtLeast_Incr(g, Orientation.SUCCESSORS, minDegree)});
    }

    default public Constraint minOutDegrees(DirectedGraphVar g, int[] minDegrees) {
        return new Constraint("minOutDegrees", new Propagator[]{new PropNodeDegree_AtLeast_Incr(g, Orientation.SUCCESSORS, minDegrees)});
    }

    default public Constraint maxOutDegrees(DirectedGraphVar g, int maxDegree) {
        return new Constraint("maxOutDegrees", new Propagator[]{new PropNodeDegree_AtMost_Coarse(g, Orientation.SUCCESSORS, maxDegree)});
    }

    default public Constraint maxOutDegrees(DirectedGraphVar g, int[] maxDegrees) {
        return new Constraint("maxOutDegrees", new Propagator[]{new PropNodeDegree_AtMost_Coarse(g, Orientation.SUCCESSORS, maxDegrees)});
    }

    default public Constraint outDegrees(DirectedGraphVar g, IntVar[] degrees) {
        return new Constraint("outDegrees", new Propagator[]{new PropNodeDegree_Var(g, Orientation.SUCCESSORS, degrees)});
    }

    default public Constraint hamiltonianCycle(UndirectedGraphVar g) {
        int m = 0;
        int n = g.getNbMaxNodes();
        for (int i = 0; i < n; ++i) {
            m += g.getPotNeighOf(i).size();
        }
        Propagator pMaxDeg = (m /= 2) < 20 * n ? new PropNodeDegree_AtMost_Incr(g, 2) : new PropNodeDegree_AtMost_Coarse(g, 2);
        return new Constraint("hamiltonianCycle", new Propagator[]{new PropNodeDegree_AtLeast_Incr(g, 2), pMaxDeg, new PropHamiltonianCycle(g)});
    }

    default public Constraint cycle(UndirectedGraphVar g) {
        if (g.getMandatoryNodes().size() == g.getNbMaxNodes()) {
            return this.hamiltonianCycle(g);
        }
        int m = 0;
        int n = g.getNbMaxNodes();
        for (int i = 0; i < n; ++i) {
            m += g.getPotNeighOf(i).size();
        }
        PropNodeDegree_AtMost_Incr pMaxDeg = (m /= 2) < 20 * n ? new PropNodeDegree_AtMost_Incr(g, 2) : new PropNodeDegree_AtMost_Incr(g, 2);
        return new Constraint("cycle", new Propagator[]{new PropNodeDegree_AtLeast_Incr(g, 2), pMaxDeg, new PropConnected(g), new PropCycle(g)});
    }

    default public Constraint hamiltonianCircuit(DirectedGraphVar g) {
        IntVar[] gint = this._me().succInts(g);
        return this._me().circuit(gint, 0);
    }

    default public Constraint circuit(DirectedGraphVar g) {
        if (g.getMandatoryNodes().size() == g.getNbMaxNodes()) {
            return this.hamiltonianCircuit(g);
        }
        return new Constraint("circuit", new Propagator[]{new PropNodeDegree_AtLeast_Incr(g, Orientation.SUCCESSORS, 1), new PropNodeDegree_AtLeast_Incr(g, Orientation.PREDECESSORS, 1), new PropNodeDegree_AtMost_Incr(g, Orientation.SUCCESSORS, 1), new PropNodeDegree_AtMost_Incr(g, Orientation.PREDECESSORS, 1), new PropNbSCC(g, g.getModel().intVar(1)), new PropCircuit(g)});
    }

    default public Constraint noCycle(UndirectedGraphVar g) {
        return new Constraint("noCycle", new Propagator[]{new PropACyclic(g)});
    }

    default public Constraint noCircuit(DirectedGraphVar g) {
        return new Constraint("noCircuit", new Propagator[]{new PropACyclic(g)});
    }

    default public Constraint connected(UndirectedGraphVar g) {
        return new Constraint("connected", new Propagator[]{new PropConnected(g)});
    }

    default public Constraint biconnected(UndirectedGraphVar g) {
        return new Constraint("connected", new Propagator[]{new PropBiconnected(g)});
    }

    default public Constraint nbConnectedComponents(UndirectedGraphVar g, IntVar nb) {
        if (nb.isInstantiatedTo(1)) {
            return this.connected(g);
        }
        if (nb.isInstantiatedTo(2)) {
            return this.connected(g);
        }
        return new Constraint("NbCC", new Propagator[]{new PropNbCC(g, nb)});
    }

    default public Constraint stronglyConnected(DirectedGraphVar g) {
        return this.nbStronglyConnectedComponents(g, g.getModel().intVar(1));
    }

    default public Constraint nbStronglyConnectedComponents(DirectedGraphVar g, IntVar nb) {
        return new Constraint("NbSCC", new Propagator[]{new PropNbSCC(g, nb)});
    }

    default public Constraint tree(UndirectedGraphVar g) {
        return new Constraint("tree", new Propagator[]{new PropACyclic(g), new PropConnected(g)});
    }

    default public Constraint forest(UndirectedGraphVar g) {
        return new Constraint("forest", new Propagator[]{new PropACyclic(g)});
    }

    default public Constraint directedTree(DirectedGraphVar g, int root) {
        int n = g.getNbMaxNodes();
        int[] nbPreds = new int[n];
        for (int i = 0; i < n; ++i) {
            nbPreds[i] = 1;
        }
        nbPreds[root] = 0;
        return new Constraint("directedTree", new Propagator[]{new PropArborescence(g, root), new PropNodeDegree_AtMost_Coarse(g, Orientation.PREDECESSORS, nbPreds), new PropNodeDegree_AtLeast_Incr(g, Orientation.PREDECESSORS, nbPreds)});
    }

    default public Constraint directedForest(DirectedGraphVar g) {
        return new Constraint("directedForest", new Propagator[]{new PropArborescences(g), new PropNodeDegree_AtMost_Coarse(g, Orientation.PREDECESSORS, 1)});
    }

    default public Constraint reachability(DirectedGraphVar g, int root) {
        return new Constraint("reachability_from_" + root, new Propagator[]{new PropReachability(g, root)});
    }

    default public Constraint path(DirectedGraphVar g, int from, int to) {
        int n = g.getNbMaxNodes();
        int[] succs = new int[n];
        int[] preds = new int[n];
        for (int i = 0; i < n; ++i) {
            preds[i] = 1;
            succs[i] = 1;
        }
        preds[from] = 0;
        succs[to] = 0;
        Propagator[] props = new Propagator[]{new PropNodeDegree_AtLeast_Coarse(g, Orientation.SUCCESSORS, succs), new PropNodeDegree_AtMost_Incr(g, Orientation.SUCCESSORS, succs), new PropNodeDegree_AtLeast_Coarse(g, Orientation.PREDECESSORS, preds), new PropNodeDegree_AtMost_Incr(g, Orientation.PREDECESSORS, preds), new PropPathNoCircuit(g)};
        return new Constraint("path", props);
    }

    default public Constraint nbCliques(UndirectedGraphVar g, IntVar nb) {
        return new Constraint("NbCliques", new Propagator[]{new PropTransitivity<UndirectedGraphVar>(g), new PropNbCC(g, nb), new PropNbCliques(g, nb)});
    }

    default public Constraint diameter(UndirectedGraphVar g, IntVar d) {
        return new Constraint("NbCliques", new Propagator[]{new PropConnected(g), new PropDiameter(g, d)});
    }

    default public Constraint diameter(DirectedGraphVar g, IntVar d) {
        return new Constraint("NbCliques", new Propagator[]{new PropNbSCC(g, g.getModel().intVar(1)), new PropDiameter(g, d)});
    }

    default public Constraint tsp(UndirectedGraphVar GRAPHVAR, IntVar COSTVAR, int[][] EDGE_COSTS, int LAGR_MODE) {
        Propagator[] props = (Propagator[])ArrayUtils.append((Object[][])new Propagator[][]{this.hamiltonianCycle(GRAPHVAR).getPropagators(), {new PropCycleCostSimple(GRAPHVAR, COSTVAR, EDGE_COSTS)}});
        if (LAGR_MODE > 0) {
            PropLagr_OneTree hk = new PropLagr_OneTree(GRAPHVAR, COSTVAR, EDGE_COSTS);
            hk.waitFirstSolution(LAGR_MODE == 2);
            props = (Propagator[])ArrayUtils.append((Object[][])new Propagator[][]{props, {hk}});
        }
        return new Constraint("TSP", props);
    }

    default public Constraint dcmst(UndirectedGraphVar GRAPH, IntVar[] DEGREES, IntVar COSTVAR, int[][] EDGE_COSTS, int LAGR_MODE) {
        Propagator[] props = (Propagator[])ArrayUtils.append((Object[][])new Propagator[][]{this.tree(GRAPH).getPropagators(), {new PropTreeCostSimple(GRAPH, COSTVAR, EDGE_COSTS), new PropMaxDegVarTree(GRAPH, DEGREES)}});
        if (LAGR_MODE > 0) {
            PropLagr_DCMST_generic hk = new PropLagr_DCMST_generic(GRAPH, COSTVAR, DEGREES, EDGE_COSTS, LAGR_MODE == 2);
            props = (Propagator[])ArrayUtils.append((Object[][])new Propagator[][]{props, {hk}});
        }
        return new Constraint("dcmst", props);
    }

    default public void postSymmetryBreaking(DirectedGraphVar graph) {
        int i;
        GraphModel m = this._me();
        int n = graph.getNbMaxNodes();
        BoolVar[] t = m.boolVarArray("T[]", n * n);
        IntVar[] p = new IntVar[n];
        p[0] = m.intVar("P[0]", 0);
        for (i = 1; i < n; ++i) {
            p[i] = m.intVar("P[" + i + "]", 0, i - 1);
        }
        new Constraint("AdjacencyMatrix", new Propagator[]{new PropIncrementalAdjacencyMatrix(graph, t)}).post();
        for (i = 0; i < n - 1; ++i) {
            IntVar I = m.intVar(i);
            for (int j = 1; j < n; ++j) {
                BoolVar[] clause = new BoolVar[i + 1];
                clause[i] = t[i + j * n];
                for (int k = 0; k < i; ++k) {
                    clause[k] = t[k + j * n].not();
                }
                Constraint c = m.and(clause);
                Constraint pij = m.arithm(p[j], "=", I);
                m.ifThen(pij, c);
                m.ifThen(c, pij);
            }
        }
        for (i = 1; i < n - 1; ++i) {
            m.arithm(p[i], "<=", p[i + 1]).post();
        }
    }

    default public void postSymmetryBreaking(UndirectedGraphVar graph) {
        int i;
        GraphModel m = this._me();
        int n = graph.getNbMaxNodes();
        BoolVar[] t = m.boolVarArray("T[]", n * n);
        IntVar[] p = new IntVar[n];
        p[0] = m.intVar("P[0]", 0);
        for (i = 1; i < n; ++i) {
            p[i] = m.intVar("P[" + i + "]", 0, i - 1);
        }
        new Constraint("AdjacencyMatrix", new Propagator[]{new PropIncrementalAdjacencyUndirectedMatrix(graph, t)}).post();
        for (i = 0; i < n - 1; ++i) {
            IntVar I = m.intVar(i);
            for (int j = 1; j < n; ++j) {
                BoolVar[] clause = new BoolVar[i + 1];
                clause[i] = t[i + j * n];
                for (int k = 0; k < i; ++k) {
                    clause[k] = t[k + j * n].not();
                }
                Constraint c = m.and(clause);
                Constraint pij = m.arithm(p[j], "=", I);
                m.ifThen(pij, c);
                m.ifThen(c, pij);
            }
        }
        for (i = 1; i < n - 1; ++i) {
            m.arithm(p[i], "<=", p[i + 1]).post();
        }
    }

    default public Constraint symmetryBreaking2(UndirectedGraphVar graph) {
        int n = graph.getNbMaxNodes();
        BoolVar[] t = this._me().boolVarArray("T[]", n * n);
        return new Constraint("symmBreak", new Propagator[]{new PropIncrementalAdjacencyUndirectedMatrix(graph, t), new PropSymmetryBreaking(t)});
    }

    default public Constraint symmetryBreaking3(UndirectedGraphVar graph) {
        int n = graph.getNbMaxNodes();
        BoolVar[] t = this._me().boolVarArray("T[]", n * n);
        return new Constraint("symmBreakEx", new Propagator[]{new PropIncrementalAdjacencyUndirectedMatrix(graph, t), new PropSymmetryBreakingEx(t)});
    }
}

