/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver;

import java.util.ArrayList;
import org.chocosolver.graphsolver.cstrs.IGraphConstraintFactory;
import org.chocosolver.graphsolver.search.strategy.GraphStrategy;
import org.chocosolver.graphsolver.variables.GraphVar;
import org.chocosolver.graphsolver.variables.IGraphVarFactory;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.Settings;
import org.chocosolver.solver.search.strategy.Search;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.Variable;

public class GraphModel
extends Model
implements IGraphVarFactory,
IGraphConstraintFactory {
    public GraphModel(String name) {
        super(name);
        this.set(new Settings(){

            public AbstractStrategy makeDefaultSearch(Model model) {
                AbstractStrategy other = Search.defaultSearch((Model)model);
                GraphVar[] gvs = GraphModel.this.retrieveGraphVars();
                if (gvs.length == 0) {
                    return other;
                }
                AbstractStrategy[] gss = new AbstractStrategy[gvs.length + 1];
                for (int i = 0; i < gvs.length; ++i) {
                    gss[i] = new GraphStrategy(gvs[i]);
                }
                gss[gvs.length] = other;
                return Search.sequencer((AbstractStrategy[])gss);
            }
        });
    }

    public GraphModel() {
        this("Graph Model");
    }

    public GraphVar[] retrieveGraphVars() {
        ArrayList<GraphVar> gvars = new ArrayList<GraphVar>();
        for (Variable v : this.getVars()) {
            if ((v.getTypeAndKind() & 0x3F8) != 128) continue;
            gvars.add((GraphVar)v);
        }
        return gvars.toArray(new GraphVar[gvars.size()]);
    }

    @Override
    public GraphModel _me() {
        return this;
    }
}

