/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.MethodHelper;
import org.testng.internal.Utils;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class FailedReporter
extends TestListenerAdapter
implements IReporter {
    public static final String TESTNG_FAILED_XML = "testng-failed.xml";
    private XmlSuite m_xmlSuite;

    public FailedReporter() {
    }

    public FailedReporter(XmlSuite xmlSuite) {
        this.m_xmlSuite = xmlSuite;
    }

    @Override
    public void generateReport(List<XmlSuite> list, List<ISuite> list2, String string) {
        for (ISuite iSuite : list2) {
            this.generateFailureSuite(iSuite.getXmlSuite(), iSuite, string);
        }
    }

    protected void generateFailureSuite(XmlSuite xmlSuite, ISuite iSuite, String string) {
        XmlSuite xmlSuite2 = xmlSuite.shallowCopy();
        xmlSuite2.setName("Failed suite [" + xmlSuite.getName() + "]");
        this.m_xmlSuite = xmlSuite2;
        Map<String, ISuiteResult> map = iSuite.getResults();
        for (Map.Entry<String, ISuiteResult> entry : map.entrySet()) {
            ISuiteResult iSuiteResult = entry.getValue();
            ITestContext iTestContext = iSuiteResult.getTestContext();
            this.generateXmlTest(iTestContext.getCurrentXmlTest(), iTestContext, iTestContext.getFailedTests().getAllResults(), iTestContext.getSkippedTests().getAllResults());
        }
        if (null != xmlSuite2.getTests() && xmlSuite2.getTests().size() > 0) {
            Utils.writeUtf8File(string, TESTNG_FAILED_XML, xmlSuite2.toXml());
            Utils.writeUtf8File(iSuite.getOutputDirectory(), TESTNG_FAILED_XML, xmlSuite2.toXml());
        }
    }

    private void generateXmlTest(XmlTest xmlTest, ITestContext iTestContext, Set<ITestResult> set, Set<ITestResult> set2) {
        if (set2.size() > 0 || set.size() > 0) {
            Set set3 = Sets.newHashSet();
            HashSet<ITestResult> hashSet = new HashSet<ITestResult>();
            hashSet.addAll(set);
            hashSet.addAll(set2);
            for (ITestResult object2 : hashSet) {
                ITestNGMethod[] iTestNGMethodArray = object2.getMethod();
                if (!iTestNGMethodArray.isTest()) continue;
                set3.add(iTestNGMethodArray);
                List<ITestNGMethod> list = MethodHelper.getMethodsDependedUpon((ITestNGMethod)iTestNGMethodArray, iTestContext.getAllTestMethods());
                for (ITestNGMethod iTestNGMethod : list) {
                    if (!iTestNGMethod.isTest()) continue;
                    set3.add(iTestNGMethod);
                }
            }
            List list = Lists.newArrayList();
            Set<ITestNGMethod> set4 = Sets.newHashSet();
            for (ITestNGMethod iTestNGMethod : iTestContext.getAllTestMethods()) {
                if (!set3.contains(iTestNGMethod)) continue;
                list.add(iTestNGMethod);
                FailedReporter.getAllApplicableConfigs(set4, iTestNGMethod.getTestClass());
            }
            list.addAll(set4);
            this.createXmlTest(iTestContext, list, xmlTest);
        }
    }

    private static void getAllApplicableConfigs(Set<ITestNGMethod> set, ITestClass iTestClass) {
        set.addAll(Arrays.asList(iTestClass.getBeforeSuiteMethods()));
        set.addAll(Arrays.asList(iTestClass.getAfterSuiteMethods()));
        set.addAll(Arrays.asList(iTestClass.getBeforeTestConfigurationMethods()));
        set.addAll(Arrays.asList(iTestClass.getAfterTestConfigurationMethods()));
        set.addAll(Arrays.asList(iTestClass.getBeforeTestMethods()));
        set.addAll(Arrays.asList(iTestClass.getAfterTestMethods()));
        set.addAll(Arrays.asList(iTestClass.getBeforeClassMethods()));
        set.addAll(Arrays.asList(iTestClass.getAfterClassMethods()));
    }

    private void createXmlTest(ITestContext iTestContext, List<ITestNGMethod> list, XmlTest xmlTest) {
        XmlTest xmlTest2 = new XmlTest(this.m_xmlSuite);
        xmlTest2.setName(iTestContext.getName() + "(failed)");
        xmlTest2.setBeanShellExpression(xmlTest.getExpression());
        xmlTest2.setIncludedGroups(xmlTest.getIncludedGroups());
        xmlTest2.setExcludedGroups(xmlTest.getExcludedGroups());
        xmlTest2.setParallel(xmlTest.getParallel());
        xmlTest2.setParameters(xmlTest.getLocalParameters());
        xmlTest2.setJUnit(xmlTest.isJUnit());
        List<XmlClass> list2 = this.createXmlClasses(list, xmlTest);
        xmlTest2.setXmlClasses(list2);
    }

    /*
     * WARNING - void declaration
     */
    private List<XmlClass> createXmlClasses(List<ITestNGMethod> list, XmlTest xmlTest) {
        Serializable serializable;
        List<XmlClass> list2 = Lists.newArrayList();
        Map<Class<?>, Serializable> map = Maps.newHashMap();
        for (ITestNGMethod object : list) {
            Object object2 = object.getInstance();
            Class<?> clazz = object2 == null ? object.getRealClass() : object2.getClass();
            serializable = (HashSet<ITestNGMethod>)map.get(clazz);
            if (null == serializable) {
                serializable = new HashSet<ITestNGMethod>();
                map.put(clazz, serializable);
            }
            serializable.add(object);
        }
        Map map2 = Maps.newHashMap();
        for (XmlClass xmlClass : xmlTest.getClasses()) {
            map2.putAll(xmlClass.getLocalParameters());
        }
        boolean bl = false;
        for (Map.Entry entry : map.entrySet()) {
            void var6_9;
            serializable = (Class)entry.getKey();
            Set set = (Set)entry.getValue();
            XmlClass xmlClass = new XmlClass(((Class)serializable).getName(), (int)(++var6_9), false);
            List<XmlInclude> list3 = Lists.newArrayList(set.size());
            int n = 0;
            for (ITestNGMethod iTestNGMethod : set) {
                XmlInclude xmlInclude = new XmlInclude(iTestNGMethod.getConstructorOrMethod().getName(), iTestNGMethod.getFailedInvocationNumbers(), n++);
                xmlInclude.setParameters(FailedReporter.findMethodLocalParameters(xmlTest, iTestNGMethod));
                list3.add(xmlInclude);
            }
            xmlClass.setIncludedMethods(list3);
            xmlClass.setParameters(map2);
            list2.add(xmlClass);
        }
        return list2;
    }

    private static Map<String, String> findMethodLocalParameters(XmlTest xmlTest, ITestNGMethod iTestNGMethod) {
        Class clazz = iTestNGMethod.getRealClass();
        for (XmlClass xmlClass : xmlTest.getClasses()) {
            if (clazz != xmlClass.getSupportClass()) continue;
            for (XmlInclude xmlInclude : xmlClass.getIncludedMethods()) {
                if (!xmlInclude.getName().equals(iTestNGMethod.getMethodName())) continue;
                return xmlInclude.getLocalParameters();
            }
        }
        return Collections.emptyMap();
    }
}

