/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.testng.ITestNGMethod;
import org.testng.annotations.IAnnotation;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.annotations.IDataProviderAnnotation;
import org.testng.annotations.IExpectedExceptionsAnnotation;
import org.testng.annotations.IFactoryAnnotation;
import org.testng.annotations.IParametersAnnotation;
import org.testng.annotations.ITestAnnotation;
import org.testng.collections.Maps;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.TestNGMethod;
import org.testng.internal.Utils;
import org.testng.internal.annotations.ConfigurationAnnotation;
import org.testng.internal.annotations.IAfterClass;
import org.testng.internal.annotations.IAfterGroups;
import org.testng.internal.annotations.IAfterMethod;
import org.testng.internal.annotations.IAfterSuite;
import org.testng.internal.annotations.IAfterTest;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IBeforeClass;
import org.testng.internal.annotations.IBeforeGroups;
import org.testng.internal.annotations.IBeforeMethod;
import org.testng.internal.annotations.IBeforeSuite;
import org.testng.internal.annotations.IBeforeTest;
import org.testng.internal.reflect.ReflectionHelper;
import org.testng.xml.XmlTest;

public class AnnotationHelper {
    private static final Class[] ALL_ANNOTATIONS = new Class[]{ITestAnnotation.class, IConfigurationAnnotation.class, IBeforeClass.class, IAfterClass.class, IBeforeMethod.class, IAfterMethod.class, IDataProviderAnnotation.class, IExpectedExceptionsAnnotation.class, IFactoryAnnotation.class, IParametersAnnotation.class, IBeforeSuite.class, IAfterSuite.class, IBeforeTest.class, IAfterTest.class, IBeforeGroups.class, IAfterGroups.class};
    public static final Class[] CONFIGURATION_CLASSES = new Class[]{IConfigurationAnnotation.class, IBeforeSuite.class, IAfterSuite.class, IBeforeTest.class, IAfterTest.class, IBeforeGroups.class, IAfterGroups.class, IBeforeClass.class, IAfterClass.class, IBeforeMethod.class, IAfterMethod.class};

    private AnnotationHelper() {
    }

    public static ITestAnnotation findTest(IAnnotationFinder iAnnotationFinder, Class<?> clazz) {
        return iAnnotationFinder.findAnnotation(clazz, ITestAnnotation.class);
    }

    public static ITestAnnotation findTest(IAnnotationFinder iAnnotationFinder, Method method) {
        return iAnnotationFinder.findAnnotation(method, ITestAnnotation.class);
    }

    public static ITestAnnotation findTest(IAnnotationFinder iAnnotationFinder, ITestNGMethod iTestNGMethod) {
        return iAnnotationFinder.findAnnotation(iTestNGMethod, ITestAnnotation.class);
    }

    public static IFactoryAnnotation findFactory(IAnnotationFinder iAnnotationFinder, Method method) {
        return iAnnotationFinder.findAnnotation(method, IFactoryAnnotation.class);
    }

    public static IFactoryAnnotation findFactory(IAnnotationFinder iAnnotationFinder, Constructor constructor) {
        return iAnnotationFinder.findAnnotation(constructor, IFactoryAnnotation.class);
    }

    public static ITestAnnotation findTest(IAnnotationFinder iAnnotationFinder, Constructor constructor) {
        return iAnnotationFinder.findAnnotation(constructor, ITestAnnotation.class);
    }

    public static IConfigurationAnnotation findConfiguration(IAnnotationFinder iAnnotationFinder, ConstructorOrMethod constructorOrMethod) {
        if (constructorOrMethod.getMethod() != null) {
            return AnnotationHelper.findConfiguration(iAnnotationFinder, constructorOrMethod.getMethod());
        }
        if (constructorOrMethod.getConstructor() != null) {
            return AnnotationHelper.findConfiguration(iAnnotationFinder, constructorOrMethod.getConstructor());
        }
        return null;
    }

    public static IConfigurationAnnotation findConfiguration(IAnnotationFinder iAnnotationFinder, Constructor constructor) {
        IConfigurationAnnotation iConfigurationAnnotation = iAnnotationFinder.findAnnotation(constructor, IConfigurationAnnotation.class);
        if (iConfigurationAnnotation == null) {
            IConfigurationAnnotation iConfigurationAnnotation2 = (IConfigurationAnnotation)((Object)iAnnotationFinder.findAnnotation(constructor, IBeforeSuite.class));
            IConfigurationAnnotation iConfigurationAnnotation3 = (IConfigurationAnnotation)((Object)iAnnotationFinder.findAnnotation(constructor, IAfterSuite.class));
            IConfigurationAnnotation iConfigurationAnnotation4 = (IConfigurationAnnotation)((Object)iAnnotationFinder.findAnnotation(constructor, IBeforeTest.class));
            IConfigurationAnnotation iConfigurationAnnotation5 = (IConfigurationAnnotation)((Object)iAnnotationFinder.findAnnotation(constructor, IAfterTest.class));
            IConfigurationAnnotation iConfigurationAnnotation6 = (IConfigurationAnnotation)((Object)iAnnotationFinder.findAnnotation(constructor, IBeforeGroups.class));
            IConfigurationAnnotation iConfigurationAnnotation7 = (IConfigurationAnnotation)((Object)iAnnotationFinder.findAnnotation(constructor, IAfterGroups.class));
            IConfigurationAnnotation iConfigurationAnnotation8 = (IConfigurationAnnotation)((Object)iAnnotationFinder.findAnnotation(constructor, IBeforeClass.class));
            IConfigurationAnnotation iConfigurationAnnotation9 = (IConfigurationAnnotation)((Object)iAnnotationFinder.findAnnotation(constructor, IAfterClass.class));
            IConfigurationAnnotation iConfigurationAnnotation10 = (IConfigurationAnnotation)((Object)iAnnotationFinder.findAnnotation(constructor, IBeforeMethod.class));
            IConfigurationAnnotation iConfigurationAnnotation11 = (IConfigurationAnnotation)((Object)iAnnotationFinder.findAnnotation(constructor, IAfterMethod.class));
            if (iConfigurationAnnotation2 != null || iConfigurationAnnotation3 != null || iConfigurationAnnotation4 != null || iConfigurationAnnotation5 != null || iConfigurationAnnotation6 != null || iConfigurationAnnotation7 != null || iConfigurationAnnotation8 != null || iConfigurationAnnotation9 != null || iConfigurationAnnotation10 != null || iConfigurationAnnotation11 != null) {
                iConfigurationAnnotation = AnnotationHelper.createConfiguration(iConfigurationAnnotation2, iConfigurationAnnotation3, iConfigurationAnnotation4, iConfigurationAnnotation5, iConfigurationAnnotation6, iConfigurationAnnotation7, iConfigurationAnnotation8, iConfigurationAnnotation9, iConfigurationAnnotation10, iConfigurationAnnotation11);
            }
        }
        return iConfigurationAnnotation;
    }

    public static IConfigurationAnnotation findConfiguration(IAnnotationFinder iAnnotationFinder, Method method) {
        IConfigurationAnnotation iConfigurationAnnotation = iAnnotationFinder.findAnnotation(method, IConfigurationAnnotation.class);
        if (iConfigurationAnnotation == null) {
            IConfigurationAnnotation iConfigurationAnnotation2 = (IConfigurationAnnotation)((Object)iAnnotationFinder.findAnnotation(method, IBeforeSuite.class));
            IConfigurationAnnotation iConfigurationAnnotation3 = (IConfigurationAnnotation)((Object)iAnnotationFinder.findAnnotation(method, IAfterSuite.class));
            IConfigurationAnnotation iConfigurationAnnotation4 = (IConfigurationAnnotation)((Object)iAnnotationFinder.findAnnotation(method, IBeforeTest.class));
            IConfigurationAnnotation iConfigurationAnnotation5 = (IConfigurationAnnotation)((Object)iAnnotationFinder.findAnnotation(method, IAfterTest.class));
            IConfigurationAnnotation iConfigurationAnnotation6 = (IConfigurationAnnotation)((Object)iAnnotationFinder.findAnnotation(method, IBeforeGroups.class));
            IConfigurationAnnotation iConfigurationAnnotation7 = (IConfigurationAnnotation)((Object)iAnnotationFinder.findAnnotation(method, IAfterGroups.class));
            IConfigurationAnnotation iConfigurationAnnotation8 = (IConfigurationAnnotation)((Object)iAnnotationFinder.findAnnotation(method, IBeforeClass.class));
            IConfigurationAnnotation iConfigurationAnnotation9 = (IConfigurationAnnotation)((Object)iAnnotationFinder.findAnnotation(method, IAfterClass.class));
            IConfigurationAnnotation iConfigurationAnnotation10 = (IConfigurationAnnotation)((Object)iAnnotationFinder.findAnnotation(method, IBeforeMethod.class));
            IConfigurationAnnotation iConfigurationAnnotation11 = (IConfigurationAnnotation)((Object)iAnnotationFinder.findAnnotation(method, IAfterMethod.class));
            if (iConfigurationAnnotation2 != null || iConfigurationAnnotation3 != null || iConfigurationAnnotation4 != null || iConfigurationAnnotation5 != null || iConfigurationAnnotation6 != null || iConfigurationAnnotation7 != null || iConfigurationAnnotation8 != null || iConfigurationAnnotation9 != null || iConfigurationAnnotation10 != null || iConfigurationAnnotation11 != null) {
                iConfigurationAnnotation = AnnotationHelper.createConfiguration(iConfigurationAnnotation2, iConfigurationAnnotation3, iConfigurationAnnotation4, iConfigurationAnnotation5, iConfigurationAnnotation6, iConfigurationAnnotation7, iConfigurationAnnotation8, iConfigurationAnnotation9, iConfigurationAnnotation10, iConfigurationAnnotation11);
            }
        }
        return iConfigurationAnnotation;
    }

    private static IConfigurationAnnotation createConfiguration(IConfigurationAnnotation iConfigurationAnnotation, IConfigurationAnnotation iConfigurationAnnotation2, IConfigurationAnnotation iConfigurationAnnotation3, IConfigurationAnnotation iConfigurationAnnotation4, IConfigurationAnnotation iConfigurationAnnotation5, IConfigurationAnnotation iConfigurationAnnotation6, IConfigurationAnnotation iConfigurationAnnotation7, IConfigurationAnnotation iConfigurationAnnotation8, IConfigurationAnnotation iConfigurationAnnotation9, IConfigurationAnnotation iConfigurationAnnotation10) {
        ConfigurationAnnotation configurationAnnotation = new ConfigurationAnnotation();
        if (iConfigurationAnnotation != null) {
            configurationAnnotation.setBeforeSuite(true);
            AnnotationHelper.finishInitialize(configurationAnnotation, iConfigurationAnnotation);
        }
        if (iConfigurationAnnotation2 != null) {
            configurationAnnotation.setAfterSuite(true);
            AnnotationHelper.finishInitialize(configurationAnnotation, iConfigurationAnnotation2);
        }
        if (iConfigurationAnnotation3 != null) {
            configurationAnnotation.setBeforeTest(true);
            AnnotationHelper.finishInitialize(configurationAnnotation, iConfigurationAnnotation3);
        }
        if (iConfigurationAnnotation4 != null) {
            configurationAnnotation.setAfterTest(true);
            AnnotationHelper.finishInitialize(configurationAnnotation, iConfigurationAnnotation4);
        }
        if (iConfigurationAnnotation5 != null) {
            configurationAnnotation.setBeforeGroups(iConfigurationAnnotation5.getBeforeGroups());
            AnnotationHelper.finishInitialize(configurationAnnotation, iConfigurationAnnotation5);
        }
        if (iConfigurationAnnotation6 != null) {
            configurationAnnotation.setAfterGroups(iConfigurationAnnotation6.getAfterGroups());
            AnnotationHelper.finishInitialize(configurationAnnotation, iConfigurationAnnotation6);
        }
        if (iConfigurationAnnotation7 != null) {
            configurationAnnotation.setBeforeTestClass(true);
            AnnotationHelper.finishInitialize(configurationAnnotation, iConfigurationAnnotation7);
        }
        if (iConfigurationAnnotation8 != null) {
            configurationAnnotation.setAfterTestClass(true);
            AnnotationHelper.finishInitialize(configurationAnnotation, iConfigurationAnnotation8);
        }
        if (iConfigurationAnnotation9 != null) {
            configurationAnnotation.setBeforeTestMethod(true);
            AnnotationHelper.finishInitialize(configurationAnnotation, iConfigurationAnnotation9);
        }
        if (iConfigurationAnnotation10 != null) {
            configurationAnnotation.setAfterTestMethod(true);
            AnnotationHelper.finishInitialize(configurationAnnotation, iConfigurationAnnotation10);
        }
        return configurationAnnotation;
    }

    private static void finishInitialize(ConfigurationAnnotation configurationAnnotation, IConfigurationAnnotation iConfigurationAnnotation) {
        configurationAnnotation.setFakeConfiguration(true);
        configurationAnnotation.setAlwaysRun(iConfigurationAnnotation.getAlwaysRun());
        configurationAnnotation.setDependsOnGroups(iConfigurationAnnotation.getDependsOnGroups());
        configurationAnnotation.setDependsOnMethods(iConfigurationAnnotation.getDependsOnMethods());
        configurationAnnotation.setDescription(iConfigurationAnnotation.getDescription());
        configurationAnnotation.setEnabled(iConfigurationAnnotation.getEnabled());
        configurationAnnotation.setGroups(iConfigurationAnnotation.getGroups());
        configurationAnnotation.setInheritGroups(iConfigurationAnnotation.getInheritGroups());
        configurationAnnotation.setParameters(iConfigurationAnnotation.getParameters());
        configurationAnnotation.setTimeOut(iConfigurationAnnotation.getTimeOut());
    }

    public static Class[] getAllAnnotations() {
        return ALL_ANNOTATIONS;
    }

    public static ITestNGMethod[] findMethodsWithAnnotation(Class<?> clazz, Class<? extends IAnnotation> clazz2, IAnnotationFinder iAnnotationFinder, XmlTest xmlTest) {
        Map<String, TestNGMethod> map = Maps.newHashMap();
        try {
            map = Maps.newHashMap();
            for (Class<?> clazz3 = clazz; null != clazz3; clazz3 = clazz3.getSuperclass()) {
                Method[] methodArray;
                boolean bl = AnnotationHelper.isAnnotationPresent(iAnnotationFinder, clazz3, clazz2);
                for (Method method : methodArray = ReflectionHelper.getLocalMethods(clazz3)) {
                    boolean bl2 = AnnotationHelper.isAnnotationPresent(iAnnotationFinder, method, clazz2);
                    boolean bl3 = AnnotationHelper.isAnnotationPresent(iAnnotationFinder, method, IFactoryAnnotation.class) || AnnotationHelper.isAnnotationPresent(iAnnotationFinder, method, ITestAnnotation.class) || AnnotationHelper.isAnnotationPresent(iAnnotationFinder, method, CONFIGURATION_CLASSES);
                    boolean bl4 = Modifier.isPublic(method.getModifiers());
                    boolean bl5 = method.isSynthetic();
                    if ((!bl4 || !bl || bl5 || bl3) && !bl2) continue;
                    if (AnnotationHelper.isAnnotationPresent(iAnnotationFinder, method, IConfigurationAnnotation.class) && AnnotationHelper.isAnnotationPresent(iAnnotationFinder, clazz3, ITestAnnotation.class)) {
                        Utils.log("", 3, "Method " + method + " has a configuration annotation and a class-level @Test. This method will only be kept as a configuration method.");
                        continue;
                    }
                    if (method.getReturnType() != Void.TYPE && !xmlTest.getAllowReturnValues().booleanValue()) {
                        Utils.log("", 2, "Method " + method + " has a @Test annotation but also a return value: ignoring it. Use <suite allow-return-values=\"true\"> to fix this");
                        continue;
                    }
                    String string = AnnotationHelper.createMethodKey(method);
                    if (null != map.get(string)) continue;
                    TestNGMethod testNGMethod = new TestNGMethod(method, iAnnotationFinder, xmlTest, null);
                    map.put(string, testNGMethod);
                }
            }
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        return map.values().toArray(new ITestNGMethod[map.size()]);
    }

    public static Annotation findAnnotationSuperClasses(Class<?> clazz, Class clazz2) {
        for (Class clazz3 = clazz2; clazz3 != null; clazz3 = clazz3.getSuperclass()) {
            Object obj = clazz3.getAnnotation(clazz);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    private static boolean isAnnotationPresent(IAnnotationFinder iAnnotationFinder, Method method, Class[] classArray) {
        for (Class clazz : classArray) {
            if (iAnnotationFinder.findAnnotation(method, clazz) == null) continue;
            return true;
        }
        return false;
    }

    private static boolean isAnnotationPresent(IAnnotationFinder iAnnotationFinder, Method method, Class<? extends IAnnotation> clazz) {
        return iAnnotationFinder.findAnnotation(method, clazz) != null;
    }

    private static boolean isAnnotationPresent(IAnnotationFinder iAnnotationFinder, Class<?> clazz, Class<? extends IAnnotation> clazz2) {
        return iAnnotationFinder.findAnnotation(clazz, clazz2) != null;
    }

    private static String createMethodKey(Method method) {
        StringBuilder stringBuilder = new StringBuilder(method.getName());
        for (Class<?> clazz : method.getParameterTypes()) {
            stringBuilder.append(' ').append(clazz.toString());
        }
        return stringBuilder.toString();
    }
}

