/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.testng.internal.Utils;
import org.testng.internal.XmlMethodSelector;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.ScalarNode;

public final class Yaml {
    private Yaml() {
    }

    public static XmlSuite parse(String string, InputStream inputStream) throws FileNotFoundException {
        TestNGConstructor testNGConstructor = new TestNGConstructor(XmlSuite.class);
        Object object = new TypeDescription(XmlSuite.class);
        ((TypeDescription)object).putListPropertyType("packages", XmlPackage.class);
        ((TypeDescription)object).putListPropertyType("listeners", String.class);
        ((TypeDescription)object).putListPropertyType("tests", XmlTest.class);
        ((TypeDescription)object).putListPropertyType("method-selectors", XmlMethodSelector.class);
        testNGConstructor.addTypeDescription((TypeDescription)object);
        object = new TypeDescription(XmlTest.class);
        ((TypeDescription)object).putListPropertyType("classes", XmlClass.class);
        ((TypeDescription)object).putMapPropertyType("metaGroups", String.class, List.class);
        ((TypeDescription)object).putListPropertyType("method-selectors", XmlMethodSelector.class);
        testNGConstructor.addTypeDescription((TypeDescription)object);
        object = new org.yaml.snakeyaml.Yaml(testNGConstructor);
        if (inputStream == null) {
            inputStream = new FileInputStream(new File(string));
        }
        XmlSuite xmlSuite = (XmlSuite)((org.yaml.snakeyaml.Yaml)object).load(inputStream);
        xmlSuite.setFileName(string);
        for (XmlTest xmlTest : xmlSuite.getTests()) {
            xmlTest.setSuite(xmlSuite);
            int n = 0;
            for (XmlClass xmlClass : xmlTest.getClasses()) {
                xmlClass.setIndex(n++);
            }
        }
        return xmlSuite;
    }

    private static void maybeAdd(StringBuilder stringBuilder, String string, Object object, Object object2) {
        Yaml.maybeAdd(stringBuilder, "", string, object, object2);
    }

    private static void maybeAdd(StringBuilder stringBuilder, String string, String string2, Object object, Object object2) {
        if (object != null && !object.equals(object2)) {
            stringBuilder.append(string).append(string2).append(": ").append(object.toString()).append("\n");
        }
    }

    public static StringBuilder toYaml(XmlSuite xmlSuite) {
        StringBuilder stringBuilder = new StringBuilder();
        Yaml.maybeAdd(stringBuilder, "name", xmlSuite.getName(), null);
        Yaml.maybeAdd(stringBuilder, "junit", xmlSuite.isJUnit(), XmlSuite.DEFAULT_JUNIT);
        Yaml.maybeAdd(stringBuilder, "verbose", xmlSuite.getVerbose(), XmlSuite.DEFAULT_VERBOSE);
        Yaml.maybeAdd(stringBuilder, "threadCount", xmlSuite.getThreadCount(), XmlSuite.DEFAULT_THREAD_COUNT);
        Yaml.maybeAdd(stringBuilder, "dataProviderThreadCount", xmlSuite.getDataProviderThreadCount(), XmlSuite.DEFAULT_DATA_PROVIDER_THREAD_COUNT);
        Yaml.maybeAdd(stringBuilder, "timeOut", xmlSuite.getTimeOut(), null);
        Yaml.maybeAdd(stringBuilder, "parallel", (Object)xmlSuite.getParallel(), (Object)XmlSuite.DEFAULT_PARALLEL);
        Yaml.maybeAdd(stringBuilder, "configFailurePolicy", xmlSuite.getConfigFailurePolicy().toString(), (Object)XmlSuite.DEFAULT_CONFIG_FAILURE_POLICY);
        Yaml.maybeAdd(stringBuilder, "skipFailedInvocationCounts", xmlSuite.skipFailedInvocationCounts(), XmlSuite.DEFAULT_SKIP_FAILED_INVOCATION_COUNTS);
        Yaml.toYaml(stringBuilder, "parameters", "", xmlSuite.getParameters());
        Yaml.toYaml(stringBuilder, xmlSuite.getPackages());
        if (!xmlSuite.getListeners().isEmpty()) {
            stringBuilder.append("listeners:\n");
            Yaml.toYaml(stringBuilder, "  ", xmlSuite.getListeners());
        }
        if (!xmlSuite.getPackages().isEmpty()) {
            stringBuilder.append("packages:\n");
            Yaml.toYaml(stringBuilder, xmlSuite.getPackages());
        }
        if (!xmlSuite.getTests().isEmpty()) {
            stringBuilder.append("tests:\n");
            for (XmlTest xmlTest : xmlSuite.getTests()) {
                Yaml.toYaml(stringBuilder, "  ", xmlTest);
            }
        }
        if (!xmlSuite.getChildSuites().isEmpty()) {
            stringBuilder.append("suite-files:\n");
            Yaml.toYaml(stringBuilder, "  ", xmlSuite.getSuiteFiles());
        }
        return stringBuilder;
    }

    private static void toYaml(StringBuilder stringBuilder, String string, XmlTest xmlTest) {
        Map<String, List<String>> map;
        String string2 = string + "  ";
        stringBuilder.append(string).append("- name: ").append(xmlTest.getName()).append("\n");
        Yaml.maybeAdd(stringBuilder, string2, "junit", xmlTest.isJUnit(), XmlSuite.DEFAULT_JUNIT);
        Yaml.maybeAdd(stringBuilder, string2, "verbose", xmlTest.getVerbose(), XmlSuite.DEFAULT_VERBOSE);
        Yaml.maybeAdd(stringBuilder, string2, "timeOut", xmlTest.getTimeOut(), null);
        Yaml.maybeAdd(stringBuilder, string2, "parallel", (Object)xmlTest.getParallel(), (Object)XmlSuite.DEFAULT_PARALLEL);
        Yaml.maybeAdd(stringBuilder, string2, "skipFailedInvocationCounts", xmlTest.skipFailedInvocationCounts(), XmlSuite.DEFAULT_SKIP_FAILED_INVOCATION_COUNTS);
        Yaml.maybeAdd(stringBuilder, "preserveOrder", string2, xmlTest.getPreserveOrder(), XmlSuite.DEFAULT_PRESERVE_ORDER);
        Yaml.toYaml(stringBuilder, "parameters", string2, xmlTest.getLocalParameters());
        if (!xmlTest.getIncludedGroups().isEmpty()) {
            stringBuilder.append(string2).append("includedGroups: [ ").append(Utils.join(xmlTest.getIncludedGroups(), ",")).append(" ]\n");
        }
        if (!xmlTest.getExcludedGroups().isEmpty()) {
            stringBuilder.append(string2).append("excludedGroups: [ ").append(Utils.join(xmlTest.getExcludedGroups(), ",")).append(" ]\n");
        }
        if ((map = xmlTest.getMetaGroups()).size() > 0) {
            stringBuilder.append(string2).append("metaGroups: { ");
            boolean bl = true;
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                if (!bl) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(entry.getKey()).append(": [ ").append(Utils.join(entry.getValue(), ",")).append(" ] ");
                bl = false;
            }
            stringBuilder.append(" }\n");
        }
        if (!xmlTest.getXmlPackages().isEmpty()) {
            stringBuilder.append(string2).append("xmlPackages:\n");
            for (XmlPackage xmlPackage : xmlTest.getXmlPackages()) {
                Yaml.toYaml(stringBuilder, string2 + "  - ", xmlPackage);
            }
        }
        if (!xmlTest.getXmlClasses().isEmpty()) {
            stringBuilder.append(string2).append("classes:\n");
            for (XmlClass xmlClass : xmlTest.getXmlClasses()) {
                Yaml.toYaml(stringBuilder, string2 + "  ", xmlClass);
            }
        }
        stringBuilder.append("\n");
    }

    private static void toYaml(StringBuilder stringBuilder, String string, XmlClass xmlClass) {
        List<XmlInclude> list = xmlClass.getIncludedMethods();
        List<String> list2 = xmlClass.getExcludedMethods();
        String string2 = list.isEmpty() && list2.isEmpty() ? "" : "name: ";
        stringBuilder.append(string).append("- ").append(string2).append(xmlClass.getName()).append("\n");
        if (!list.isEmpty()) {
            stringBuilder.append(string).append("  includedMethods:\n");
            for (XmlInclude xmlInclude : list) {
                Yaml.toYaml(stringBuilder, string + "    ", xmlInclude);
            }
        }
        if (!list2.isEmpty()) {
            stringBuilder.append(string).append("  excludedMethods:\n");
            Yaml.toYaml(stringBuilder, string + "    ", list2);
        }
    }

    private static void toYaml(StringBuilder stringBuilder, String string, XmlInclude xmlInclude) {
        stringBuilder.append(string).append("- ").append(xmlInclude.getName()).append("\n");
    }

    private static void toYaml(StringBuilder stringBuilder, String string, List<String> list) {
        for (String string2 : list) {
            stringBuilder.append(string).append("- ").append(string2).append("\n");
        }
    }

    private static void toYaml(StringBuilder stringBuilder, List<XmlPackage> list) {
        if (!list.isEmpty()) {
            stringBuilder.append("packages:\n");
            for (XmlPackage xmlPackage : list) {
                Yaml.toYaml(stringBuilder, "  ", xmlPackage);
            }
        }
        for (XmlPackage xmlPackage : list) {
            Yaml.toYaml(stringBuilder, "  ", xmlPackage);
        }
    }

    private static void toYaml(StringBuilder stringBuilder, String string, XmlPackage xmlPackage) {
        stringBuilder.append(string).append("name: ").append(xmlPackage.getName()).append("\n");
        Yaml.generateIncludeExclude(stringBuilder, string, "includes", xmlPackage.getInclude());
        Yaml.generateIncludeExclude(stringBuilder, string, "excludes", xmlPackage.getExclude());
    }

    private static void generateIncludeExclude(StringBuilder stringBuilder, String string, String string2, List<String> list) {
        if (!list.isEmpty()) {
            stringBuilder.append(string).append("  ").append(string2).append("\n");
            for (String string3 : list) {
                stringBuilder.append(string).append("    ").append(string3);
            }
        }
    }

    private static void mapToYaml(Map<String, String> map, StringBuilder stringBuilder) {
        if (map.size() > 0) {
            stringBuilder.append("{ ");
            boolean bl = true;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (!bl) {
                    stringBuilder.append(", ");
                }
                bl = false;
                stringBuilder.append(entry.getKey()).append(": ").append(entry.getValue());
            }
            stringBuilder.append(" }\n");
        }
    }

    private static void toYaml(StringBuilder stringBuilder, String string, String string2, Map<String, String> map) {
        if (!map.isEmpty()) {
            stringBuilder.append(string2).append(string).append(": ");
            Yaml.mapToYaml(map, stringBuilder);
        }
    }

    private static class TestNGConstructor
    extends Constructor {
        public TestNGConstructor(Class<?> clazz) {
            super(clazz);
            this.yamlClassConstructors.put(NodeId.scalar, new ConstructParallelMode());
        }

        private class ConstructParallelMode
        extends Constructor.ConstructScalar {
            private ConstructParallelMode() {
                super(TestNGConstructor.this);
            }

            @Override
            public Object construct(Node node) {
                if (node.getType().equals(XmlSuite.ParallelMode.class)) {
                    String string = (String)TestNGConstructor.this.constructScalar((ScalarNode)node);
                    return XmlSuite.ParallelMode.getValidParallel(string);
                }
                if (node.getType().equals(XmlSuite.FailurePolicy.class)) {
                    String string = (String)TestNGConstructor.this.constructScalar((ScalarNode)node);
                    return XmlSuite.FailurePolicy.getValidPolicy(string);
                }
                return super.construct(node);
            }
        }
    }
}

