/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.testng.IAlterTestName;
import org.testng.IAttributes;
import org.testng.IClass;
import org.testng.ITest;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.TestNGException;
import org.testng.collections.Objects;
import org.testng.internal.Attributes;

public class TestResult
implements ITestResult,
IAlterTestName {
    private static final long serialVersionUID = 6273017418233324556L;
    private IClass m_testClass = null;
    private ITestNGMethod m_method = null;
    private int m_status = -1;
    private Throwable m_throwable = null;
    private long m_startMillis = 0L;
    private long m_endMillis = 0L;
    private String m_name = null;
    private String m_host;
    private transient Object[] m_parameters = new Object[0];
    private transient Object m_instance;
    private String m_instanceName;
    private ITestContext m_context;
    private final IAttributes m_attributes = new Attributes();

    public TestResult() {
    }

    public TestResult(IClass iClass, Object object, ITestNGMethod iTestNGMethod, Throwable throwable, long l, long l2, ITestContext iTestContext) {
        this.init(iClass, object, iTestNGMethod, throwable, l, l2, iTestContext);
    }

    public void init(IClass iClass, Object object, ITestNGMethod iTestNGMethod, Throwable throwable, long l, long l2, ITestContext iTestContext) {
        this.m_testClass = iClass;
        this.m_throwable = throwable;
        this.m_instanceName = this.m_testClass.getName();
        if (null == this.m_throwable) {
            this.m_status = 1;
        }
        this.m_startMillis = l;
        this.m_endMillis = l2;
        this.m_method = iTestNGMethod;
        this.m_context = iTestContext;
        this.m_instance = object;
        if (this.m_instance == null) {
            this.m_name = this.m_method.getMethodName();
        } else if (this.m_instance instanceof ITest) {
            this.m_name = ((ITest)this.m_instance).getTestName();
        } else if (iClass.getTestName() != null) {
            this.m_name = iClass.getTestName();
        } else {
            String string = this.m_instance.toString();
            this.m_name = this.getMethod().getMethodName();
            try {
                if (!Object.class.getMethod("toString", new Class[0]).equals(this.m_instance.getClass().getMethod("toString", new Class[0]))) {
                    this.m_instanceName = string.startsWith("class ") ? string.substring("class ".length()) : string;
                    this.m_name = this.m_name + " on " + this.m_instanceName;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setEndMillis(long l) {
        this.m_endMillis = l;
    }

    @Override
    public String getTestName() {
        if (this.m_instance instanceof ITest) {
            return ((ITest)this.m_instance).getTestName();
        }
        if (this.m_testClass.getTestName() != null) {
            return this.m_testClass.getTestName();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public ITestNGMethod getMethod() {
        return this.m_method;
    }

    public void setMethod(ITestNGMethod iTestNGMethod) {
        this.m_method = iTestNGMethod;
    }

    @Override
    public int getStatus() {
        return this.m_status;
    }

    @Override
    public void setStatus(int n) {
        this.m_status = n;
    }

    @Override
    public boolean isSuccess() {
        return 1 == this.m_status;
    }

    @Override
    public IClass getTestClass() {
        return this.m_testClass;
    }

    public void setTestClass(IClass iClass) {
        this.m_testClass = iClass;
    }

    @Override
    public Throwable getThrowable() {
        return this.m_throwable;
    }

    @Override
    public void setThrowable(Throwable throwable) {
        this.m_throwable = throwable;
    }

    @Override
    public long getEndMillis() {
        return this.m_endMillis;
    }

    @Override
    public long getStartMillis() {
        return this.m_startMillis;
    }

    public String toString() {
        List<String> list = Reporter.getOutput(this);
        return Objects.toStringHelper(this.getClass()).omitNulls().omitEmptyStrings().add("name", this.getName()).add("status", TestResult.toString(this.m_status)).add("method", this.m_method).add("output", list != null && list.size() > 0 ? list.get(0) : null).toString();
    }

    private static String toString(int n) {
        switch (n) {
            case 1: {
                return "SUCCESS";
            }
            case 2: {
                return "FAILURE";
            }
            case 3: {
                return "SKIP";
            }
            case 4: {
                return "SUCCESS WITHIN PERCENTAGE";
            }
            case 16: {
                return "STARTED";
            }
            case -1: {
                return "CREATED";
            }
        }
        throw new TestNGException("Encountered an un-defined test status of [" + n + "].");
    }

    @Override
    public String getHost() {
        return this.m_host;
    }

    public void setHost(String string) {
        this.m_host = string;
    }

    @Override
    public Object[] getParameters() {
        return this.m_parameters;
    }

    @Override
    public void setParameters(Object[] objectArray) {
        this.m_parameters = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof Cloneable) {
                try {
                    Method method = objectArray[i].getClass().getDeclaredMethod("clone", new Class[0]);
                    this.m_parameters[i] = method.invoke(objectArray[i], new Object[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                    this.m_parameters[i] = objectArray[i];
                }
                continue;
            }
            this.m_parameters[i] = objectArray[i];
        }
    }

    @Override
    public Object getInstance() {
        return this.m_instance;
    }

    @Override
    public Object getAttribute(String string) {
        return this.m_attributes.getAttribute(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        this.m_attributes.setAttribute(string, object);
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.m_attributes.getAttributeNames();
    }

    @Override
    public Object removeAttribute(String string) {
        return this.m_attributes.removeAttribute(string);
    }

    @Override
    public ITestContext getTestContext() {
        return this.m_context;
    }

    public void setContext(ITestContext iTestContext) {
        this.m_context = iTestContext;
    }

    @Override
    public int compareTo(ITestResult iTestResult) {
        if (this.getStartMillis() > iTestResult.getStartMillis()) {
            return 1;
        }
        if (this.getStartMillis() < iTestResult.getStartMillis()) {
            return -1;
        }
        return 0;
    }

    @Override
    public String getInstanceName() {
        return this.m_instanceName;
    }

    @Override
    public void setTestName(String string) {
        this.m_name = string;
    }
}

