/*
 * Decompiled with CFR 0.152.
 */
package org.testng.asserts;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.testng.Assert;
import org.testng.asserts.IAssert;
import org.testng.asserts.IAssertLifecycle;

public class Assertion
implements IAssertLifecycle {
    protected void doAssert(IAssert<?> iAssert) {
        this.onBeforeAssert(iAssert);
        try {
            this.executeAssert(iAssert);
            this.onAssertSuccess(iAssert);
        }
        catch (AssertionError assertionError) {
            this.onAssertFailure(iAssert, assertionError);
            throw assertionError;
        }
        finally {
            this.onAfterAssert(iAssert);
        }
    }

    @Override
    public void executeAssert(IAssert<?> iAssert) {
        iAssert.doAssert();
    }

    @Override
    public void onAssertSuccess(IAssert<?> iAssert) {
    }

    @Override
    @Deprecated
    public void onAssertFailure(IAssert<?> iAssert) {
    }

    @Override
    public void onAssertFailure(IAssert<?> iAssert, AssertionError assertionError) {
        this.onAssertFailure(iAssert);
    }

    @Override
    public void onBeforeAssert(IAssert<?> iAssert) {
    }

    @Override
    public void onAfterAssert(IAssert<?> iAssert) {
    }

    public void assertTrue(final boolean bl, final String string) {
        this.doAssert(new SimpleAssert<Boolean>(Boolean.valueOf(bl), Boolean.TRUE, string){

            @Override
            public void doAssert() {
                Assert.assertTrue(bl, string);
            }
        });
    }

    public void assertTrue(final boolean bl) {
        this.doAssert(new SimpleAssert<Boolean>(Boolean.valueOf(bl), Boolean.TRUE){

            @Override
            public void doAssert() {
                Assert.assertTrue(bl);
            }
        });
    }

    public void assertFalse(final boolean bl, final String string) {
        this.doAssert(new SimpleAssert<Boolean>(Boolean.valueOf(bl), Boolean.FALSE, string){

            @Override
            public void doAssert() {
                Assert.assertFalse(bl, string);
            }
        });
    }

    public void assertFalse(final boolean bl) {
        this.doAssert(new SimpleAssert<Boolean>(Boolean.valueOf(bl), Boolean.FALSE){

            @Override
            public void doAssert() {
                Assert.assertFalse(bl);
            }
        });
    }

    public void fail(final String string, final Throwable throwable) {
        this.doAssert(new SimpleAssert<Object>(string){

            @Override
            public void doAssert() {
                Assert.fail(string, throwable);
            }
        });
    }

    public void fail(final String string) {
        this.doAssert(new SimpleAssert<Object>(string){

            @Override
            public void doAssert() {
                Assert.fail(string);
            }
        });
    }

    public void fail() {
        this.doAssert(new SimpleAssert<Object>(null){

            @Override
            public void doAssert() {
                Assert.fail();
            }
        });
    }

    public <T> void assertEquals(final T t, final T t2, final String string) {
        this.doAssert(new SimpleAssert<T>(t, t2, string){

            @Override
            public void doAssert() {
                Assert.assertEquals(t, t2, string);
            }
        });
    }

    public <T> void assertEquals(final T t, final T t2) {
        this.doAssert(new SimpleAssert<T>(t, t2){

            @Override
            public void doAssert() {
                Assert.assertEquals(t, t2);
            }
        });
    }

    public void assertEquals(final String string, final String string2, final String string3) {
        this.doAssert(new SimpleAssert<String>(string, string2, string3){

            @Override
            public void doAssert() {
                Assert.assertEquals(string, string2, string3);
            }
        });
    }

    public void assertEquals(final String string, final String string2) {
        this.doAssert(new SimpleAssert<String>(string, string2){

            @Override
            public void doAssert() {
                Assert.assertEquals(string, string2);
            }
        });
    }

    public void assertEquals(final double d, final double d2, final double d3, final String string) {
        this.doAssert(new SimpleAssert<Double>(Double.valueOf(d), Double.valueOf(d2), string){

            @Override
            public void doAssert() {
                Assert.assertEquals(d, d2, d3, string);
            }
        });
    }

    public void assertEquals(final double d, final double d2, final double d3) {
        this.doAssert(new SimpleAssert<Double>(Double.valueOf(d), Double.valueOf(d2)){

            @Override
            public void doAssert() {
                Assert.assertEquals(d, d2, d3);
            }
        });
    }

    public void assertEquals(final float f, final float f2, final float f3, final String string) {
        this.doAssert(new SimpleAssert<Float>(Float.valueOf(f), Float.valueOf(f2), string){

            @Override
            public void doAssert() {
                Assert.assertEquals(f, f2, f3, string);
            }
        });
    }

    public void assertEquals(final float f, final float f2, final float f3) {
        this.doAssert(new SimpleAssert<Float>(Float.valueOf(f), Float.valueOf(f2)){

            @Override
            public void doAssert() {
                Assert.assertEquals(f, f2, f3);
            }
        });
    }

    public void assertEquals(final long l, final long l2, final String string) {
        this.doAssert(new SimpleAssert<Long>(Long.valueOf(l), Long.valueOf(l2), string){

            @Override
            public void doAssert() {
                Assert.assertEquals(l, l2, string);
            }
        });
    }

    public void assertEquals(final long l, final long l2) {
        this.doAssert(new SimpleAssert<Long>(Long.valueOf(l), Long.valueOf(l2)){

            @Override
            public void doAssert() {
                Assert.assertEquals(l, l2);
            }
        });
    }

    public void assertEquals(final boolean bl, final boolean bl2, final String string) {
        this.doAssert(new SimpleAssert<Boolean>(Boolean.valueOf(bl), Boolean.valueOf(bl2), string){

            @Override
            public void doAssert() {
                Assert.assertEquals(bl, bl2, string);
            }
        });
    }

    public void assertEquals(final boolean bl, final boolean bl2) {
        this.doAssert(new SimpleAssert<Boolean>(Boolean.valueOf(bl), Boolean.valueOf(bl2)){

            @Override
            public void doAssert() {
                Assert.assertEquals(bl, bl2);
            }
        });
    }

    public void assertEquals(final byte by, final byte by2, final String string) {
        this.doAssert(new SimpleAssert<Byte>(Byte.valueOf(by), Byte.valueOf(by2), string){

            @Override
            public void doAssert() {
                Assert.assertEquals(by, by2, string);
            }
        });
    }

    public void assertEquals(final byte by, final byte by2) {
        this.doAssert(new SimpleAssert<Byte>(Byte.valueOf(by), Byte.valueOf(by2)){

            @Override
            public void doAssert() {
                Assert.assertEquals(by, by2);
            }
        });
    }

    public void assertEquals(final char c, final char c2, final String string) {
        this.doAssert(new SimpleAssert<Character>(Character.valueOf(c), Character.valueOf(c2), string){

            @Override
            public void doAssert() {
                Assert.assertEquals(c, c2, string);
            }
        });
    }

    public void assertEquals(final char c, final char c2) {
        this.doAssert(new SimpleAssert<Character>(Character.valueOf(c), Character.valueOf(c2)){

            @Override
            public void doAssert() {
                Assert.assertEquals(c, c2);
            }
        });
    }

    public void assertEquals(final short s, final short s2, final String string) {
        this.doAssert(new SimpleAssert<Short>(Short.valueOf(s), Short.valueOf(s2), string){

            @Override
            public void doAssert() {
                Assert.assertEquals(s, s2, string);
            }
        });
    }

    public void assertEquals(final short s, final short s2) {
        this.doAssert(new SimpleAssert<Short>(Short.valueOf(s), Short.valueOf(s2)){

            @Override
            public void doAssert() {
                Assert.assertEquals(s, s2);
            }
        });
    }

    public void assertEquals(final int n, final int n2, final String string) {
        this.doAssert(new SimpleAssert<Integer>(Integer.valueOf(n), Integer.valueOf(n2), string){

            @Override
            public void doAssert() {
                Assert.assertEquals(n, n2, string);
            }
        });
    }

    public void assertEquals(final int n, final int n2) {
        this.doAssert(new SimpleAssert<Integer>(Integer.valueOf(n), Integer.valueOf(n2)){

            @Override
            public void doAssert() {
                Assert.assertEquals(n, n2);
            }
        });
    }

    public void assertNotNull(final Object object) {
        this.doAssert(new SimpleAssert<Object>(object, null){

            @Override
            public void doAssert() {
                Assert.assertNotNull(object);
            }
        });
    }

    public void assertNotNull(final Object object, final String string) {
        this.doAssert(new SimpleAssert<Object>(object, null, string){

            @Override
            public void doAssert() {
                Assert.assertNotNull(object, string);
            }
        });
    }

    public void assertNull(final Object object) {
        this.doAssert(new SimpleAssert<Object>(object, null){

            @Override
            public void doAssert() {
                Assert.assertNull(object);
            }
        });
    }

    public void assertNull(final Object object, final String string) {
        this.doAssert(new SimpleAssert<Object>(object, null, string){

            @Override
            public void doAssert() {
                Assert.assertNull(object, string);
            }
        });
    }

    public void assertSame(final Object object, final Object object2, final String string) {
        this.doAssert(new SimpleAssert<Object>(object, object2, string){

            @Override
            public void doAssert() {
                Assert.assertSame(object, object2, string);
            }
        });
    }

    public void assertSame(final Object object, final Object object2) {
        this.doAssert(new SimpleAssert<Object>(object, object2){

            @Override
            public void doAssert() {
                Assert.assertSame(object, object2);
            }
        });
    }

    public void assertNotSame(final Object object, final Object object2, final String string) {
        this.doAssert(new SimpleAssert<Object>(object, object2, string){

            @Override
            public void doAssert() {
                Assert.assertNotSame(object, object2, string);
            }
        });
    }

    public void assertNotSame(final Object object, final Object object2) {
        this.doAssert(new SimpleAssert<Object>(object, object2){

            @Override
            public void doAssert() {
                Assert.assertNotSame(object, object2);
            }
        });
    }

    public void assertEquals(final Collection<?> collection, final Collection<?> collection2) {
        this.doAssert(new SimpleAssert<Collection<?>>(collection, collection2){

            @Override
            public void doAssert() {
                Assert.assertEquals(collection, collection2);
            }
        });
    }

    public void assertEquals(final Collection<?> collection, final Collection<?> collection2, final String string) {
        this.doAssert(new SimpleAssert<Collection<?>>(collection, collection2, string){

            @Override
            public void doAssert() {
                Assert.assertEquals(collection, collection2, string);
            }
        });
    }

    public void assertEquals(final Object[] objectArray, final Object[] objectArray2, final String string) {
        this.doAssert(new SimpleAssert<Object[]>(objectArray, objectArray2, string){

            @Override
            public void doAssert() {
                Assert.assertEquals(objectArray, objectArray2, string);
            }
        });
    }

    public void assertEqualsNoOrder(final Object[] objectArray, final Object[] objectArray2, final String string) {
        this.doAssert(new SimpleAssert<Object[]>(objectArray, objectArray2, string){

            @Override
            public void doAssert() {
                Assert.assertEqualsNoOrder(objectArray, objectArray2, string);
            }
        });
    }

    public void assertEquals(final Object[] objectArray, final Object[] objectArray2) {
        this.doAssert(new SimpleAssert<Object[]>(objectArray, objectArray2){

            @Override
            public void doAssert() {
                Assert.assertEquals(objectArray, objectArray2);
            }
        });
    }

    public void assertEqualsNoOrder(final Object[] objectArray, final Object[] objectArray2) {
        this.doAssert(new SimpleAssert<Object[]>(objectArray, objectArray2){

            @Override
            public void doAssert() {
                Assert.assertEqualsNoOrder(objectArray, objectArray2);
            }
        });
    }

    public void assertEquals(final byte[] byArray, final byte[] byArray2) {
        this.doAssert(new SimpleAssert<byte[]>(byArray, byArray2){

            @Override
            public void doAssert() {
                Assert.assertEquals((Object)byArray, (Object)byArray2);
            }
        });
    }

    public void assertEquals(final byte[] byArray, final byte[] byArray2, final String string) {
        this.doAssert(new SimpleAssert<byte[]>(byArray, byArray2, string){

            @Override
            public void doAssert() {
                Assert.assertEquals((Object)byArray, (Object)byArray2, string);
            }
        });
    }

    public void assertEquals(final Set<?> set, final Set<?> set2) {
        this.doAssert(new SimpleAssert<Set<?>>(set, set2){

            @Override
            public void doAssert() {
                Assert.assertEquals(set, set2);
            }
        });
    }

    public void assertEquals(final Set<?> set, final Set<?> set2, final String string) {
        this.doAssert(new SimpleAssert<Set<?>>(set, set2, string){

            @Override
            public void doAssert() {
                Assert.assertEquals(set, set2, string);
            }
        });
    }

    public void assertEquals(final Map<?, ?> map, final Map<?, ?> map2) {
        this.doAssert(new SimpleAssert<Map<?, ?>>(map, map2){

            @Override
            public void doAssert() {
                Assert.assertEquals(map, map2);
            }
        });
    }

    public void assertNotEquals(final Object object, final Object object2, final String string) {
        this.doAssert(new SimpleAssert<Object>(object, object2, string){

            @Override
            public void doAssert() {
                Assert.assertNotEquals(object, object2, string);
            }
        });
    }

    public void assertNotEquals(final Object object, final Object object2) {
        this.doAssert(new SimpleAssert<Object>(object, object2){

            @Override
            public void doAssert() {
                Assert.assertNotEquals(object, object2);
            }
        });
    }

    public void assertNotEquals(final String string, final String string2, final String string3) {
        this.doAssert(new SimpleAssert<String>(string, string2, string3){

            @Override
            public void doAssert() {
                Assert.assertNotEquals((Object)string, (Object)string2, string3);
            }
        });
    }

    public void assertNotEquals(final String string, final String string2) {
        this.doAssert(new SimpleAssert<String>(string, string2){

            @Override
            public void doAssert() {
                Assert.assertNotEquals((Object)string, (Object)string2);
            }
        });
    }

    public void assertNotEquals(final long l, final long l2, final String string) {
        this.doAssert(new SimpleAssert<Long>(Long.valueOf(l), Long.valueOf(l2), string){

            @Override
            public void doAssert() {
                Assert.assertNotEquals((Object)l, (Object)l2, string);
            }
        });
    }

    public void assertNotEquals(final long l, final long l2) {
        this.doAssert(new SimpleAssert<Long>(Long.valueOf(l), Long.valueOf(l2)){

            @Override
            public void doAssert() {
                Assert.assertNotEquals((Object)l, (Object)l2);
            }
        });
    }

    public void assertNotEquals(final boolean bl, final boolean bl2, final String string) {
        this.doAssert(new SimpleAssert<Boolean>(Boolean.valueOf(bl), Boolean.valueOf(bl2), string){

            @Override
            public void doAssert() {
                Assert.assertNotEquals((Object)bl, (Object)bl2, string);
            }
        });
    }

    public void assertNotEquals(final boolean bl, final boolean bl2) {
        this.doAssert(new SimpleAssert<Boolean>(Boolean.valueOf(bl), Boolean.valueOf(bl2)){

            @Override
            public void doAssert() {
                Assert.assertNotEquals((Object)bl, (Object)bl2);
            }
        });
    }

    public void assertNotEquals(final byte by, final byte by2, final String string) {
        this.doAssert(new SimpleAssert<Byte>(Byte.valueOf(by), Byte.valueOf(by2), string){

            @Override
            public void doAssert() {
                Assert.assertNotEquals((Object)by, (Object)by2, string);
            }
        });
    }

    public void assertNotEquals(final byte by, final byte by2) {
        this.doAssert(new SimpleAssert<Byte>(Byte.valueOf(by), Byte.valueOf(by2)){

            @Override
            public void doAssert() {
                Assert.assertNotEquals((Object)by, (Object)by2);
            }
        });
    }

    public void assertNotEquals(final char c, final char c2, final String string) {
        this.doAssert(new SimpleAssert<Character>(Character.valueOf(c), Character.valueOf(c2), string){

            @Override
            public void doAssert() {
                Assert.assertNotEquals(Character.valueOf(c), Character.valueOf(c2), string);
            }
        });
    }

    public void assertNotEquals(final char c, final char c2) {
        this.doAssert(new SimpleAssert<Character>(Character.valueOf(c), Character.valueOf(c2)){

            @Override
            public void doAssert() {
                Assert.assertNotEquals(Character.valueOf(c), Character.valueOf(c2));
            }
        });
    }

    public void assertNotEquals(final short s, final short s2, final String string) {
        this.doAssert(new SimpleAssert<Short>(Short.valueOf(s), Short.valueOf(s2), string){

            @Override
            public void doAssert() {
                Assert.assertNotEquals((Object)s, (Object)s2, string);
            }
        });
    }

    public void assertNotEquals(final short s, final short s2) {
        this.doAssert(new SimpleAssert<Short>(Short.valueOf(s), Short.valueOf(s2)){

            @Override
            public void doAssert() {
                Assert.assertNotEquals((Object)s, (Object)s2);
            }
        });
    }

    public void assertNotEquals(final int n, final int n2, final String string) {
        this.doAssert(new SimpleAssert<Integer>(Integer.valueOf(n), Integer.valueOf(n2), string){

            @Override
            public void doAssert() {
                Assert.assertNotEquals((Object)n, (Object)n2, string);
            }
        });
    }

    public void assertNotEquals(final int n, final int n2) {
        this.doAssert(new SimpleAssert<Integer>(Integer.valueOf(n), Integer.valueOf(n2)){

            @Override
            public void doAssert() {
                Assert.assertNotEquals((Object)n, (Object)n2);
            }
        });
    }

    public void assertNotEquals(final float f, final float f2, final float f3, final String string) {
        this.doAssert(new SimpleAssert<Float>(Float.valueOf(f), Float.valueOf(f2), string){

            @Override
            public void doAssert() {
                Assert.assertNotEquals(f, f2, f3, string);
            }
        });
    }

    public void assertNotEquals(final float f, final float f2, final float f3) {
        this.doAssert(new SimpleAssert<Float>(Float.valueOf(f), Float.valueOf(f2)){

            @Override
            public void doAssert() {
                Assert.assertNotEquals(f, f2, f3);
            }
        });
    }

    public void assertNotEquals(final double d, final double d2, final double d3, final String string) {
        this.doAssert(new SimpleAssert<Double>(Double.valueOf(d), Double.valueOf(d2), string){

            @Override
            public void doAssert() {
                Assert.assertNotEquals(d, d2, d3, string);
            }
        });
    }

    public void assertNotEquals(final double d, final double d2, final double d3) {
        this.doAssert(new SimpleAssert<Double>(Double.valueOf(d), Double.valueOf(d2)){

            @Override
            public void doAssert() {
                Assert.assertNotEquals(d, d2, d3);
            }
        });
    }

    private static abstract class SimpleAssert<T>
    implements IAssert<T> {
        private final T actual;
        private final T expected;
        private final String m_message;

        public SimpleAssert(String string) {
            this(null, null, string);
        }

        public SimpleAssert(T t, T t2) {
            this(t, t2, null);
        }

        public SimpleAssert(T t, T t2, String string) {
            this.actual = t;
            this.expected = t2;
            this.m_message = string;
        }

        @Override
        public String getMessage() {
            return this.m_message;
        }

        @Override
        public T getActual() {
            return this.actual;
        }

        @Override
        public T getExpected() {
            return this.expected;
        }

        @Override
        public abstract void doAssert();
    }
}

