/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.tools;

import java.util.Arrays;
import java.util.stream.IntStream;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.tools.MathUtils;

public class VariableUtils {
    public static int[] boundsForAddition(IntVar ... vars) {
        long[] bounds = new long[2];
        IntStream.range(0, vars.length).forEach(i -> {
            lArray[0] = bounds[0] + (long)vars[i].getLB();
            lArray[1] = bounds[1] + (long)vars[i].getUB();
        });
        return new int[]{MathUtils.safeCast(bounds[0]), MathUtils.safeCast(bounds[1])};
    }

    public static int[] boundsForScalar(IntVar[] vars, int[] coeffs) {
        long[] bounds = new long[2];
        for (int i = 0; i < vars.length; ++i) {
            int c = coeffs[i];
            if (c >= 0) {
                bounds[0] = bounds[0] + (long)(vars[i].getLB() * coeffs[i]);
                bounds[1] = bounds[1] + (long)(vars[i].getUB() * coeffs[i]);
                continue;
            }
            bounds[0] = bounds[0] + (long)(vars[i].getUB() * coeffs[i]);
            bounds[1] = bounds[1] + (long)(vars[i].getLB() * coeffs[i]);
        }
        return new int[]{MathUtils.safeCast(bounds[0]), MathUtils.safeCast(bounds[1])};
    }

    public static double[] boundsForAddition(RealVar ... vars) {
        double[] bounds = new double[2];
        for (int i = 0; i < vars.length; ++i) {
            bounds[0] = bounds[0] + vars[i].getLB();
            bounds[1] = bounds[1] + vars[i].getUB();
        }
        return bounds;
    }

    private static int[] bound(long ... values) {
        return new int[]{MathUtils.safeCast(Arrays.stream(values).min().getAsLong()), MathUtils.safeCast(Arrays.stream(values).max().getAsLong())};
    }

    private static double[] bound(double ... values) {
        return new double[]{Arrays.stream(values).min().getAsDouble(), Arrays.stream(values).max().getAsDouble()};
    }

    public static int[] boundsForSubstraction(IntVar x, IntVar y) {
        return new int[]{MathUtils.safeCast(x.getLB() - y.getUB()), MathUtils.safeCast(x.getUB() - y.getLB())};
    }

    public static double[] boundsForSubstraction(RealVar x, RealVar y) {
        return new double[]{x.getLB() - y.getUB(), x.getUB() - y.getLB()};
    }

    public static int[] boundsForMultiplication(IntVar x, IntVar y) {
        return VariableUtils.bound(new long[]{x.getLB() * y.getLB(), x.getLB() * y.getUB(), x.getUB() * y.getLB(), x.getUB() * y.getUB()});
    }

    public static double[] boundsForMultiplication(RealVar x, RealVar y) {
        return VariableUtils.bound(x.getLB() * y.getLB(), x.getLB() * y.getUB(), x.getUB() * y.getLB(), x.getUB() * y.getUB());
    }

    public static int[] boundsForDivision(IntVar x, IntVar y) {
        int lx = x.getLB();
        int ux = x.getUB();
        int ly = y.getLB();
        int uy = y.getUB();
        if (ly == 0) {
            ++ly;
        }
        if (uy == 0) {
            --uy;
        }
        if (ly < 0 && 0 < uy) {
            ly = -1;
            uy = 1;
        }
        return VariableUtils.bound(new long[]{lx / ly, lx / uy, ux / ly, ux / uy});
    }

    public static double[] boundsForDivision(RealVar x, RealVar y) {
        return VariableUtils.bound(x.getLB() / y.getLB(), x.getLB() / y.getUB(), x.getUB() / y.getLB(), x.getUB() / y.getUB());
    }

    public static int[] boundsForModulo(IntVar x, IntVar y) {
        long[] vals = new long[4];
        if (y.isInstantiatedTo(0)) {
            vals[0] = Integer.MIN_VALUE;
            vals[1] = Integer.MIN_VALUE;
            vals[2] = Integer.MAX_VALUE;
            vals[3] = Integer.MAX_VALUE;
        } else {
            int yl = y.getLB();
            int yu = y.getUB();
            if (yl == 0) {
                yl = 1;
            }
            if (yu == 0) {
                yu = 1;
            }
            vals[0] = 0L;
            vals[1] = 0L;
            vals[2] = Math.abs(yl);
            vals[3] = Math.abs(yu);
        }
        return VariableUtils.bound(vals);
    }

    public static int[] boundsForPow(IntVar x, IntVar y) {
        return VariableUtils.bound(new long[]{MathUtils.pow(x.getLB(), y.getLB()), MathUtils.pow(x.getLB(), y.getUB()), MathUtils.pow(x.getUB(), y.getLB()), MathUtils.pow(x.getUB(), y.getUB())});
    }

    public static double[] boundsForPow(RealVar x, RealVar y) {
        return VariableUtils.bound(Math.pow(x.getLB(), y.getLB()), Math.pow(x.getLB(), y.getUB()), Math.pow(x.getUB(), y.getLB()), Math.pow(x.getUB(), y.getUB()));
    }

    public static double[] boundsForAtan2(RealVar x, RealVar y) {
        return VariableUtils.bound(Math.atan2(x.getLB(), y.getLB()), Math.atan2(x.getLB(), y.getUB()), Math.atan2(x.getUB(), y.getLB()), Math.atan2(x.getUB(), y.getUB()));
    }

    public static int[] boundsForMinimum(IntVar ... vars) {
        int[] bounds = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE};
        for (int i = 0; i < vars.length; ++i) {
            bounds[0] = Math.min(bounds[0], vars[i].getLB());
            bounds[1] = Math.min(bounds[1], vars[i].getUB());
        }
        return bounds;
    }

    public static double[] boundsForMinimum(RealVar ... vars) {
        double[] bounds = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY};
        for (int i = 0; i < vars.length; ++i) {
            bounds[0] = Math.min(bounds[0], vars[i].getLB());
            bounds[1] = Math.min(bounds[1], vars[i].getUB());
        }
        return bounds;
    }

    public static int[] boundsForMaximum(IntVar ... vars) {
        int[] bounds = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE};
        for (int i = 0; i < vars.length; ++i) {
            bounds[0] = Math.max(bounds[0], vars[i].getLB());
            bounds[1] = Math.max(bounds[1], vars[i].getUB());
        }
        return bounds;
    }

    public static double[] boundsForMaximum(RealVar ... vars) {
        double[] bounds = new double[]{Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
        for (int i = 0; i < vars.length; ++i) {
            bounds[0] = Math.max(bounds[0], vars[i].getLB());
            bounds[1] = Math.max(bounds[1], vars[i].getUB());
        }
        return bounds;
    }

    public static long domainCardinality(IntVar ... vars) {
        long card = 1L;
        for (int i = 0; i < vars.length && card < Integer.MAX_VALUE; card *= (long)vars[i].getDomainSize(), ++i) {
        }
        return Math.min(Integer.MAX_VALUE, card);
    }

    public static boolean intersect(IntVar x, IntVar y) {
        if (x.getLB() > y.getUB() || y.getLB() > x.getUB()) {
            return false;
        }
        if (x.hasEnumeratedDomain() && y.hasEnumeratedDomain()) {
            int ub = x.getUB();
            int val = x.getLB();
            while (val <= ub) {
                if (y.contains(val)) {
                    return true;
                }
                val = x.nextValue(val);
            }
            return false;
        }
        return true;
    }

    public static IntVar[] toIntVar(Model model, int ... values) {
        return (IntVar[])Arrays.stream(values).mapToObj(i -> model.intVar(i)).toArray(IntVar[]::new);
    }

    public static boolean isConstant(Variable var) {
        return (var.getTypeAndKind() & 2) != 0;
    }

    public static boolean isView(Variable var) {
        return (var.getTypeAndKind() & 4) != 0;
    }
}

