/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.tools;

import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeUtils {
    public static final long MILLISECONDS_IN_NANOSECONDS = 1000000L;
    private static final Pattern Dp = Pattern.compile("(\\d+)d");
    private static final Pattern Hp = Pattern.compile("(\\d+)h");
    private static final Pattern Mp = Pattern.compile("(\\d+)m");
    private static final Pattern Sp = Pattern.compile("(\\d+(\\.\\d+)?)s");

    private TimeUtils() {
    }

    public static long convertInMilliseconds(String duration) {
        long milliseconds = 0L;
        Matcher matcher = Dp.matcher(duration = duration.replaceAll("\\s+", ""));
        if (matcher.find() && matcher.groupCount() == 1) {
            int days = Integer.parseInt(matcher.group(1));
            milliseconds += TimeUnit.MILLISECONDS.convert(days, TimeUnit.DAYS);
        }
        if ((matcher = Hp.matcher(duration)).find() && matcher.groupCount() == 1) {
            int hours = Integer.parseInt(matcher.group(1));
            milliseconds += TimeUnit.MILLISECONDS.convert(hours, TimeUnit.HOURS);
        }
        if ((matcher = Mp.matcher(duration)).find() && matcher.groupCount() == 1) {
            int minutes = Integer.parseInt(matcher.group(1));
            milliseconds += TimeUnit.MILLISECONDS.convert(minutes, TimeUnit.MINUTES);
        }
        if ((matcher = Sp.matcher(duration)).find() && matcher.groupCount() == 2) {
            double seconds = Double.parseDouble(matcher.group(1));
            milliseconds += (long)((int)(seconds * 1000.0));
        }
        if (milliseconds == 0L) {
            milliseconds = Long.parseLong(duration);
        }
        return milliseconds;
    }

    public static long convertInSeconds(String duration) {
        return TimeUtils.convertInMilliseconds(duration) / 1000L;
    }
}

