/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.tools;

import java.util.Arrays;

public class StatisticUtils {
    protected StatisticUtils() {
    }

    public static int sum(int ... values) {
        int sum = 0;
        for (int i = 0; i < values.length; ++i) {
            sum += values[i];
        }
        return sum;
    }

    public static long sum(long ... values) {
        long sum = 0L;
        for (int i = 0; i < values.length; ++i) {
            sum += values[i];
        }
        return sum;
    }

    public static float sum(float ... values) {
        float sum = 0.0f;
        for (int i = 0; i < values.length; ++i) {
            sum += values[i];
        }
        return sum;
    }

    public static double sum(double ... values) {
        double sum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sum += values[i];
        }
        return sum;
    }

    public static double mean(int ... values) {
        return StatisticUtils.sum(values) / values.length;
    }

    public static float mean(long ... values) {
        return StatisticUtils.sum(values) / (long)values.length;
    }

    public static double mean(float ... values) {
        return StatisticUtils.sum(values) / (float)values.length;
    }

    public static double mean(double ... values) {
        return StatisticUtils.sum(values) / (double)values.length;
    }

    public static double standarddeviation(int ... values) {
        double mean = StatisticUtils.mean(values);
        double[] psd = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            psd[i] = Math.pow((double)values[i] - mean, 2.0);
        }
        return Math.sqrt(StatisticUtils.mean(psd));
    }

    public static double standarddeviation(long ... values) {
        double mean = StatisticUtils.mean(values);
        double[] psd = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            psd[i] = Math.pow((double)values[i] - mean, 2.0);
        }
        return Math.sqrt(StatisticUtils.mean(psd));
    }

    public static float standarddeviation(float ... values) {
        double mean = StatisticUtils.mean(values);
        double[] psd = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            psd[i] = Math.pow((double)values[i] - mean, 2.0);
        }
        return (float)Math.sqrt(StatisticUtils.mean(psd));
    }

    public static int[] prepare(int ... values) {
        Arrays.sort(values);
        int[] back = new int[values.length - 2];
        System.arraycopy(values, 1, back, 0, back.length);
        return back;
    }

    public static long[] prepare(long ... values) {
        Arrays.sort(values);
        long[] back = new long[values.length - 2];
        System.arraycopy(values, 1, back, 0, back.length);
        return back;
    }

    public static float[] prepare(float ... values) {
        Arrays.sort(values);
        float[] back = new float[values.length - 2];
        System.arraycopy(values, 1, back, 0, back.length);
        return back;
    }

    public static long binomialCoefficients(int n, int k) {
        long Ank = 1L;
        if (k < 0 || k > n) {
            return 0L;
        }
        for (long i = (long)(n - k + 1); i <= (long)n && Ank >= 0L; Ank *= i, ++i) {
        }
        if (Ank < 0L) {
            return Integer.MAX_VALUE;
        }
        return Ank;
    }
}

