/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.setDataStructures.swapList;

import gnu.trove.list.array.TIntArrayList;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class Set_Std_Swap2
implements ISet {
    protected IStateInt size;
    protected TIntArrayList values;
    private ISetIterator iter = this.newIterator();

    public Set_Std_Swap2(IEnvironment e) {
        this.size = e.makeInt(0);
        this.values = new TIntArrayList(4);
    }

    @Override
    public boolean add(int element) {
        if (!this.contains(element)) {
            int pos = this.size.add(1);
            this.values.insert(pos - 1, element);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(int element) {
        int pos = this.values.indexOf(element);
        int s = this.size();
        if (pos > -1 && pos < s) {
            this.iter.notifyRemoving(element);
            int t = this.values.get(--s);
            this.values.set(pos, t);
            this.values.set(s, element);
            this.size.add(-1);
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(int element) {
        int pos = this.values.indexOf(element);
        return pos > -1 && pos < this.size();
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public void clear() {
        this.size.set(0);
    }

    @Override
    public int min() {
        if (this.isEmpty()) {
            throw new IllegalStateException("cannot find minimum of an empty set");
        }
        int min = this.values.get(0);
        for (int i = 1; i < this.size(); ++i) {
            if (min <= this.values.get(i)) continue;
            min = this.values.get(i);
        }
        return min;
    }

    @Override
    public int max() {
        if (this.isEmpty()) {
            throw new IllegalStateException("cannot find maximum of an empty set");
        }
        int max = this.values.get(0);
        for (int i = 1; i < this.size(); ++i) {
            if (max >= this.values.get(i)) continue;
            max = this.values.get(i);
        }
        return max;
    }

    @Override
    public SetType getSetType() {
        return SetType.SMALLBIPARTITESET;
    }

    public String toString() {
        String st = "{";
        ISetIterator iter = this.newIterator();
        while (iter.hasNext()) {
            st = st + iter.nextInt() + ", ";
        }
        st = st + "}";
        return st.replace(", }", "}");
    }

    @Override
    public ISetIterator iterator() {
        this.iter.reset();
        return this.iter;
    }

    @Override
    public ISetIterator newIterator() {
        return new ISetIterator(){
            private int idx;

            @Override
            public void reset() {
                this.idx = 0;
            }

            @Override
            public void notifyRemoving(int item) {
                if (this.idx > 0 && item == Set_Std_Swap2.this.values.get(this.idx - 1)) {
                    --this.idx;
                }
            }

            @Override
            public boolean hasNext() {
                return this.idx < Set_Std_Swap2.this.size();
            }

            @Override
            public int nextInt() {
                ++this.idx;
                return Set_Std_Swap2.this.values.get(this.idx - 1);
            }
        };
    }
}

