/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.setDataStructures.iterable;

import java.util.Arrays;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSet;

public class IntIterableRangeSet
implements IntIterableSet {
    protected int[] ELEMENTS;
    protected int SIZE;
    protected int CARDINALITY;
    private ISetIterator iter = this.newIterator();

    public IntIterableRangeSet() {
        this.ELEMENTS = new int[10];
        this.SIZE = 0;
        this.CARDINALITY = 0;
    }

    public IntIterableRangeSet(int a, int b) {
        this.ELEMENTS = new int[10];
        this.SIZE = 2;
        this.CARDINALITY = b - a + 1;
        this.ELEMENTS[0] = a;
        this.ELEMENTS[1] = b;
    }

    public IntIterableRangeSet(int e) {
        this.ELEMENTS = new int[10];
        this.SIZE = 2;
        this.CARDINALITY = 1;
        this.ELEMENTS[0] = this.ELEMENTS[1] = e;
    }

    public IntIterableRangeSet(int[] values) {
        this();
        this.addAll(values);
    }

    public String toString() {
        StringBuilder st = new StringBuilder();
        st.append("set={");
        for (int i = 0; i < this.SIZE - 1; i += 2) {
            if (this.ELEMENTS[i] == this.ELEMENTS[i + 1]) {
                st.append(this.ELEMENTS[i]).append(',');
                continue;
            }
            for (int j = this.ELEMENTS[i]; j <= this.ELEMENTS[i + 1]; ++j) {
                st.append(j).append(',');
            }
        }
        if (this.SIZE > 0) {
            st.deleteCharAt(st.length() - 1);
        }
        st.append("}");
        return st.toString();
    }

    @Override
    public int min() {
        if (this.isEmpty()) {
            throw new IllegalStateException("cannot find minimum of an empty set");
        }
        return this.ELEMENTS[0];
    }

    @Override
    public int max() {
        if (this.isEmpty()) {
            throw new IllegalStateException("cannot find maximum of an empty set");
        }
        return this.ELEMENTS[this.SIZE - 1];
    }

    @Override
    public boolean add(int e) {
        boolean modified = false;
        int p = this.rangeOf(e);
        if (p < 0) {
            this.grow(this.SIZE + 2);
            int i = -p - 1 << 1;
            int c = i > 0 && this.ELEMENTS[i - 1] + 1 == e ? 1 : 0;
            switch (c += i < this.SIZE && e == this.ELEMENTS[i] - 1 ? 2 : 0) {
                case 0: {
                    System.arraycopy(this.ELEMENTS, i, this.ELEMENTS, i + 2, this.SIZE - i);
                    int n = e;
                    this.ELEMENTS[i + 1] = n;
                    this.ELEMENTS[i] = n;
                    this.SIZE += 2;
                    break;
                }
                case 1: {
                    assert (this.ELEMENTS[i - 1] + 1 == e);
                    this.ELEMENTS[i - 1] = e;
                    break;
                }
                case 2: {
                    assert (this.ELEMENTS[i] - 1 == e);
                    this.ELEMENTS[i] = e;
                    break;
                }
                case 3: {
                    System.arraycopy(this.ELEMENTS, i + 1, this.ELEMENTS, i - 1, this.SIZE - i);
                    this.SIZE -= 2;
                    break;
                }
                default: {
                    throw new SolverException("Unexpected mask " + c);
                }
            }
            modified = true;
            ++this.CARDINALITY;
        }
        return modified;
    }

    @Override
    public boolean addAll(int ... values) {
        int c = this.CARDINALITY;
        for (int i = 0; i < values.length; ++i) {
            this.add(values[i]);
        }
        return this.CARDINALITY - c > 0;
    }

    @Override
    public boolean addAll(IntIterableSet set) {
        if (set.isEmpty()) {
            return false;
        }
        int c = this.CARDINALITY;
        if (!set.isEmpty()) {
            int v = set.min();
            while (v < Integer.MAX_VALUE) {
                this.add(v);
                v = set.nextValue(v);
            }
        }
        return this.CARDINALITY > c;
    }

    @Override
    public boolean retainAll(IntIterableSet set) {
        int c = this.CARDINALITY;
        if (set.isEmpty()) {
            this.clear();
        } else {
            int last = this.max();
            int i = this.min();
            while (i <= last) {
                if (!set.contains(i)) {
                    this.remove(i);
                }
                i = this.nextValue(i);
            }
        }
        return c - this.CARDINALITY > 0;
    }

    @Override
    public boolean remove(int e) {
        boolean modified = false;
        int p = this.rangeOf(e);
        if (p >= 0) {
            int i = p - 1 << 1;
            int c = this.ELEMENTS[i] == e ? 1 : 0;
            switch (c += this.ELEMENTS[i + 1] == e ? 2 : 0) {
                case 0: {
                    this.grow(this.SIZE + 2);
                    System.arraycopy(this.ELEMENTS, i + 1, this.ELEMENTS, i + 3, this.SIZE - i - 1);
                    this.ELEMENTS[i + 1] = e - 1;
                    this.ELEMENTS[i + 2] = e + 1;
                    this.SIZE += 2;
                    break;
                }
                case 1: {
                    int n = i;
                    this.ELEMENTS[n] = this.ELEMENTS[n] + 1;
                    break;
                }
                case 2: {
                    int n = i + 1;
                    this.ELEMENTS[n] = this.ELEMENTS[n] - 1;
                    break;
                }
                case 3: {
                    System.arraycopy(this.ELEMENTS, i + 2, this.ELEMENTS, i, this.SIZE - i - 2);
                    this.SIZE -= 2;
                    break;
                }
                default: {
                    throw new SolverException("Unexpected mask " + c);
                }
            }
            modified = true;
            --this.CARDINALITY;
        }
        return modified;
    }

    @Override
    public boolean removeAll(IntIterableSet set) {
        int c = this.CARDINALITY;
        if (!set.isEmpty()) {
            int v = set.min();
            while (v < Integer.MAX_VALUE) {
                this.remove(v);
                v = set.nextValue(v);
            }
        }
        return this.CARDINALITY < c;
    }

    @Override
    public void clear() {
        this.CARDINALITY = 0;
        this.SIZE = 0;
    }

    @Override
    public SetType getSetType() {
        return SetType.RANGESET;
    }

    @Override
    public boolean removeBetween(int f, int t) {
        boolean rem = false;
        if (f > t) {
            return false;
        }
        int rf = this.rangeOf(f);
        if (rf < 0) {
            f = this.ELEMENTS[(rf *= -1) - 1 << 1];
        }
        assert (rf > 0);
        int rt = this.rangeOf(t);
        if (rt < 0) {
            rt = -rt - 1;
            t = this.ELEMENTS[(rt - 1 << 1) + 1];
        }
        assert (rt > 0);
        int i = rf - 1 << 1;
        int j = rt - 1 << 1;
        if (rf <= rt) {
            int dcard = -(f - this.ELEMENTS[i] + this.ELEMENTS[j + 1] - t);
            dcard += this.ELEMENTS[i + 1] - this.ELEMENTS[i] + 1;
            if (rf < rt) {
                for (int k = i + 2; k <= j + 1; k += 2) {
                    dcard += this.ELEMENTS[k + 1] - this.ELEMENTS[k] + 1;
                }
                if (rf < rt) {
                    System.arraycopy(this.ELEMENTS, j + 1, this.ELEMENTS, i + 1, this.SIZE - (j + 1));
                }
                this.SIZE -= rt - rf << 1;
            }
            this.CARDINALITY -= dcard;
            int c = this.ELEMENTS[i] == f ? 1 : 0;
            switch (c += this.ELEMENTS[i + 1] == t ? 2 : 0) {
                case 0: {
                    this.grow(this.SIZE + 2);
                    System.arraycopy(this.ELEMENTS, i, this.ELEMENTS, i + 2, this.SIZE - i);
                    this.ELEMENTS[i + 1] = f - 1;
                    this.ELEMENTS[i + 2] = t + 1;
                    this.SIZE += 2;
                    break;
                }
                case 1: {
                    this.ELEMENTS[i] = t + 1;
                    break;
                }
                case 2: {
                    this.ELEMENTS[i + 1] = f - 1;
                    break;
                }
                case 3: {
                    if (i < this.SIZE - 2) {
                        System.arraycopy(this.ELEMENTS, i + 2, this.ELEMENTS, i, this.SIZE - (i + 2));
                    }
                    this.SIZE -= 2;
                }
            }
            rem = true;
        }
        return rem;
    }

    @Override
    public int nextValue(int e) {
        int p = this.rangeOf(e);
        int next = Integer.MAX_VALUE;
        if (p == -1 && this.SIZE > 0) {
            next = this.ELEMENTS[0];
        } else if (p >= 0) {
            int i = p - 1 << 1;
            int c = this.ELEMENTS[i] == e ? 1 : 0;
            switch (c += this.ELEMENTS[i + 1] == e ? 2 : 0) {
                case 0: 
                case 1: {
                    next = e + 1;
                    break;
                }
                case 2: 
                case 3: {
                    if (i + 2 >= this.SIZE) break;
                    next = this.ELEMENTS[i + 2];
                }
            }
        } else if (p > -((this.SIZE >> 1) + 1)) {
            return this.ELEMENTS[-p - 1 << 1];
        }
        return next;
    }

    @Override
    public int previousValue(int e) {
        int p = this.rangeOf(e);
        int prev = Integer.MIN_VALUE;
        if (p == -((this.SIZE >> 1) + 1) && this.SIZE > 0) {
            prev = this.ELEMENTS[this.SIZE - 1];
        } else if (p >= 0) {
            int i = p - 1 << 1;
            int c = this.ELEMENTS[i] == e ? 1 : 0;
            switch (c += this.ELEMENTS[i + 1] == e ? 2 : 0) {
                case 0: 
                case 2: {
                    prev = e - 1;
                    break;
                }
                case 1: 
                case 3: {
                    if (i <= 1) break;
                    prev = this.ELEMENTS[i - 1];
                }
            }
        } else if (p < -1) {
            return this.ELEMENTS[(-p - 1 << 1) - 1];
        }
        return prev;
    }

    @Override
    public boolean contains(int o) {
        return this.rangeOf(o) >= 0;
    }

    @Override
    public IntIterableSet duplicate() {
        IntIterableRangeSet ir = new IntIterableRangeSet();
        ir.ELEMENTS = (int[])this.ELEMENTS.clone();
        ir.CARDINALITY = this.CARDINALITY;
        ir.SIZE = this.SIZE;
        return ir;
    }

    @Override
    public int size() {
        return this.CARDINALITY;
    }

    @Override
    public ISetIterator newIterator() {
        return new ISetIterator(){
            private boolean started = false;
            private int current;

            @Override
            public void reset() {
                this.started = false;
            }

            @Override
            public boolean hasNext() {
                if (this.started) {
                    return IntIterableRangeSet.this.nextValue(this.current) < Integer.MAX_VALUE;
                }
                return !IntIterableRangeSet.this.isEmpty();
            }

            @Override
            public int nextInt() {
                if (this.started) {
                    this.current = IntIterableRangeSet.this.nextValue(this.current);
                } else {
                    this.started = true;
                    this.current = IntIterableRangeSet.this.min();
                }
                return this.current;
            }
        };
    }

    @Override
    public void plus(int x) {
        int i = 0;
        while (i < this.SIZE) {
            int n = i++;
            this.ELEMENTS[n] = this.ELEMENTS[n] + x;
        }
    }

    @Override
    public ISetIterator iterator() {
        this.iter.reset();
        return this.iter;
    }

    @Override
    public void minus(int x) {
        int i = 0;
        while (i < this.SIZE) {
            int n = i++;
            this.ELEMENTS[n] = this.ELEMENTS[n] - x;
        }
    }

    public void times(int x) {
        int i = 0;
        while (i < this.SIZE) {
            int n = i++;
            this.ELEMENTS[n] = this.ELEMENTS[n] * x;
        }
        this.CARDINALITY *= x;
    }

    protected int rangeOf(int x) {
        int p = Arrays.binarySearch(this.ELEMENTS, 0, this.SIZE, x);
        if (p >= 0) {
            p >>= 1;
        } else if (p == -1) {
            --p;
        } else if (p == -(this.SIZE + 1)) {
            p = -((this.SIZE >> 1) + 2);
        } else {
            p = -(p + 1);
            if (this.ELEMENTS[(p >>= 1) << 1] >= x || x >= this.ELEMENTS[(p << 1) + 1]) {
                p = -(p + 2);
            }
        }
        return p + 1;
    }

    void grow(int minCapacity) {
        if (minCapacity - this.ELEMENTS.length > 0) {
            int oldCapacity = this.ELEMENTS.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            this.ELEMENTS = Arrays.copyOf(this.ELEMENTS, newCapacity);
        }
    }

    void pushRange(int lb, int ub) {
        assert (this.SIZE == 0 || this.ELEMENTS[this.SIZE - 1] < lb - 1);
        assert (lb <= ub);
        this.grow(this.SIZE + 2);
        this.ELEMENTS[this.SIZE++] = lb;
        this.ELEMENTS[this.SIZE++] = ub;
        this.CARDINALITY += ub - lb + 1;
    }
}

