/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.setDataStructures.iterable;

import org.chocosolver.util.objects.setDataStructures.bitset.Set_BitSet;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSet;

public class IntIterableBitSet
extends Set_BitSet
implements IntIterableSet {
    public IntIterableBitSet() {
        super(0);
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public boolean addAll(int ... values) {
        int prevCard = this.size();
        for (int i = 0; i < values.length; ++i) {
            this.add(values[i]);
        }
        return this.size() - prevCard > 0;
    }

    @Override
    public boolean addAll(IntIterableSet set) {
        if (set.isEmpty()) {
            return false;
        }
        int prevCard = this.size();
        int v = set.min();
        while (v < Integer.MAX_VALUE) {
            this.add(v);
            v = set.nextValue(v);
        }
        return this.size() - prevCard > 0;
    }

    @Override
    public boolean retainAll(IntIterableSet set) {
        int prevCard = this.card;
        int i = this.values.nextSetBit(0);
        while (i >= 0) {
            if (!set.contains(i + this.offset)) {
                this.values.clear(i);
                --this.card;
            }
            i = this.values.nextSetBit(i + 1);
        }
        return this.card < prevCard;
    }

    @Override
    public boolean removeAll(IntIterableSet set) {
        int prevCard = this.card;
        int i = this.values.nextSetBit(0);
        while (i >= 0) {
            if (set.contains(i + this.offset)) {
                this.values.clear(i);
                --this.card;
            }
            i = this.values.nextSetBit(i + 1);
        }
        return this.card < prevCard;
    }

    @Override
    public boolean removeBetween(int f, int t) {
        int prevCard = this.card;
        this.values.clear(f -= this.offset, t -= this.offset);
        this.card = this.values.cardinality();
        return this.card - prevCard != 0;
    }

    @Override
    public int nextValue(int aValue) {
        int lb = this.values.nextSetBit(0);
        if (lb >= 0) {
            if ((aValue -= this.offset) < 0 || aValue < lb) {
                return lb + this.offset;
            }
            if (aValue < Integer.MAX_VALUE) {
                aValue = this.values.nextSetBit(aValue + 1);
            }
            if (aValue > -1) {
                return aValue + this.offset;
            }
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int previousValue(int aValue) {
        int ub = this.values.previousSetBit(this.values.length());
        if (ub >= 0) {
            if ((aValue -= this.offset) > ub) {
                return ub + this.offset;
            }
            if (aValue > -1) {
                aValue = this.values.previousSetBit(aValue - 1);
            }
            if (aValue > -1) {
                return aValue + this.offset;
            }
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('{');
        int i = this.values.nextSetBit(0);
        if (i != -1) {
            b.append(i + this.offset);
            i = this.values.nextSetBit(i + 1);
            while (i >= 0) {
                int endOfRun = this.values.nextClearBit(i);
                do {
                    b.append(", ").append(i + this.offset);
                } while (++i < endOfRun);
                i = this.values.nextSetBit(i + 1);
            }
        }
        b.append('}');
        return b.toString();
    }

    @Override
    public IntIterableSet duplicate() {
        IntIterableBitSet bsrm = new IntIterableBitSet();
        bsrm.setOffset(this.offset);
        bsrm.values.or(this.values);
        return bsrm;
    }

    @Override
    public void plus(int x) {
        this.offset += x;
    }

    @Override
    public void minus(int x) {
        this.offset -= x;
    }
}

