/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.setDataStructures.bitset;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.memory.structure.S64BitSet;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class Set_Std_BitSet
implements ISet {
    private IStateInt card;
    private int offset;
    private S64BitSet values;
    private ISetIterator iter = this.newIterator();

    public Set_Std_BitSet(IEnvironment environment, int offSet) {
        this.values = new S64BitSet(environment);
        this.card = environment.makeInt(0);
        this.offset = offSet;
    }

    @Override
    public boolean add(int element) {
        if (element < this.offset) {
            throw new IllegalStateException("Cannot add " + element + " to set of offset " + this.offset);
        }
        if (this.values.get(element - this.offset)) {
            return false;
        }
        this.card.add(1);
        this.values.set(element - this.offset, true);
        return true;
    }

    @Override
    public boolean remove(int element) {
        if (this.contains(element)) {
            this.values.set(element - this.offset, false);
            this.card.add(-1);
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(int element) {
        return element >= this.offset && this.values.get(element - this.offset);
    }

    @Override
    public int size() {
        return this.card.get();
    }

    @Override
    public void clear() {
        this.values.clear();
        this.card.set(0);
    }

    @Override
    public SetType getSetType() {
        return SetType.BITSET;
    }

    @Override
    public int min() {
        if (this.isEmpty()) {
            throw new IllegalStateException("cannot find minimum of an empty set");
        }
        return this.offset + this.values.nextSetBit(0);
    }

    @Override
    public int max() {
        if (this.isEmpty()) {
            throw new IllegalStateException("cannot find maximum of an empty set");
        }
        return this.offset + this.values.prevSetBit(this.values.length());
    }

    public String toString() {
        String st = "{";
        ISetIterator iter = this.newIterator();
        while (iter.hasNext()) {
            st = st + iter.nextInt() + ", ";
        }
        st = st + "}";
        return st.replace(", }", "}");
    }

    @Override
    public ISetIterator iterator() {
        this.iter.reset();
        return this.iter;
    }

    @Override
    public ISetIterator newIterator() {
        return new ISetIterator(){
            private int current = -1;

            @Override
            public void reset() {
                this.current = -1;
            }

            @Override
            public boolean hasNext() {
                return Set_Std_BitSet.this.values.nextSetBit(this.current + 1) >= 0;
            }

            @Override
            public int nextInt() {
                this.current = Set_Std_BitSet.this.values.nextSetBit(this.current + 1);
                return this.current + Set_Std_BitSet.this.offset;
            }
        };
    }
}

