/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.setDataStructures;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.structure.IOperation;
import org.chocosolver.solver.Model;
import org.chocosolver.util.PoolManager;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class StdSet
implements ISet {
    private static final String HK_LIST_OP_PM = "HK_LIST_OP_PM";
    private final IEnvironment environment;
    private PoolManager<ListOP> operationPoolGC;
    private static final boolean ADD = true;
    private static final boolean REMOVE = false;
    private ISet set;

    public StdSet(Model model, ISet set) {
        this.environment = model.getEnvironment();
        this.operationPoolGC = (PoolManager)model.getHook(HK_LIST_OP_PM);
        if (this.operationPoolGC == null) {
            this.operationPoolGC = new PoolManager();
            model.addHook(HK_LIST_OP_PM, this.operationPoolGC);
        }
        this.set = set;
    }

    @Override
    public ISetIterator newIterator() {
        return this.set.newIterator();
    }

    @Override
    public ISetIterator iterator() {
        return this.set.iterator();
    }

    @Override
    public boolean add(int element) {
        if (this.set.add(element)) {
            ListOP op = this.operationPoolGC.getE();
            if (op == null) {
                op = new ListOP();
            }
            op.set(this.set, element, false);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(int element) {
        if (this.set.remove(element)) {
            ListOP op = this.operationPoolGC.getE();
            if (op == null) {
                op = new ListOP();
            }
            op.set(this.set, element, true);
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(int element) {
        return this.set.contains(element);
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public void clear() {
        ISetIterator iter = this.iterator();
        while (iter.hasNext()) {
            ListOP op = this.operationPoolGC.getE();
            if (op == null) {
                op = new ListOP();
            }
            op.set(this.set, iter.nextInt(), true);
        }
        this.set.clear();
    }

    @Override
    public int min() {
        return this.set.min();
    }

    @Override
    public int max() {
        return this.set.max();
    }

    public String toString() {
        return this.set.toString();
    }

    @Override
    public SetType getSetType() {
        return this.set.getSetType();
    }

    private class ListOP
    implements IOperation {
        private int element;
        private boolean addOrRemove;
        private ISet mset;

        private ListOP() {
        }

        @Override
        public void undo() {
            if (this.addOrRemove) {
                this.mset.add(this.element);
            } else {
                this.mset.remove(this.element);
            }
            StdSet.this.operationPoolGC.returnE(this);
        }

        public void set(ISet set, int i, boolean add) {
            this.mset = set;
            this.element = i;
            this.addOrRemove = add;
            StdSet.this.environment.save(this);
        }
    }
}

