/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.graphs;

import org.chocosolver.solver.Model;
import org.chocosolver.util.objects.graphs.IGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class UndirectedGraph
implements IGraph {
    private ISet[] neighbors;
    private ISet nodes;
    private int n;
    private SetType type;

    public UndirectedGraph(Model model, int n, SetType type, boolean allNodes) {
        this.type = type;
        this.n = n;
        this.neighbors = new ISet[n];
        for (int i = 0; i < n; ++i) {
            this.neighbors[i] = SetFactory.makeStoredSet(type, 0, model);
        }
        this.nodes = allNodes ? SetFactory.makeConstantSet(0, n - 1) : SetFactory.makeStoredSet(SetType.BITSET, 0, model);
    }

    public UndirectedGraph(int n, SetType type, boolean allNodes) {
        this.type = type;
        this.n = n;
        this.neighbors = new ISet[n];
        for (int i = 0; i < n; ++i) {
            this.neighbors[i] = SetFactory.makeSet(type, 0);
        }
        this.nodes = allNodes ? SetFactory.makeConstantSet(0, n - 1) : SetFactory.makeBitSet(0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("nodes : \n").append(this.nodes).append("\n");
        sb.append("neighbors : \n");
        ISetIterator iSetIterator = this.nodes.iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            sb.append(i).append(" -> {");
            ISetIterator iSetIterator2 = this.neighbors[i].iterator();
            while (iSetIterator2.hasNext()) {
                int j = (Integer)iSetIterator2.next();
                sb.append(j).append(" ");
            }
            sb.append("}\n");
        }
        return sb.toString();
    }

    @Override
    public int getNbMaxNodes() {
        return this.n;
    }

    @Override
    public ISet getNodes() {
        return this.nodes;
    }

    @Override
    public SetType getType() {
        return this.type;
    }

    @Override
    public boolean addNode(int x) {
        return this.nodes.add(x);
    }

    @Override
    public boolean removeNode(int x) {
        if (this.nodes.remove(x)) {
            ISetIterator nei = this.getNeighOf(x).iterator();
            while (nei.hasNext()) {
                this.neighbors[nei.nextInt()].remove(x);
            }
            this.neighbors[x].clear();
            return true;
        }
        return false;
    }

    public boolean addEdge(int x, int y) {
        if (x == y && !this.neighbors[x].contains(y)) {
            this.neighbors[x].add(y);
            return true;
        }
        if (!this.neighbors[x].contains(y)) {
            assert (!this.neighbors[y].contains(x)) : "asymmetric adjacency matrix in an undirected graph";
            this.neighbors[x].add(y);
            this.neighbors[y].add(x);
            return true;
        }
        return false;
    }

    public boolean edgeExists(int x, int y) {
        if (this.neighbors[x].contains(y)) {
            assert (this.neighbors[y].contains(x)) : "asymmetric adjacency matrix in an undirected graph";
            return true;
        }
        return false;
    }

    @Override
    public boolean isArcOrEdge(int x, int y) {
        return this.edgeExists(x, y);
    }

    public boolean removeEdge(int x, int y) {
        if (x == y && this.neighbors[x].contains(y)) {
            this.neighbors[y].remove(x);
            return true;
        }
        if (this.neighbors[x].contains(y)) {
            assert (this.neighbors[y].contains(x)) : "asymmetric adjacency matrix in an undirected graph";
            this.neighbors[x].remove(y);
            this.neighbors[y].remove(x);
            return true;
        }
        return false;
    }

    public ISet getNeighOf(int x) {
        return this.neighbors[x];
    }

    @Override
    public ISet getPredOrNeighOf(int x) {
        return this.neighbors[x];
    }

    @Override
    public ISet getSuccOrNeighOf(int x) {
        return this.neighbors[x];
    }

    @Override
    public boolean isDirected() {
        return false;
    }
}

