/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.graphs;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.variables.IntVar;

public class MultivaluedDecisionDiagram {
    public static final int TERMINAL = -1;
    public static final int EMPTY = 0;
    private final int nbLayers;
    private final int[] sizes;
    private final int[] offsets;
    private int[] mdd;
    private int nextFreeCell;
    private final boolean compactOnce;
    private final boolean sortTuples;
    private TIntIntHashMap _nodesToRemove;
    private ArrayList<int[]>[][] _identicalNodes;
    private TIntArrayList[][] _nodeId;
    private int _removedCells;
    private int[] _pos;

    private static int[][] flattenDomain(IntVar[] VARIABLES) {
        int[][] FLATDOM = new int[VARIABLES.length][];
        for (int i = 0; i < VARIABLES.length; ++i) {
            int lb = VARIABLES[i].getLB();
            int ub = VARIABLES[i].getUB();
            int size = ub - lb + 1;
            FLATDOM[i] = new int[size];
            for (int j = 0; j < size; ++j) {
                FLATDOM[i][j] = j + lb;
            }
        }
        return FLATDOM;
    }

    public MultivaluedDecisionDiagram(IntVar[] VARIABLES, Tuples TUPLES) {
        this(MultivaluedDecisionDiagram.flattenDomain(VARIABLES), TUPLES);
    }

    public MultivaluedDecisionDiagram(IntVar[] VARIABLES, Tuples TUPLES, boolean compactOnce, boolean sortTuple) {
        this(MultivaluedDecisionDiagram.flattenDomain(VARIABLES), TUPLES, compactOnce, sortTuple);
    }

    public MultivaluedDecisionDiagram(int[][] FLATDOM, Tuples TUPLES) {
        this(FLATDOM, TUPLES, true, false);
    }

    public MultivaluedDecisionDiagram(int[][] FLATDOM, Tuples TUPLES, boolean compactOnce, boolean sortTuple) {
        this.nbLayers = FLATDOM.length;
        this.offsets = new int[this.nbLayers];
        this.sizes = new int[this.nbLayers];
        this.compactOnce = compactOnce;
        this.sortTuples = sortTuple;
        int maxDom = 0;
        for (int i = 0; i < this.nbLayers; ++i) {
            this.offsets[i] = FLATDOM[i][0];
            this.sizes[i] = FLATDOM[i][FLATDOM[i].length - 1] - FLATDOM[i][0] + 1;
            if (maxDom >= this.sizes[i]) continue;
            maxDom = this.sizes[i];
        }
        this.mdd = new int[this.nbLayers * maxDom];
        this.init(TUPLES);
    }

    public MultivaluedDecisionDiagram(IntVar[] VARIABLES, int[][] TRANSITIONS) {
        int[][] FLATDOM = MultivaluedDecisionDiagram.flattenDomain(VARIABLES);
        this.nbLayers = FLATDOM.length;
        this.offsets = new int[this.nbLayers];
        this.sizes = new int[this.nbLayers];
        this.compactOnce = true;
        this.sortTuples = true;
        int maxDom = 0;
        for (int i = 0; i < this.nbLayers; ++i) {
            this.offsets[i] = FLATDOM[i][0];
            this.sizes[i] = FLATDOM[i][FLATDOM[i].length - 1] - FLATDOM[i][0] + 1;
            if (maxDom >= this.sizes[i]) continue;
            maxDom = this.sizes[i];
        }
        this.mdd = new int[this.nbLayers * maxDom];
        this.init(TRANSITIONS);
    }

    private void init(Tuples TUPLES) {
        this.nextFreeCell = this.sizes[0];
        this._pos = new int[this.nbLayers];
        this._nodesToRemove = new TIntIntHashMap(16, 0.5f, -1, -1);
        this._identicalNodes = new ArrayList[this.nbLayers][];
        this._nodeId = new TIntArrayList[this.nbLayers][];
        if (TUPLES.nbTuples() > 0 && this.addTuples(TUPLES) && this.compactOnce) {
            this.compact();
        }
    }

    public boolean addTuples(Tuples TUPLES) {
        if (this.sortTuples) {
            TUPLES.sort();
        }
        boolean atLeastOne = false;
        for (int t = 0; t < TUPLES.nbTuples(); ++t) {
            atLeastOne |= this.addTuple(TUPLES.get(t));
        }
        return atLeastOne;
    }

    public boolean addTuple(int[] TUPLE) {
        for (int i = 0; i < this.nbLayers; ++i) {
            if (TUPLE[i] < this.offsets[i] || TUPLE[i] >= this.offsets[i] + this.sizes[i]) {
                return false;
            }
            this._pos[i] = TUPLE[i] - this.offsets[i];
        }
        int p = 0;
        for (int i = 0; i < this.nbLayers; ++i) {
            this.ensureCapacity((p += this._pos[i]) + this.sizes[i]);
            if (this.mdd[p] == 0) {
                if (i + 1 == this.nbLayers) {
                    this.mdd[p] = -1;
                    continue;
                }
                p = this.mdd[p] = this.nextFreeCell;
                this.nextFreeCell += this.sizes[i + 1];
                continue;
            }
            p = this.mdd[p];
        }
        if (!this.compactOnce) {
            this.compact();
        }
        return true;
    }

    private void init(int[][] TRANSITIONS) {
        this.nextFreeCell = this.sizes[0];
        this._pos = new int[this.nbLayers];
        Arrays.sort(TRANSITIONS, (t1, t2) -> {
            int d = t1[0] - t2[0];
            if (d == 0) {
                return t1[2] - t2[2];
            }
            return d;
        });
        this._nodesToRemove = new TIntIntHashMap(16, 0.5f, -1, -1);
        this._identicalNodes = new ArrayList[this.nbLayers][];
        this._nodeId = new TIntArrayList[this.nbLayers][];
        int pf = 0;
        TIntIntHashMap node = new TIntIntHashMap(16, 1.5f, -2, -2);
        TIntIntHashMap posi = new TIntIntHashMap(16, 1.5f, -2, -2);
        for (int t = 0; t < TRANSITIONS.length; ++t) {
            int f = TRANSITIONS[t][0];
            int v = TRANSITIONS[t][1];
            int d = TRANSITIONS[t][2];
            if (f == 0) {
                if (v < this.offsets[f] || v >= this.offsets[f] + this.sizes[f]) continue;
                int p = v - this.offsets[f];
                this.ensureCapacity(p + this.sizes[f]);
                assert (this.mdd[p] == 0);
                if (d == -1) {
                    this.mdd[p] = -1;
                    continue;
                }
                if (!node.containsKey(d)) {
                    this.mdd[p] = this.nextFreeCell;
                    pf = f + 1;
                    node.putIfAbsent(d, f + 1);
                    posi.putIfAbsent(d, this.nextFreeCell);
                    this.nextFreeCell += this.sizes[f + 1];
                    continue;
                }
                this.mdd[p] = posi.get(d);
                continue;
            }
            int _f = node.get(f);
            if (v < this.offsets[_f] || v >= this.offsets[_f] + this.sizes[_f]) continue;
            int p = posi.get(f) + v - this.offsets[_f];
            if (pf != _f) {
                pf = f;
            }
            this.ensureCapacity(p + this.sizes[_f]);
            if (this.mdd[p] != 0) continue;
            if (d == -1) {
                this.mdd[p] = -1;
                continue;
            }
            if (!node.containsKey(d)) {
                this.mdd[p] = this.nextFreeCell;
                node.putIfAbsent(d, _f + 1);
                posi.putIfAbsent(d, this.nextFreeCell);
                this.nextFreeCell += this.sizes[_f + 1];
                continue;
            }
            this.mdd[p] = posi.get(d);
        }
        this.compact();
    }

    private void ensureCapacity(int nsize) {
        if (nsize > this.mdd.length) {
            int[] _mdd = this.mdd;
            this.mdd = new int[nsize * 3 / 2 + 1];
            System.arraycopy(_mdd, 0, this.mdd, 0, _mdd.length);
        }
    }

    private void compact() {
        long card = Arrays.stream(this.sizes).mapToLong(i -> i).reduce((a, b) -> a * b).getAsLong();
        if (card <= 2000000L) {
            this._nodesToRemove.clear();
            for (int i2 = 0; i2 < this.nbLayers; ++i2) {
                this._identicalNodes[i2] = new ArrayList[this.sizes[i2]];
                this._nodeId[i2] = new TIntArrayList[this.sizes[i2]];
            }
            this._removedCells = 0;
            this.detectIsomorphism(0, 0);
            this.deleteIsomorphism();
        }
    }

    private int detectIsomorphism(int node, int layer) {
        int[] nodeChild = new int[this.sizes[layer]];
        int nbChild = -1;
        block4: for (int i = 0; i < this.sizes[layer]; ++i) {
            switch (this.mdd[node + i]) {
                case 0: {
                    continue block4;
                }
                case -1: {
                    ++nbChild;
                    nodeChild[i] = -1;
                    continue block4;
                }
                default: {
                    ++nbChild;
                    this.mdd[node + i] = nodeChild[i] = this.detectIsomorphism(this.mdd[node + i], layer + 1);
                }
            }
        }
        return this.doStuff(node, layer, nbChild, nodeChild);
    }

    private int doStuff(int node, int layer, int nbChild, int[] nodeChild) {
        boolean known = false;
        if (this._identicalNodes[layer][nbChild] == null) {
            this._identicalNodes[layer][nbChild] = new ArrayList();
            this._nodeId[layer][nbChild] = new TIntArrayList();
        } else {
            for (int j = this._identicalNodes[layer][nbChild].size() - 1; j >= 0; --j) {
                int[] currentNode = this._identicalNodes[layer][nbChild].get(j);
                boolean found = this._nodeId[layer][nbChild].get(j) != node;
                known |= !found;
                if (!found || !Arrays.equals(currentNode, nodeChild)) continue;
                int insert = this._nodesToRemove.put(node, this.sizes[layer]);
                if (insert == -1) {
                    this._removedCells += this.sizes[layer];
                }
                return this._nodeId[layer][nbChild].get(j);
            }
        }
        if (!known) {
            this._nodeId[layer][nbChild].add(node);
            this._identicalNodes[layer][nbChild].add(nodeChild);
        }
        return node;
    }

    private void deleteIsomorphism() {
        int[] compacted = new int[this.nextFreeCell - this._removedCells];
        int[] nodes = new int[this._nodesToRemove.size() + 1];
        int[] gains = new int[this._nodesToRemove.size() + 1];
        int idx = 1;
        if (this._nodesToRemove.isEmpty()) {
            System.arraycopy(this.mdd, 0, compacted, 0, this.nextFreeCell);
            this.mdd = compacted;
        } else {
            int from = 0;
            int gain = 0;
            int[] keys = this._nodesToRemove.keys();
            Arrays.sort(keys);
            int[] nArray = keys;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int k;
                nodes[idx] = k = nArray[i];
                int to = nodes[idx] - nodes[idx - 1] - gain;
                System.arraycopy(this.mdd, nodes[idx - 1] + gain, compacted, from, to);
                from += to;
                gain = this._nodesToRemove.get(k);
                gains[idx] = gains[idx - 1] + gain;
                ++idx;
            }
            System.arraycopy(this.mdd, nodes[idx - 1] + gain, compacted, from, compacted.length - from);
            for (int i = 0; i < compacted.length; ++i) {
                if (compacted[i] <= 0) continue;
                int n2 = i;
                compacted[n2] = compacted[n2] - gains[this.searchClosest(nodes, compacted[i])];
            }
            this.mdd = compacted;
            this.nextFreeCell -= this._removedCells;
        }
    }

    protected int searchClosest(int[] a, int key) {
        int low = 0;
        int high = a.length - 1;
        int mid = low + high >> 1;
        while (low + 1 < high) {
            if (a[mid] > key) {
                high = mid;
            } else {
                low = mid;
            }
            mid = low + high >> 1;
        }
        if (a[high] <= key) {
            return high;
        }
        return low;
    }

    public int[] getDiagram() {
        return this.mdd;
    }

    public int getNodeSize(int layer) {
        return this.sizes[layer];
    }

    public int getOffset(int layer) {
        return this.offsets[layer];
    }

    public int getEdge(int k) {
        return this.mdd[k];
    }

    public boolean exists(int ... PATH) {
        if (PATH.length == this.nbLayers) {
            int p = 0;
            for (int i = 0; i < this.nbLayers; ++i) {
                if ((p += PATH[i] - this.offsets[i]) >= this.mdd.length || this.mdd[p] == 0) {
                    return false;
                }
                if (i + 1 == this.nbLayers) {
                    return this.mdd[p] == -1;
                }
                p = this.mdd[p];
            }
        }
        return false;
    }
}

