/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.graphs;

import org.chocosolver.solver.Model;
import org.chocosolver.util.objects.graphs.IGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class DirectedGraph
implements IGraph {
    private ISet[] successors;
    private ISet[] predecessors;
    private ISet nodes;
    private int n;
    private SetType type;

    public DirectedGraph(int n, SetType type, boolean allNodes) {
        this.type = type;
        this.n = n;
        this.predecessors = new ISet[n];
        this.successors = new ISet[n];
        for (int i = 0; i < n; ++i) {
            this.predecessors[i] = SetFactory.makeSet(type, 0);
            this.successors[i] = SetFactory.makeSet(type, 0);
        }
        this.nodes = allNodes ? SetFactory.makeConstantSet(0, n - 1) : SetFactory.makeBitSet(0);
    }

    public DirectedGraph(Model model, int n, SetType type, boolean allNodes) {
        this.n = n;
        this.type = type;
        this.predecessors = new ISet[n];
        this.successors = new ISet[n];
        for (int i = 0; i < n; ++i) {
            this.predecessors[i] = SetFactory.makeStoredSet(type, 0, model);
            this.successors[i] = SetFactory.makeStoredSet(type, 0, model);
        }
        this.nodes = allNodes ? SetFactory.makeConstantSet(0, n - 1) : SetFactory.makeStoredSet(SetType.BITSET, 0, model);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("nodes : \n").append(this.nodes).append("\n");
        sb.append("successors : \n");
        ISetIterator iSetIterator = this.nodes.iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            sb.append(i).append(" -> {");
            ISetIterator iSetIterator2 = this.successors[i].iterator();
            while (iSetIterator2.hasNext()) {
                int j = (Integer)iSetIterator2.next();
                sb.append(j).append(" ");
            }
            sb.append("}\n");
        }
        return sb.toString();
    }

    @Override
    public int getNbMaxNodes() {
        return this.n;
    }

    @Override
    public ISet getNodes() {
        return this.nodes;
    }

    @Override
    public SetType getType() {
        return this.type;
    }

    @Override
    public boolean addNode(int x) {
        return !this.nodes.contains(x) && this.nodes.add(x);
    }

    @Override
    public boolean removeNode(int x) {
        if (this.nodes.remove(x)) {
            ISetIterator iter = this.successors[x].iterator();
            while (iter.hasNext()) {
                this.predecessors[iter.nextInt()].remove(x);
            }
            this.successors[x].clear();
            iter = this.predecessors[x].iterator();
            while (iter.hasNext()) {
                this.successors[iter.nextInt()].remove(x);
            }
            this.predecessors[x].clear();
            return true;
        }
        assert (this.predecessors[x].size() == 0) : "incoherent directed graph";
        assert (this.successors[x].size() == 0) : "incoherent directed graph";
        return false;
    }

    public boolean removeArc(int from, int to) {
        if (this.successors[from].contains(to)) {
            assert (this.predecessors[to].contains(from)) : "incoherent directed graph";
            return this.successors[from].remove(to) | this.predecessors[to].remove(from);
        }
        return false;
    }

    public boolean arcExists(int from, int to) {
        if (this.successors[from].contains(to)) {
            assert (this.predecessors[to].contains(from)) : "incoherent directed graph";
            return true;
        }
        return false;
    }

    @Override
    public boolean isArcOrEdge(int from, int to) {
        return this.arcExists(from, to);
    }

    @Override
    public boolean isDirected() {
        return true;
    }

    public boolean addArc(int from, int to) {
        this.addNode(from);
        this.addNode(to);
        if (!this.successors[from].contains(to)) {
            assert (!this.predecessors[to].contains(from)) : "incoherent directed graph";
            return this.successors[from].add(to) & this.predecessors[to].add(from);
        }
        return false;
    }

    public ISet getSuccOf(int x) {
        return this.successors[x];
    }

    @Override
    public ISet getSuccOrNeighOf(int x) {
        return this.successors[x];
    }

    public ISet getPredOf(int x) {
        return this.predecessors[x];
    }

    @Override
    public ISet getPredOrNeighOf(int x) {
        return this.predecessors[x];
    }
}

