/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects;

import java.util.Arrays;

public class IntMap {
    private static final int DEFAULT_CAPACITY = 10;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private final int FREE;
    private int[] elements;
    private int size;

    public IntMap() {
        this(10, -1);
    }

    public IntMap(int initialCapacity) {
        this(initialCapacity, -1);
    }

    public IntMap(int initialCapacity, int no_value) {
        this.elements = new int[initialCapacity];
        this.FREE = no_value;
        Arrays.fill(this.elements, this.FREE);
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity - this.elements.length > 0) {
            int oldCapacity = this.elements.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - 0x7FFFFFF7 > 0) {
                newCapacity = 0x7FFFFFF7;
            }
            this.elements = Arrays.copyOf(this.elements, newCapacity);
            Arrays.fill(this.elements, oldCapacity, newCapacity, this.FREE);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void put(int key, int value) {
        this.ensureCapacity(key + 1);
        if (this.elements[key] == this.FREE) {
            ++this.size;
        }
        if (value == this.FREE) {
            --this.size;
        }
        this.elements[key] = value;
    }

    public void putOrAdjust(int key, int value, int inc) {
        this.ensureCapacity(key + 1);
        if (this.elements[key] == this.FREE) {
            ++this.size;
            this.elements[key] = value;
        } else {
            int n = key;
            this.elements[n] = this.elements[n] + inc;
        }
    }

    public int get(int key) {
        if (key <= 0 || key >= this.elements.length) {
            return -1;
        }
        return this.elements[key];
    }

    public boolean containsKey(int key) {
        return this.get(key) != this.FREE;
    }

    public void clear(int key) {
        if (key >= 0 && key <= this.elements.length) {
            this.elements[key] = this.FREE;
        }
    }

    public void clear() {
        Arrays.fill(this.elements, 0, this.size, this.FREE);
        this.size = 0;
    }
}

