/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.graphOperations.dominance;

import gnu.trove.list.array.TIntArrayList;
import java.util.Iterator;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;

public abstract class AbstractLengauerTarjanDominatorsFinder {
    protected DirectedGraph g;
    protected DirectedGraph T;
    protected int root;
    protected int n;
    protected int k;
    protected int[] parent;
    protected int[] vertex;
    protected int[] bucket;
    protected int[] ancestor;
    protected int[] label;
    protected int[] semi;
    protected int[] dom;
    protected ISet[] succs;
    protected ISet[] preds;
    protected Iterator<Integer>[] iterator;
    protected TIntArrayList list;

    public AbstractLengauerTarjanDominatorsFinder(int s, DirectedGraph g) {
        this.root = s;
        this.n = g.getNbMaxNodes();
        this.g = g;
        this.parent = new int[this.n];
        this.semi = new int[this.n];
        this.dom = new int[this.n];
        this.ancestor = new int[this.n];
        this.label = new int[this.n];
        this.vertex = new int[this.n];
        this.bucket = new int[this.n];
        this.succs = new ISet[this.n];
        this.preds = new ISet[this.n];
        this.iterator = new Iterator[this.n];
        this.T = new DirectedGraph(this.n, SetType.LINKED_LIST, false);
        this.list = new TIntArrayList();
    }

    public boolean findDominators() {
        this.initParams(false);
        this.DFS();
        if (this.k != this.n - 1) {
            return false;
        }
        this.findAllIdom();
        this.preprocessDominanceRequests();
        return true;
    }

    public boolean findPostDominators() {
        this.initParams(true);
        this.DFS();
        if (this.k != this.n - 1) {
            return false;
        }
        this.findAllIdom();
        this.preprocessDominanceRequests();
        return true;
    }

    protected void initParams(boolean inverseGraph) {
        for (int i = 0; i < this.n; ++i) {
            this.T.getSuccOf(i).clear();
            this.T.getPredOf(i).clear();
            if (inverseGraph) {
                this.succs[i] = this.g.getPredOf(i);
                this.preds[i] = this.g.getSuccOf(i);
            } else {
                this.succs[i] = this.g.getSuccOf(i);
                this.preds[i] = this.g.getPredOf(i);
            }
            this.semi[i] = -1;
            this.ancestor[i] = -1;
            this.bucket[i] = -1;
        }
    }

    private void DFS() {
        int node = this.root;
        this.semi[node] = this.k = 0;
        this.label[node] = node;
        this.vertex[this.k] = node;
        for (int i = 0; i < this.n; ++i) {
            this.iterator[i] = this.succs[i].iterator();
        }
        while (true) {
            if (this.iterator[node].hasNext()) {
                int next = this.iterator[node].next();
                if (this.semi[next] != -1) continue;
                this.semi[next] = ++this.k;
                this.label[next] = next;
                this.vertex[this.k] = next;
                this.parent[next] = node;
                node = next;
                continue;
            }
            if (node == this.root) break;
            node = this.parent[node];
        }
    }

    private void findAllIdom() {
        int w;
        int i;
        for (i = this.n - 1; i >= 1; --i) {
            int u;
            w = this.vertex[i];
            ISetIterator prds = this.preds[w].iterator();
            while (prds.hasNext()) {
                int v = prds.nextInt();
                u = this.eval(v);
                if (this.semi[u] >= this.semi[w]) continue;
                this.semi[w] = this.semi[u];
            }
            if (this.vertex[this.semi[w]] != this.parent[w]) {
                this.addToBucket(this.vertex[this.semi[w]], w);
            } else {
                this.dom[w] = this.parent[w];
            }
            this.link(this.parent[w], w);
            int oldBI = this.parent[w];
            int v = this.bucket[oldBI];
            while (v != -1) {
                this.bucket[oldBI] = -1;
                u = this.eval(v);
                this.dom[v] = this.semi[u] < this.semi[v] ? u : this.parent[w];
                oldBI = v;
                v = this.bucket[v];
            }
        }
        for (i = 1; i < this.n; ++i) {
            w = this.vertex[i];
            if (this.dom[w] != this.vertex[this.semi[w]]) {
                this.dom[w] = this.dom[this.dom[w]];
            }
            this.T.addArc(this.dom[w], w);
        }
        this.dom[this.root] = this.root;
    }

    private void addToBucket(int buckIdx, int element) {
        if (this.bucket[buckIdx] == -1) {
            this.bucket[buckIdx] = element;
        } else {
            int old = this.bucket[buckIdx];
            this.bucket[buckIdx] = element;
            this.bucket[element] = old;
        }
    }

    protected abstract void link(int var1, int var2);

    protected abstract int eval(int var1);

    protected abstract void compress(int var1);

    public int getImmediateDominatorsOf(int x) {
        return this.dom[x];
    }

    public boolean isDomminatedBy(int x, int y) {
        return this.ancestor[x] > this.ancestor[y] && this.semi[x] < this.semi[y];
    }

    public DirectedGraph getDominatorTree() {
        return this.T;
    }

    private void preprocessDominanceRequests() {
        int currentNode;
        for (int i = 0; i < this.n; ++i) {
            this.parent[i] = -1;
            this.succs[i] = this.T.getSuccOf(i);
            this.iterator[i] = this.succs[i].iterator();
        }
        int time = 0;
        this.parent[currentNode] = currentNode = this.root;
        this.ancestor[currentNode] = 0;
        while (true) {
            if (this.iterator[currentNode].hasNext()) {
                int nextNode = this.iterator[currentNode].next();
                if (this.parent[nextNode] != -1) continue;
                this.ancestor[nextNode] = ++time;
                this.parent[nextNode] = currentNode;
                currentNode = nextNode;
                continue;
            }
            this.semi[currentNode] = ++time;
            if (currentNode == this.root) break;
            currentNode = this.parent[currentNode];
        }
    }
}

