/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.RealEventType;
import org.chocosolver.solver.variables.impl.AbstractVariable;
import org.chocosolver.solver.variables.view.IView;

public class RealView
extends AbstractVariable
implements IView,
RealVar {
    protected final IntVar var;
    protected final double precision;

    public RealView(IntVar var, double precision) {
        super("(real)" + var.getName(), var.getModel());
        this.var = var;
        this.precision = precision;
        this.var.subscribeView(this);
    }

    @Override
    public IntVar getVariable() {
        return this.var;
    }

    @Override
    public void justifyEvent(IntVar var, ICause cause, IntEventType mask, int one, int two, int three) {
        throw new UnsupportedOperationException("RealView does not support explanation.");
    }

    @Override
    public String toString() {
        return "(real)" + this.var.toString();
    }

    @Override
    public double getLB() {
        return this.var.getLB();
    }

    @Override
    public double getUB() {
        return this.var.getUB();
    }

    @Override
    public boolean updateLowerBound(double value, ICause cause) throws ContradictionException {
        if (this.var.updateLowerBound((int)Math.ceil(value - this.precision), this)) {
            super.notifyPropagators(RealEventType.INCLOW, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateUpperBound(double value, ICause cause) throws ContradictionException {
        if (this.var.updateUpperBound((int)Math.floor(value + this.precision), this)) {
            super.notifyPropagators(RealEventType.INCLOW, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateBounds(double lowerbound, double upperbound, ICause cause) throws ContradictionException {
        int c = 0;
        c += this.var.updateLowerBound((int)Math.ceil(lowerbound - this.precision), this) ? 1 : 0;
        switch (c += this.var.updateUpperBound((int)Math.floor(upperbound + this.precision), this) ? 2 : 0) {
            case 3: {
                super.notifyPropagators(RealEventType.BOUND, cause);
                return true;
            }
            case 2: {
                super.notifyPropagators(RealEventType.DECUPP, cause);
                return true;
            }
            case 1: {
                super.notifyPropagators(RealEventType.INCLOW, cause);
                return true;
            }
        }
        return false;
    }

    @Override
    public double getPrecision() {
        return this.precision;
    }

    @Override
    public boolean isInstantiated() {
        return this.var.isInstantiated();
    }

    @Override
    public NoDelta getDelta() {
        return NoDelta.singleton;
    }

    @Override
    public void createDelta() {
    }

    @Override
    public void notifyMonitors(IEventType event) throws ContradictionException {
        for (int i = this.mIdx - 1; i >= 0; --i) {
            this.monitors[i].onUpdate(this, event);
        }
    }

    @Override
    public void notifyPropagators(IEventType event, ICause cause) throws ContradictionException {
        super.notifyPropagators(this.transformEvent((IntEventType)event), this);
    }

    public IEventType transformEvent(IntEventType evt) {
        switch (evt) {
            case REMOVE: {
                throw new UnsupportedOperationException("Cannot transform REMOVE event from int to real");
            }
            case INCLOW: {
                return RealEventType.INCLOW;
            }
            case DECUPP: {
                return RealEventType.DECUPP;
            }
        }
        return RealEventType.BOUND;
    }

    @Override
    public int getTypeAndKind() {
        return 68;
    }
}

