/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.view.IntView;
import org.chocosolver.solver.variables.view.ViewDeltaMonitor;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;

public final class OffsetView
extends IntView {
    public final int cste;

    public OffsetView(IntVar var, int cste) {
        super("(" + var.getName() + "+" + cste + ")", var);
        this.cste = cste;
    }

    @Override
    public IIntDeltaMonitor monitorDelta(ICause propagator) {
        this.var.createDelta();
        if (this.var.getDelta() == NoDelta.singleton) {
            return IIntDeltaMonitor.Default.NONE;
        }
        return new ViewDeltaMonitor(this.var.monitorDelta(propagator)){

            @Override
            protected int transform(int value) {
                return value + OffsetView.this.cste;
            }
        };
    }

    @Override
    protected boolean doInstantiateVar(int value) throws ContradictionException {
        return this.var.instantiateTo(value - this.cste, this);
    }

    @Override
    protected boolean doUpdateLowerBoundOfVar(int value) throws ContradictionException {
        return this.var.updateLowerBound(value - this.cste, this);
    }

    @Override
    protected boolean doUpdateUpperBoundOfVar(int value) throws ContradictionException {
        return this.var.updateUpperBound(value - this.cste, this);
    }

    @Override
    protected boolean doRemoveValueFromVar(int value) throws ContradictionException {
        return this.var.removeValue(value - this.cste, this);
    }

    @Override
    protected boolean doRemoveIntervalFromVar(int from, int to) throws ContradictionException {
        return this.var.removeInterval(from - this.cste, to - this.cste, this);
    }

    @Override
    public boolean contains(int value) {
        return this.var.contains(value - this.cste);
    }

    @Override
    public boolean isInstantiatedTo(int value) {
        return this.var.isInstantiatedTo(value - this.cste);
    }

    @Override
    public int getValue() {
        return this.var.getValue() + this.cste;
    }

    @Override
    public int getLB() {
        return this.var.getLB() + this.cste;
    }

    @Override
    public int getUB() {
        return this.var.getUB() + this.cste;
    }

    @Override
    public int nextValue(int v) {
        int value = this.var.nextValue(v - this.cste);
        if (value == Integer.MAX_VALUE) {
            return value;
        }
        return value + this.cste;
    }

    @Override
    public int nextValueOut(int v) {
        return this.var.nextValueOut(v - this.cste) + this.cste;
    }

    @Override
    public int previousValue(int v) {
        int value = this.var.previousValue(v - this.cste);
        if (value == Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return value + this.cste;
    }

    @Override
    public int previousValueOut(int v) {
        return this.var.previousValueOut(v - this.cste) + this.cste;
    }

    @Override
    public String toString() {
        return "(" + this.var.toString() + (this.cste >= 0 ? " + " : " - ") + Math.abs(this.cste) + ") = [" + this.getLB() + "," + this.getUB() + "]";
    }

    @Override
    public DisposableValueIterator getValueIterator(boolean bottomUp) {
        if (this._viterator == null || this._viterator.isNotReusable()) {
            this._viterator = new DisposableValueIterator(){
                DisposableValueIterator vit;

                @Override
                public void bottomUpInit() {
                    super.bottomUpInit();
                    this.vit = OffsetView.this.var.getValueIterator(true);
                }

                @Override
                public void topDownInit() {
                    super.topDownInit();
                    this.vit = OffsetView.this.var.getValueIterator(false);
                }

                @Override
                public boolean hasNext() {
                    return this.vit.hasNext();
                }

                @Override
                public boolean hasPrevious() {
                    return this.vit.hasPrevious();
                }

                @Override
                public int next() {
                    return this.vit.next() + OffsetView.this.cste;
                }

                @Override
                public int previous() {
                    return this.vit.previous() + OffsetView.this.cste;
                }

                @Override
                public void dispose() {
                    super.dispose();
                    this.vit.dispose();
                }
            };
        }
        if (bottomUp) {
            this._viterator.bottomUpInit();
        } else {
            this._viterator.topDownInit();
        }
        return this._viterator;
    }

    @Override
    public DisposableRangeIterator getRangeIterator(boolean bottomUp) {
        if (this._riterator == null || this._riterator.isNotReusable()) {
            this._riterator = new DisposableRangeIterator(){
                DisposableRangeIterator vir;

                @Override
                public void bottomUpInit() {
                    super.bottomUpInit();
                    this.vir = OffsetView.this.var.getRangeIterator(true);
                }

                @Override
                public void topDownInit() {
                    super.topDownInit();
                    this.vir = OffsetView.this.var.getRangeIterator(false);
                }

                @Override
                public boolean hasNext() {
                    return this.vir.hasNext();
                }

                @Override
                public boolean hasPrevious() {
                    return this.vir.hasPrevious();
                }

                @Override
                public void next() {
                    this.vir.next();
                }

                @Override
                public void previous() {
                    this.vir.previous();
                }

                @Override
                public int min() {
                    return this.vir.min() + OffsetView.this.cste;
                }

                @Override
                public int max() {
                    return this.vir.max() + OffsetView.this.cste;
                }

                @Override
                public void dispose() {
                    super.dispose();
                    this.vir.dispose();
                }
            };
        }
        if (bottomUp) {
            this._riterator.bottomUpInit();
        } else {
            this._riterator.topDownInit();
        }
        return this._riterator;
    }

    @Override
    public int transformValue(int value) {
        return value + this.cste;
    }

    @Override
    public int reverseValue(int value) {
        return value - this.cste;
    }

    @Override
    public void justifyEvent(IntVar var, ICause cause, IntEventType mask, int one, int two, int three) {
        switch (mask) {
            case DECUPP: {
                this.model.getSolver().getExplainer().updateUpperBound(this, one + this.cste, two + this.cste, var);
                break;
            }
            case INCLOW: {
                this.model.getSolver().getExplainer().updateLowerBound(this, one + this.cste, two + this.cste, var);
                break;
            }
            case REMOVE: {
                this.model.getSolver().getExplainer().removeValue(this, one + this.cste, var);
                break;
            }
            case INSTANTIATE: {
                this.model.getSolver().getExplainer().instantiateTo(this, one + this.cste, var, two + this.cste, three + this.cste);
            }
        }
    }
}

