/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view;

import java.util.Iterator;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IDelta;
import org.chocosolver.solver.variables.delta.IntDelta;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.impl.AbstractVariable;
import org.chocosolver.solver.variables.view.IView;
import org.chocosolver.util.iterators.DisposableRangeBoundIterator;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueBoundIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.iterators.IntVarValueIterator;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSet;

public abstract class IntView
extends AbstractVariable
implements IView,
IntVar {
    protected final IntVar var;
    protected IntDelta delta;
    protected DisposableValueIterator _viterator;
    protected DisposableRangeIterator _riterator;
    private IntVarValueIterator _javaIterator = new IntVarValueIterator(this);

    protected IntView(String name, IntVar var) {
        super(name, var.getModel());
        this.var = var;
        this.delta = NoDelta.singleton;
        this.var.subscribeView(this);
    }

    protected boolean doInstantiateVar(int value) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    protected boolean doUpdateLowerBoundOfVar(int value) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    protected boolean doUpdateUpperBoundOfVar(int value) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    protected boolean doRemoveValueFromVar(int value) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    protected boolean doRemoveIntervalFromVar(int from, int to) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeValue(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        int inf = this.getLB();
        int sup = this.getUB();
        if (inf <= value && value <= sup) {
            IntEventType e = IntEventType.REMOVE;
            this.model.getSolver().getExplainer().removeValue(this, value, cause);
            if (this.doRemoveValueFromVar(value)) {
                if (value == inf) {
                    e = IntEventType.INCLOW;
                } else if (value == sup) {
                    e = IntEventType.DECUPP;
                }
                if (this.isInstantiated()) {
                    e = IntEventType.INSTANTIATE;
                }
                this.notifyPropagators(e, cause);
                return true;
            }
            this.model.getSolver().getExplainer().undo();
        }
        return false;
    }

    @Override
    public boolean removeValues(IntIterableSet values, ICause cause) throws ContradictionException {
        assert (cause != null);
        int olb = this.getLB();
        int oub = this.getUB();
        int nlb = values.nextValue(olb - 1);
        int nub = values.previousValue(oub + 1);
        if (nlb > oub || nub < olb) {
            return false;
        }
        if (nlb == olb) {
            do {
                olb = this.nextValue(olb);
                nlb = values.nextValue(olb - 1);
            } while (olb < Integer.MAX_VALUE && oub < Integer.MAX_VALUE && nlb == olb);
        }
        if (nub == oub) {
            do {
                oub = this.previousValue(oub);
                nub = values.previousValue(oub + 1);
            } while (olb > Integer.MIN_VALUE && oub > Integer.MIN_VALUE && nub == oub);
        }
        boolean hasChanged = this.updateBounds(olb, oub, cause);
        int value = nlb;
        int to = nub;
        boolean hasRemoved = false;
        while (value <= to) {
            this.model.getSolver().getExplainer().removeValue(this, value, cause);
            if (this.doRemoveValueFromVar(value)) {
                hasRemoved |= true;
            } else {
                this.model.getSolver().getExplainer().undo();
            }
            value = values.nextValue(value);
        }
        if (hasRemoved) {
            IntEventType e = IntEventType.REMOVE;
            if (this.var.isInstantiated()) {
                e = IntEventType.INSTANTIATE;
            }
            this.notifyPropagators(e, cause);
        }
        return hasRemoved || hasChanged;
    }

    @Override
    public boolean removeInterval(int from, int to, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (from <= this.getLB()) {
            return this.updateLowerBound(to + 1, cause);
        }
        if (this.getUB() <= to) {
            return this.updateUpperBound(from - 1, cause);
        }
        if (this.var.hasEnumeratedDomain()) {
            for (int v = from; v <= to; ++v) {
                if (!this.contains(v)) continue;
                this.model.getSolver().getExplainer().removeValue(this, v, cause);
            }
            boolean done = this.doRemoveIntervalFromVar(from, to);
            if (done) {
                this.notifyPropagators(IntEventType.REMOVE, cause);
            }
            return done;
        }
        return false;
    }

    @Override
    public boolean removeAllValuesBut(IntIterableSet values, ICause cause) throws ContradictionException {
        int olb = this.getLB();
        int oub = this.getUB();
        int nlb = values.nextValue(olb - 1);
        int nub = values.previousValue(oub + 1);
        boolean hasChanged = this.updateBounds(nlb, nub, cause);
        int to = this.previousValue(nub);
        boolean hasRemoved = false;
        int value = this.nextValue(nlb);
        while (value <= to) {
            if (!values.contains(value)) {
                this.model.getSolver().getExplainer().removeValue(this, value, cause);
                if (this.doRemoveValueFromVar(value)) {
                    hasRemoved |= true;
                } else {
                    this.model.getSolver().getExplainer().undo();
                }
            }
            value = this.nextValue(value);
        }
        if (hasRemoved) {
            IntEventType e = IntEventType.REMOVE;
            if (this.isInstantiated()) {
                e = IntEventType.INSTANTIATE;
            }
            this.notifyPropagators(e, cause);
        }
        return hasRemoved || hasChanged;
    }

    @Override
    public boolean instantiateTo(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        this.model.getSolver().getExplainer().instantiateTo(this, value, cause, this.getLB(), this.getUB());
        boolean done = this.doInstantiateVar(value);
        if (done) {
            this.notifyPropagators(IntEventType.INSTANTIATE, cause);
            return true;
        }
        this.model.getSolver().getExplainer().undo();
        return false;
    }

    @Override
    public boolean updateLowerBound(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        int old = this.getLB();
        if (old < value) {
            this.model.getSolver().getExplainer().updateLowerBound(this, value, this.getLB(), cause);
            IntEventType e = IntEventType.INCLOW;
            boolean done = this.doUpdateLowerBoundOfVar(value);
            if (this.isInstantiated()) {
                e = IntEventType.INSTANTIATE;
            }
            if (done) {
                this.notifyPropagators(e, cause);
                return true;
            }
            this.model.getSolver().getExplainer().undo();
        }
        return false;
    }

    @Override
    public boolean updateUpperBound(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        int old = this.getUB();
        if (old > value) {
            this.model.getSolver().getExplainer().updateUpperBound(this, value, this.getUB(), cause);
            IntEventType e = IntEventType.DECUPP;
            boolean done = this.doUpdateUpperBoundOfVar(value);
            if (this.isInstantiated()) {
                e = IntEventType.INSTANTIATE;
            }
            if (done) {
                this.notifyPropagators(e, cause);
                return true;
            }
            this.model.getSolver().getExplainer().undo();
        }
        return false;
    }

    @Override
    public boolean updateBounds(int lb, int ub, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (lb > ub) {
            this.contradiction(cause, "");
        }
        int olb = this.getLB();
        int oub = this.getUB();
        boolean hasChanged = false;
        if (olb < lb || oub > ub) {
            IntEventType e = null;
            if (olb < lb) {
                this.model.getSolver().getExplainer().updateLowerBound(this, lb, this.getLB(), cause);
                e = IntEventType.INCLOW;
                if (this.doUpdateLowerBoundOfVar(lb)) {
                    hasChanged = true;
                } else {
                    this.model.getSolver().getExplainer().undo();
                }
            }
            if (oub > ub) {
                e = e == null ? IntEventType.DECUPP : IntEventType.BOUND;
                this.model.getSolver().getExplainer().updateUpperBound(this, ub, this.getUB(), cause);
                if (this.doUpdateUpperBoundOfVar(ub)) {
                    hasChanged |= true;
                } else {
                    this.model.getSolver().getExplainer().undo();
                }
            }
            if (this.isInstantiated()) {
                e = IntEventType.INSTANTIATE;
            }
            if (hasChanged) {
                this.notifyPropagators(e, cause);
            }
        }
        return hasChanged;
    }

    @Override
    public int getTypeAndKind() {
        return 12;
    }

    @Override
    public IntVar getVariable() {
        return this.var;
    }

    @Override
    public int getDomainSize() {
        return this.var.getDomainSize();
    }

    @Override
    public int getRange() {
        return this.var.getRange();
    }

    @Override
    public boolean hasEnumeratedDomain() {
        return this.var.hasEnumeratedDomain();
    }

    @Override
    public boolean isInstantiated() {
        return this.var.isInstantiated();
    }

    @Override
    public IDelta getDelta() {
        return this.var.getDelta();
    }

    @Override
    public void createDelta() {
        this.var.createDelta();
    }

    @Override
    public int compareTo(Variable o) {
        return this.getId() - o.getId();
    }

    @Override
    public void notifyMonitors(IEventType event) throws ContradictionException {
        for (int i = this.mIdx - 1; i >= 0; --i) {
            this.monitors[i].onUpdate(this, event);
        }
    }

    @Override
    public void notifyPropagators(IEventType event, ICause cause) throws ContradictionException {
        super.notifyPropagators(this.transformEvent(event), this);
    }

    @Override
    public IEventType transformEvent(IEventType evt) {
        return evt;
    }

    @Override
    public DisposableValueIterator getValueIterator(boolean bottomUp) {
        if (this._viterator == null || this._viterator.isNotReusable()) {
            this._viterator = new DisposableValueBoundIterator(this);
        }
        if (bottomUp) {
            this._viterator.bottomUpInit();
        } else {
            this._viterator.topDownInit();
        }
        return this._viterator;
    }

    @Override
    public DisposableRangeIterator getRangeIterator(boolean bottomUp) {
        if (this._riterator == null || this._riterator.isNotReusable()) {
            this._riterator = new DisposableRangeBoundIterator(this);
        }
        if (bottomUp) {
            this._riterator.bottomUpInit();
        } else {
            this._riterator.topDownInit();
        }
        return this._riterator;
    }

    @Override
    public Iterator<Integer> iterator() {
        this._javaIterator.reset();
        return this._javaIterator;
    }

    @Override
    public boolean why(RuleStore ruleStore, IntVar modifiedVar, IEventType evt, int value) {
        IntEventType ievt;
        boolean observed;
        boolean newrules = false;
        boolean bl = observed = modifiedVar == this.var;
        if (observed) {
            value = this.transformValue(value);
            ievt = (IntEventType)this.transformEvent(evt);
        } else {
            value = modifiedVar.reverseValue(value);
            ievt = (IntEventType)modifiedVar.transformEvent(evt);
        }
        switch (ievt) {
            case REMOVE: {
                newrules = ruleStore.addRemovalRule(this, value);
                break;
            }
            case DECUPP: {
                newrules = ruleStore.addUpperBoundRule(this);
                break;
            }
            case INCLOW: {
                newrules = ruleStore.addLowerBoundRule(this);
                break;
            }
            case INSTANTIATE: {
                newrules = ruleStore.addFullDomainRule(this);
            }
        }
        return newrules;
    }
}

