/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.view.IntView;
import org.chocosolver.solver.variables.view.ViewDeltaMonitor;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSet;

public final class BoolNotView
extends IntView
implements BoolVar {
    private final BoolVar var;

    public BoolNotView(BoolVar var) {
        super("not(" + var.getName() + ")", var);
        this.var = var;
    }

    @Override
    public ESat getBooleanValue() {
        return ESat.not(this.var.getBooleanValue());
    }

    @Override
    public boolean setToTrue(ICause cause) throws ContradictionException {
        if (this.var.setToFalse(this)) {
            this.notifyPropagators(IntEventType.INSTANTIATE, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean setToFalse(ICause cause) throws ContradictionException {
        if (this.var.setToTrue(this)) {
            this.notifyPropagators(IntEventType.INSTANTIATE, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeValue(int value, ICause cause) throws ContradictionException {
        return this.contains(value) && this.instantiateTo(1 - value, cause);
    }

    @Override
    public boolean removeValues(IntIterableSet values, ICause cause) throws ContradictionException {
        boolean hasChanged = false;
        if (values.contains(0)) {
            hasChanged = this.instantiateTo(1, cause);
        }
        if (values.contains(1)) {
            hasChanged = this.instantiateTo(0, cause);
        }
        return hasChanged;
    }

    @Override
    public boolean removeAllValuesBut(IntIterableSet values, ICause cause) throws ContradictionException {
        boolean hasChanged = false;
        if (!values.contains(0)) {
            hasChanged = this.instantiateTo(1, cause);
        }
        if (!values.contains(1)) {
            hasChanged = this.instantiateTo(0, cause);
        }
        return hasChanged;
    }

    @Override
    public boolean removeInterval(int from, int to, ICause cause) throws ContradictionException {
        boolean hasChanged = false;
        if (from <= to && from <= 1 && to >= 0) {
            if (from == 1) {
                hasChanged = this.instantiateTo(1, cause);
            } else if (to == 0) {
                hasChanged = this.instantiateTo(0, cause);
            } else {
                this.instantiateTo(2, cause);
            }
        }
        return hasChanged;
    }

    @Override
    public boolean instantiateTo(int value, ICause cause) throws ContradictionException {
        this.model.getSolver().getExplainer().instantiateTo(this, value, cause, this.getLB(), this.getUB());
        if (this.var.instantiateTo(1 - value, this)) {
            this.notifyPropagators(IntEventType.INSTANTIATE, cause);
            return true;
        }
        this.model.getSolver().getExplainer().undo();
        return false;
    }

    @Override
    public boolean updateLowerBound(int value, ICause cause) throws ContradictionException {
        if (value > 0) {
            this.model.getSolver().getExplainer().updateLowerBound(this, value, this.getLB(), cause);
            if (this.var.instantiateTo(1 - value, this)) {
                this.notifyPropagators(IntEventType.INSTANTIATE, cause);
                return true;
            }
            this.model.getSolver().getExplainer().undo();
        }
        return false;
    }

    @Override
    public boolean updateUpperBound(int value, ICause cause) throws ContradictionException {
        if (value < 1) {
            this.model.getSolver().getExplainer().updateUpperBound(this, value, this.getUB(), cause);
            if (this.var.instantiateTo(1 - value, this)) {
                this.notifyPropagators(IntEventType.INSTANTIATE, cause);
                return true;
            }
            this.model.getSolver().getExplainer().undo();
        }
        return false;
    }

    @Override
    public boolean updateBounds(int lb, int ub, ICause cause) throws ContradictionException {
        boolean hasChanged = false;
        if (lb > 1) {
            this.var.instantiateTo(-1, cause);
        } else if (ub < 0) {
            this.var.instantiateTo(2, cause);
        } else if (lb == 1) {
            hasChanged = this.instantiateTo(1, cause);
        } else if (ub == 0) {
            hasChanged = this.instantiateTo(0, cause);
        }
        return hasChanged;
    }

    @Override
    public boolean contains(int value) {
        return this.var.contains(1 - value);
    }

    @Override
    public boolean isInstantiatedTo(int value) {
        return this.var.isInstantiatedTo(1 - value);
    }

    @Override
    public int getValue() {
        int v = this.var.getValue();
        return 1 - v;
    }

    @Override
    public int getLB() {
        if (this.var.isInstantiated()) {
            return this.getValue();
        }
        return 0;
    }

    @Override
    public int getUB() {
        if (this.var.isInstantiated()) {
            return this.getValue();
        }
        return 1;
    }

    @Override
    public int nextValue(int v) {
        if (v < 0 && this.contains(0)) {
            return 0;
        }
        return v <= 0 && this.contains(1) ? 1 : Integer.MAX_VALUE;
    }

    @Override
    public int nextValueOut(int v) {
        if (this.var.isInstantiated() && v == this.getValue() - 1) {
            return this.getValue() + 1;
        }
        if (-1 <= v && v <= 1) {
            return 2;
        }
        return v + 1;
    }

    @Override
    public int previousValue(int v) {
        if (v > 1 && this.contains(1)) {
            return 1;
        }
        return v >= 1 && this.contains(0) ? 0 : Integer.MIN_VALUE;
    }

    @Override
    public int previousValueOut(int v) {
        if (this.var.isInstantiated() && v == this.getValue() + 1) {
            return this.getValue() - 1;
        }
        if (0 <= v && v <= 2) {
            return -1;
        }
        return v - 1;
    }

    @Override
    public IIntDeltaMonitor monitorDelta(ICause propagator) {
        this.var.createDelta();
        if (this.var.getDelta() == NoDelta.singleton) {
            return IIntDeltaMonitor.Default.NONE;
        }
        return new ViewDeltaMonitor(this.var.monitorDelta(propagator)){

            @Override
            protected int transform(int value) {
                return 1 - value;
            }
        };
    }

    @Override
    public String toString() {
        return "not(" + this.var.getName() + ")";
    }

    @Override
    public BoolVar not() {
        return this.var;
    }

    @Override
    public void _setNot(BoolVar not) {
        assert (not == this.var);
    }

    @Override
    public boolean hasNot() {
        return true;
    }

    @Override
    public boolean isLit() {
        return true;
    }

    @Override
    public boolean isNot() {
        return !this.var.isNot();
    }

    @Override
    public void setNot(boolean isNot) {
        assert (isNot);
    }

    @Override
    public int getTypeAndKind() {
        return 28;
    }

    @Override
    public boolean why(RuleStore ruleStore, IntVar modifiedVar, IEventType evt, int value) {
        assert (modifiedVar == this.var);
        return ruleStore.addFullDomainRule(this);
    }

    @Override
    public int transformValue(int value) {
        assert (value == 0 || value == 1);
        return 1 - value;
    }

    @Override
    public void justifyEvent(IntVar var, ICause cause, IntEventType mask, int one, int two, int three) {
        assert (mask == IntEventType.INSTANTIATE);
        this.model.getSolver().getExplainer().instantiateTo(this, 1 - one, var, 0, 1);
    }
}

