/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import org.chocosolver.memory.IStateDouble;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.RealEventType;
import org.chocosolver.solver.variables.impl.AbstractVariable;

public class RealVarImpl
extends AbstractVariable
implements RealVar {
    private IStateDouble LB;
    private IStateDouble UB;
    private double precision;

    public RealVarImpl(String name, double lb, double ub, double precision, Model model) {
        super(name, model);
        this.LB = model.getEnvironment().makeFloat(lb);
        this.UB = model.getEnvironment().makeFloat(ub);
        this.precision = precision;
    }

    @Override
    public double getPrecision() {
        return this.precision;
    }

    @Override
    public double getLB() {
        return this.LB.get();
    }

    @Override
    public double getUB() {
        return this.UB.get();
    }

    @Override
    public boolean updateLowerBound(double value, ICause cause) throws ContradictionException {
        assert (cause != null);
        double old = this.getLB();
        if (old < value) {
            if (this.getUB() < value) {
                this.contradiction(cause, "new upper bound is lesser than lower bound");
            } else {
                this.LB.set(value);
                this.notifyPropagators(RealEventType.INCLOW, cause);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean updateUpperBound(double value, ICause cause) throws ContradictionException {
        assert (cause != null);
        double old = this.getUB();
        if (old > value) {
            if (this.getLB() > value) {
                this.contradiction(cause, "new lower bound is greater than upper bound");
            } else {
                this.UB.set(value);
                this.notifyPropagators(RealEventType.DECUPP, cause);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean updateBounds(double lowerbound, double upperbound, ICause cause) throws ContradictionException {
        assert (cause != null);
        double oldlb = this.getLB();
        double oldub = this.getUB();
        if (oldlb < lowerbound || oldub > upperbound) {
            if (oldub < lowerbound || oldlb > upperbound) {
                this.contradiction(cause, "new bounds are incorrect");
            } else {
                RealEventType e = RealEventType.VOID;
                if (oldlb < lowerbound) {
                    this.LB.set(lowerbound);
                    e = RealEventType.INCLOW;
                }
                if (oldub > upperbound) {
                    this.UB.set(upperbound);
                    e = e == RealEventType.INCLOW ? RealEventType.BOUND : RealEventType.DECUPP;
                }
                this.notifyPropagators(e, cause);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isInstantiated() {
        double lb = this.LB.get();
        double ub = this.UB.get();
        return ub - lb < this.precision || this.nextValue(lb) >= ub;
    }

    private double nextValue(double x) {
        if (x < 0.0) {
            return Double.longBitsToDouble(Double.doubleToLongBits(x) - 1L);
        }
        if (x == 0.0) {
            return Double.longBitsToDouble(1L);
        }
        if (x < Double.POSITIVE_INFINITY) {
            return Double.longBitsToDouble(Double.doubleToLongBits(x) + 1L);
        }
        return x;
    }

    @Override
    public NoDelta getDelta() {
        return NoDelta.singleton;
    }

    @Override
    public void createDelta() {
        throw new SolverException("Unable to create delta for RealVar!");
    }

    @Override
    public void notifyMonitors(IEventType event) throws ContradictionException {
        for (int i = this.mIdx - 1; i >= 0; --i) {
            this.monitors[i].onUpdate(this, event);
        }
    }

    @Override
    public int getTypeAndKind() {
        return 65;
    }

    @Override
    public String toString() {
        return String.format("%s = [%.16f .. %.16f]", this.name, this.getLB(), this.getUB());
    }
}

