/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.delta.IDelta;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.impl.AbstractVariable;

public class FixedRealVarImpl
extends AbstractVariable
implements RealVar {
    double value;

    public FixedRealVarImpl(String name, double value, Model model) {
        super(name, model);
        this.value = value;
    }

    @Override
    public double getLB() {
        return this.value;
    }

    @Override
    public double getUB() {
        return this.value;
    }

    @Override
    public boolean updateLowerBound(double value, ICause cause) throws ContradictionException {
        if (value > value) {
            assert (cause != null);
            this.contradiction(cause, "outside domain update bound");
        }
        return false;
    }

    @Override
    public boolean updateUpperBound(double value, ICause cause) throws ContradictionException {
        if (value < value) {
            assert (cause != null);
            this.contradiction(cause, "outside domain update bound");
        }
        return false;
    }

    @Override
    public boolean updateBounds(double lowerbound, double upperbound, ICause cause) throws ContradictionException {
        if (lowerbound > this.value || upperbound < this.value) {
            assert (cause != null);
            this.contradiction(cause, "outside domain update bound");
        }
        return false;
    }

    @Override
    public double getPrecision() {
        return Double.MIN_VALUE;
    }

    @Override
    public boolean isInstantiated() {
        return true;
    }

    @Override
    public IDelta getDelta() {
        return NoDelta.singleton;
    }

    @Override
    public void createDelta() {
    }

    @Override
    public void notifyMonitors(IEventType event) throws ContradictionException {
    }

    @Override
    public int getTypeAndKind() {
        return 66;
    }
}

