/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.impl.FixedIntVarImpl;
import org.chocosolver.util.ESat;

public class FixedBoolVarImpl
extends FixedIntVarImpl
implements BoolVar {
    private BoolVar not;

    public FixedBoolVarImpl(String name, int constant, Model model) {
        super(name, constant, model);
        assert (constant == 0 || constant == 1) : "FixedBoolVarImpl value should be taken in {0,1}";
    }

    @Override
    public int getTypeAndKind() {
        return 26;
    }

    @Override
    public ESat getBooleanValue() {
        return ESat.eval(this.constante == 1);
    }

    @Override
    public boolean setToTrue(ICause cause) throws ContradictionException {
        return this.instantiateTo(1, cause);
    }

    @Override
    public boolean setToFalse(ICause cause) throws ContradictionException {
        return this.instantiateTo(0, cause);
    }

    @Override
    public BoolVar not() {
        if (!this.hasNot()) {
            this.not = this.model.boolNotView(this);
            this.not._setNot(this);
        }
        return this.not;
    }

    @Override
    public void _setNot(BoolVar not) {
        this.not = not;
    }

    @Override
    public boolean isLit() {
        return true;
    }

    @Override
    public boolean hasNot() {
        return this.not != null;
    }

    @Override
    public boolean isNot() {
        return this.constante == 0;
    }

    @Override
    public void setNot(boolean isNot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this.name + " = " + String.valueOf(this.constante);
    }
}

