/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import java.util.Iterator;
import org.chocosolver.memory.structure.BasicIndexedBipartiteSet;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.delta.IEnumDelta;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.delta.OneValueDelta;
import org.chocosolver.solver.variables.delta.monitor.OneValueDeltaMonitor;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.impl.AbstractVariable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.iterators.DisposableRangeBoundIterator;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueBoundIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.iterators.IntVarValueIterator;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSet;

public class BoolVarImpl
extends AbstractVariable
implements BoolVar {
    private final int offset;
    private int mValue = 0;
    private final BasicIndexedBipartiteSet notInstanciated;
    private IEnumDelta delta = NoDelta.singleton;
    private DisposableValueIterator _viterator;
    private DisposableRangeIterator _riterator;
    private IntVarValueIterator _javaIterator = new IntVarValueIterator(this);
    private boolean reactOnRemoval = false;
    private BoolVar not;
    private boolean isNot = false;

    public BoolVarImpl(String name, Model model) {
        super(name, model);
        this.notInstanciated = this.model.getEnvironment().getSharedBipartiteSetForBooleanVars();
        this.offset = this.notInstanciated.add();
    }

    @Override
    public boolean removeValue(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (value == 0) {
            return this.instantiateTo(1, cause);
        }
        if (value == 1) {
            return this.instantiateTo(0, cause);
        }
        return false;
    }

    @Override
    public boolean removeValues(IntIterableSet values, ICause cause) throws ContradictionException {
        boolean hasChanged = false;
        if (values.contains(0)) {
            hasChanged = this.instantiateTo(1, cause);
        }
        if (values.contains(1)) {
            hasChanged = this.instantiateTo(0, cause);
        }
        return hasChanged;
    }

    @Override
    public boolean removeAllValuesBut(IntIterableSet values, ICause cause) throws ContradictionException {
        boolean hasChanged = false;
        if (!values.contains(0)) {
            hasChanged = this.instantiateTo(1, cause);
        }
        if (!values.contains(1)) {
            hasChanged = this.instantiateTo(0, cause);
        }
        return hasChanged;
    }

    @Override
    public boolean removeInterval(int from, int to, ICause cause) throws ContradictionException {
        boolean hasChanged = false;
        if (from <= to && from <= 1 && to >= 0) {
            if (from == 1) {
                hasChanged = this.instantiateTo(0, cause);
            } else if (to == 0) {
                hasChanged = this.instantiateTo(1, cause);
            } else {
                this.model.getSolver().getExplainer().instantiateTo(this, 2, cause, 0, 1);
                this.contradiction(cause, "unknown value");
            }
        }
        return hasChanged;
    }

    @Override
    public boolean instantiateTo(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (!this.contains(value)) {
            this.model.getSolver().getExplainer().instantiateTo(this, value, cause, this.getLB(), this.getUB());
            this.contradiction(cause, "already instantiated");
        } else if (!this.isInstantiated()) {
            IntEventType e = IntEventType.INSTANTIATE;
            assert (this.notInstanciated.contains(this.offset));
            this.notInstanciated.swap(this.offset);
            if (this.reactOnRemoval) {
                this.delta.add(1 - value, cause);
            }
            this.mValue = value;
            this.model.getSolver().getExplainer().instantiateTo(this, value, cause, 0, 1);
            this.notifyPropagators(e, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateLowerBound(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        return value > 0 && this.instantiateTo(value, cause);
    }

    @Override
    public boolean updateUpperBound(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        return value < 1 && this.instantiateTo(value, cause);
    }

    @Override
    public boolean updateBounds(int lb, int ub, ICause cause) throws ContradictionException {
        boolean hasChanged = false;
        if (lb > 1 || ub < 0) {
            this.model.getSolver().getExplainer().instantiateTo(this, 2, cause, 0, 1);
            this.contradiction(cause, "unknown value");
        } else if (lb == 1) {
            hasChanged = this.instantiateTo(1, cause);
        } else if (ub == 0) {
            hasChanged = this.instantiateTo(0, cause);
        }
        return hasChanged;
    }

    @Override
    public boolean setToTrue(ICause cause) throws ContradictionException {
        assert (cause != null);
        return this.instantiateTo(1, cause);
    }

    @Override
    public boolean setToFalse(ICause cause) throws ContradictionException {
        assert (cause != null);
        return this.instantiateTo(0, cause);
    }

    @Override
    public boolean isInstantiated() {
        return !this.notInstanciated.contains(this.offset);
    }

    @Override
    public boolean isInstantiatedTo(int aValue) {
        return !this.notInstanciated.contains(this.offset) && this.mValue == aValue;
    }

    @Override
    public boolean contains(int aValue) {
        if (!this.notInstanciated.contains(this.offset)) {
            return this.mValue == aValue;
        }
        return aValue == 0 || aValue == 1;
    }

    @Override
    public int getValue() {
        assert (this.isInstantiated()) : this.name + " not instantiated";
        return this.getLB();
    }

    @Override
    public ESat getBooleanValue() {
        if (this.isInstantiated()) {
            return ESat.eval(this.getLB() != 0);
        }
        return ESat.UNDEFINED;
    }

    @Override
    public int getLB() {
        if (!this.notInstanciated.contains(this.offset)) {
            return this.mValue;
        }
        return 0;
    }

    @Override
    public int getUB() {
        if (!this.notInstanciated.contains(this.offset)) {
            return this.mValue;
        }
        return 1;
    }

    @Override
    public int getDomainSize() {
        return this.notInstanciated.contains(this.offset) ? 2 : 1;
    }

    @Override
    public int getRange() {
        return this.getDomainSize();
    }

    @Override
    public int nextValue(int v) {
        if (!this.notInstanciated.contains(this.offset)) {
            int val = this.mValue;
            return val > v ? val : Integer.MAX_VALUE;
        }
        if (v < 0) {
            return 0;
        }
        if (v == 0) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int nextValueOut(int v) {
        if (!this.notInstanciated.contains(this.offset) && v == this.mValue - 1) {
            return this.mValue + 1;
        }
        if (-1 <= v && v <= 1) {
            return 2;
        }
        return v + 1;
    }

    @Override
    public int previousValue(int v) {
        if (v > this.getUB()) {
            return this.getUB();
        }
        if (v > this.getLB()) {
            return this.getLB();
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int previousValueOut(int v) {
        if (!this.notInstanciated.contains(this.offset) && v == this.mValue + 1) {
            return this.mValue - 1;
        }
        if (0 <= v && v <= 2) {
            return -1;
        }
        return v - 1;
    }

    @Override
    public boolean hasEnumeratedDomain() {
        return true;
    }

    @Override
    public IEnumDelta getDelta() {
        return this.delta;
    }

    @Override
    public String toString() {
        if (!this.notInstanciated.contains(this.offset)) {
            return this.name + " = " + Integer.toString(this.mValue);
        }
        return this.name + " = " + "[0,1]";
    }

    @Override
    public void createDelta() {
        if (!this.reactOnRemoval) {
            this.delta = new OneValueDelta(this.model.getEnvironment());
            this.reactOnRemoval = true;
        }
    }

    @Override
    public IIntDeltaMonitor monitorDelta(ICause propagator) {
        this.createDelta();
        return new OneValueDeltaMonitor(this.delta, propagator);
    }

    @Override
    public void notifyMonitors(IEventType event) throws ContradictionException {
        for (int i = this.mIdx - 1; i >= 0; --i) {
            this.monitors[i].onUpdate(this, event);
        }
    }

    @Override
    public int getTypeAndKind() {
        return 25;
    }

    @Override
    public DisposableValueIterator getValueIterator(boolean bottomUp) {
        if (this._viterator == null || this._viterator.isNotReusable()) {
            this._viterator = new DisposableValueBoundIterator(this);
        }
        if (bottomUp) {
            this._viterator.bottomUpInit();
        } else {
            this._viterator.topDownInit();
        }
        return this._viterator;
    }

    @Override
    public DisposableRangeIterator getRangeIterator(boolean bottomUp) {
        if (this._riterator == null || this._riterator.isNotReusable()) {
            this._riterator = new DisposableRangeBoundIterator(this);
        }
        if (bottomUp) {
            this._riterator.bottomUpInit();
        } else {
            this._riterator.topDownInit();
        }
        return this._riterator;
    }

    @Override
    public Iterator<Integer> iterator() {
        this._javaIterator.reset();
        return this._javaIterator;
    }

    @Override
    public void _setNot(BoolVar neg) {
        this.not = neg;
    }

    @Override
    public BoolVar not() {
        if (!this.hasNot()) {
            this.not = this.model.boolNotView(this);
            this.not._setNot(this);
        }
        return this.not;
    }

    @Override
    public boolean hasNot() {
        return this.not != null;
    }

    @Override
    public boolean isLit() {
        return true;
    }

    @Override
    public boolean isNot() {
        return this.isNot;
    }

    @Override
    public void setNot(boolean isNot) {
        this.isNot = isNot;
    }
}

