/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import gnu.trove.map.hash.TIntIntHashMap;
import java.util.Iterator;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateBitSet;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.delta.EnumDelta;
import org.chocosolver.solver.variables.delta.IEnumDelta;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.delta.monitor.EnumDeltaMonitor;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.impl.AbstractVariable;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.iterators.IntVarValueIterator;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSet;
import org.chocosolver.util.tools.ArrayUtils;

public final class BitsetArrayIntVarImpl
extends AbstractVariable
implements IntVar {
    private boolean reactOnRemoval = false;
    private final int[] VALUES;
    private final TIntIntHashMap V2I;
    private final IStateBitSet INDICES;
    private final IStateInt LB;
    private final IStateInt UB;
    private final IStateInt SIZE;
    private final int LENGTH;
    private IEnumDelta delta = NoDelta.singleton;
    private DisposableValueIterator _viterator;
    private DisposableRangeIterator _riterator;
    private IntVarValueIterator _javaIterator = new IntVarValueIterator(this);

    public BitsetArrayIntVarImpl(String name, int[] sortedValues, Model model) {
        super(name, model);
        IEnvironment env = this.model.getEnvironment();
        this.LENGTH = sortedValues.length;
        this.VALUES = (int[])sortedValues.clone();
        this.V2I = new TIntIntHashMap(this.VALUES.length, 0.5f, Integer.MIN_VALUE, -1);
        this.INDICES = env.makeBitSet(this.LENGTH);
        this.INDICES.set(0, this.LENGTH);
        for (int i = 0; i < this.VALUES.length; ++i) {
            this.V2I.put(this.VALUES[i], i);
        }
        this.LB = env.makeInt(0);
        this.UB = env.makeInt(this.LENGTH - 1);
        this.SIZE = env.makeInt(this.LENGTH);
    }

    @Override
    public boolean removeValue(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (value < this.VALUES[this.LB.get()] || value > this.VALUES[this.UB.get()]) {
            return false;
        }
        int index = this.V2I.get(value);
        if (index > -1 && this.INDICES.get(index)) {
            if (this.SIZE.get() == 1) {
                this.model.getSolver().getExplainer().removeValue(this, value, cause);
                this.contradiction(cause, "remove last value");
            }
            IntEventType e = IntEventType.REMOVE;
            this.INDICES.clear(index);
            this.SIZE.add(-1);
            if (this.reactOnRemoval) {
                this.delta.add(value, cause);
            }
            if (value == this.getLB()) {
                this.LB.set(this.INDICES.nextSetBit(this.LB.get()));
                e = IntEventType.INCLOW;
            } else if (value == this.getUB()) {
                this.UB.set(this.INDICES.prevSetBit(this.UB.get()));
                e = IntEventType.DECUPP;
            }
            assert (!this.INDICES.isEmpty());
            if (this.isInstantiated()) {
                e = IntEventType.INSTANTIATE;
            }
            this.model.getSolver().getExplainer().removeValue(this, value, cause);
            this.notifyPropagators(e, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeValues(IntIterableSet values, ICause cause) throws ContradictionException {
        int i;
        assert (cause != null);
        int olb = this.getLB();
        int oub = this.getUB();
        int nlb = values.nextValue(olb - 1);
        int nub = values.previousValue(oub + 1);
        if (nlb > oub || nub < olb) {
            return false;
        }
        if (nlb == olb) {
            do {
                olb = (i = this.INDICES.nextSetBit(this.V2I.get(olb) + 1)) > -1 ? this.VALUES[i] : Integer.MAX_VALUE;
                nlb = values.nextValue(olb - 1);
            } while (olb < Integer.MAX_VALUE && oub < Integer.MAX_VALUE && nlb == olb);
        }
        if (nub == oub) {
            do {
                oub = (i = this.INDICES.prevSetBit(this.V2I.get(oub) - 1)) > -1 ? this.VALUES[i] : Integer.MIN_VALUE;
                nub = values.previousValue(oub + 1);
            } while (olb > Integer.MIN_VALUE && oub > Integer.MIN_VALUE && nub == oub);
        }
        boolean hasChanged = this.updateBounds(olb, oub, cause);
        int value = nlb;
        int to = nub;
        boolean hasRemoved = false;
        int count = this.SIZE.get();
        while (value <= to) {
            int index = this.V2I.get(value);
            if (index > -1 && this.INDICES.get(index)) {
                this.model.getSolver().getExplainer().removeValue(this, value, cause);
                if (count == 1) {
                    this.contradiction(cause, "remove last value");
                }
                --count;
                hasRemoved = true;
                this.INDICES.clear(index);
                if (this.reactOnRemoval) {
                    this.delta.add(value, cause);
                }
            }
            value = values.nextValue(value);
        }
        if (hasRemoved) {
            this.notifyOnRemovals(count, cause);
        }
        return hasRemoved || hasChanged;
    }

    @Override
    public boolean removeAllValuesBut(IntIterableSet values, ICause cause) throws ContradictionException {
        int i;
        int olb = this.getLB();
        int oub = this.getUB();
        int nlb = values.nextValue(olb - 1);
        int nub = values.previousValue(oub + 1);
        if (nlb != olb) {
            do {
                olb = (i = this.INDICES.nextSetBit(this.V2I.get(olb) + 1)) > -1 ? this.VALUES[i] : Integer.MAX_VALUE;
                nlb = values.nextValue(olb - 1);
            } while (olb < Integer.MAX_VALUE && oub < Integer.MAX_VALUE && nlb != olb);
        }
        if (nub != oub) {
            do {
                oub = (i = this.INDICES.prevSetBit(this.V2I.get(oub) - 1)) > -1 ? this.VALUES[i] : Integer.MIN_VALUE;
                nub = values.previousValue(oub + 1);
            } while (olb > Integer.MIN_VALUE && oub > Integer.MIN_VALUE && nub != oub);
        }
        boolean hasChanged = this.updateBounds(nlb, nub, cause);
        int to = this.UB.get() - 1;
        boolean hasRemoved = false;
        int count = this.SIZE.get();
        int index = this.INDICES.nextSetBit(this.LB.get() + 1);
        while (index > -1 && index <= to) {
            int value = this.VALUES[index];
            if (!values.contains(value)) {
                this.model.getSolver().getExplainer().removeValue(this, value, cause);
                if (count == 1) {
                    this.contradiction(cause, "remove last value");
                }
                --count;
                hasRemoved = true;
                this.INDICES.clear(index);
                if (this.reactOnRemoval) {
                    this.delta.add(value, cause);
                }
            }
            index = this.INDICES.nextSetBit(index + 1);
        }
        if (hasRemoved) {
            this.notifyOnRemovals(count, cause);
        }
        return hasRemoved || hasChanged;
    }

    private void notifyOnRemovals(int count, ICause cause) throws ContradictionException {
        this.SIZE.set(count);
        IntEventType e = IntEventType.REMOVE;
        if (count == 1) {
            e = IntEventType.INSTANTIATE;
        }
        this.notifyPropagators(e, cause);
    }

    @Override
    public boolean removeInterval(int from, int to, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (from <= this.getLB()) {
            return this.updateLowerBound(to + 1, cause);
        }
        if (this.getUB() <= to) {
            return this.updateUpperBound(from - 1, cause);
        }
        boolean anyChange = false;
        int count = this.SIZE.get();
        int i = this.V2I.get(this.nextValue(from - 1));
        int _to = this.V2I.get(this.previousValue(to + 1));
        while (i > -1 && i <= _to) {
            int value = this.VALUES[i];
            anyChange = true;
            --count;
            this.INDICES.clear(i);
            if (this.reactOnRemoval) {
                this.delta.add(value, cause);
            }
            this.model.getSolver().getExplainer().removeValue(this, value, cause);
            i = this.INDICES.nextSetBit(i + 1);
        }
        if (anyChange) {
            this.SIZE.set(count);
            this.notifyPropagators(IntEventType.REMOVE, cause);
        }
        return anyChange;
    }

    @Override
    public boolean instantiateTo(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (!this.contains(value)) {
            this.model.getSolver().getExplainer().instantiateTo(this, value, cause, this.getLB(), this.getUB());
            this.contradiction(cause, "already instantiated");
        } else if (!this.isInstantiated()) {
            this.model.getSolver().getExplainer().instantiateTo(this, value, cause, this.getLB(), this.getUB());
            int index = this.V2I.get(value);
            assert (index > -1 && this.INDICES.get(index));
            if (this.reactOnRemoval) {
                int i = this.INDICES.nextSetBit(this.LB.get());
                while (i >= 0) {
                    if (i != index) {
                        this.delta.add(this.VALUES[i], cause);
                    }
                    i = this.INDICES.nextSetBit(i + 1);
                }
            }
            this.INDICES.clear();
            this.INDICES.set(index);
            this.LB.set(index);
            this.UB.set(index);
            this.SIZE.set(1);
            assert (!this.INDICES.isEmpty());
            this.notifyPropagators(IntEventType.INSTANTIATE, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateLowerBound(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        int lb = this.LB.get();
        int old = this.VALUES[lb];
        if (old < value) {
            this.model.getSolver().getExplainer().updateLowerBound(this, value, old, cause);
            int ub = this.UB.get();
            int oub = this.VALUES[ub];
            if (oub < value) {
                this.contradiction(cause, "new upper bound is lesser than lower bound");
            } else {
                IntEventType e = IntEventType.INCLOW;
                int index = this.indexOfLowerBound(value, lb, ub);
                assert (index >= 0 && this.VALUES[index] >= value);
                if (this.reactOnRemoval) {
                    int i = lb;
                    while (i >= 0 && i < index) {
                        this.delta.add(this.VALUES[i], cause);
                        i = this.INDICES.nextSetBit(i + 1);
                    }
                }
                this.INDICES.clear(lb, index);
                this.LB.set(index);
                assert (this.SIZE.get() > this.INDICES.cardinality());
                this.SIZE.set(this.INDICES.cardinality());
                if (this.isInstantiated()) {
                    e = IntEventType.INSTANTIATE;
                }
                this.notifyPropagators(e, cause);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean updateUpperBound(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        int ub = this.UB.get();
        int old = this.VALUES[ub];
        if (old > value) {
            this.model.getSolver().getExplainer().updateUpperBound(this, value, old, cause);
            int lb = this.LB.get();
            int olb = this.VALUES[lb];
            if (olb > value) {
                this.contradiction(cause, "new lower bound is greater than upper bound");
            } else {
                IntEventType e = IntEventType.DECUPP;
                int index = this.indexOfUpperBound(value, lb, ub);
                assert (index >= 0 && this.VALUES[index] <= value);
                if (this.reactOnRemoval) {
                    int i = ub;
                    while (i >= 0 && i > index) {
                        this.delta.add(this.VALUES[i], cause);
                        i = this.INDICES.prevSetBit(i - 1);
                    }
                }
                this.INDICES.clear(index + 1, ub + 1);
                this.UB.set(index);
                assert (this.SIZE.get() > this.INDICES.cardinality());
                this.SIZE.set(this.INDICES.cardinality());
                if (this.isInstantiated()) {
                    e = IntEventType.INSTANTIATE;
                }
                this.notifyPropagators(e, cause);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean updateBounds(int aLB, int aUB, ICause cause) throws ContradictionException {
        assert (cause != null);
        int lb = this.LB.get();
        int ub = this.UB.get();
        int olb = this.VALUES[lb];
        int oub = this.VALUES[ub];
        boolean update = false;
        if (olb < aLB || oub > aUB) {
            int i;
            int index;
            int b;
            if (olb < aLB) {
                this.model.getSolver().getExplainer().updateLowerBound(this, aLB, olb, cause);
            }
            if (oub > aUB) {
                this.model.getSolver().getExplainer().updateUpperBound(this, aUB, oub, cause);
            }
            IntEventType e = null;
            if (oub < aLB) {
                this.contradiction(cause, "new upper bound is lesser than lower bound");
            } else if (olb < aLB) {
                e = IntEventType.INCLOW;
                b = this.LB.get();
                index = this.indexOfLowerBound(aLB, lb, ub);
                assert (index >= 0 && this.VALUES[index] >= aLB);
                if (this.reactOnRemoval) {
                    i = b;
                    while (i >= 0 && i < index) {
                        this.delta.add(this.VALUES[i], cause);
                        i = this.INDICES.nextSetBit(i + 1);
                    }
                }
                this.INDICES.clear(b, index);
                this.LB.set(index);
                olb = this.VALUES[index];
            }
            if (olb > aUB) {
                this.contradiction(cause, "new lower bound is greater than upper bound");
            } else if (oub > aUB) {
                e = e == null ? IntEventType.DECUPP : IntEventType.BOUND;
                b = this.UB.get();
                index = this.indexOfUpperBound(aUB, lb, ub);
                assert (index >= 0 && this.VALUES[index] <= aUB);
                if (this.reactOnRemoval) {
                    i = b;
                    while (i >= 0 && i > index) {
                        this.delta.add(this.VALUES[i], cause);
                        i = this.INDICES.prevSetBit(i - 1);
                    }
                }
                this.INDICES.clear(index + 1, b + 1);
                this.UB.set(index);
            }
            assert (this.SIZE.get() > this.INDICES.cardinality());
            this.SIZE.set(this.INDICES.cardinality());
            if (this.isInstantiated()) {
                e = IntEventType.INSTANTIATE;
            }
            this.notifyPropagators(e, cause);
            update = true;
        }
        return update;
    }

    private int indexOfLowerBound(int aLB, int lb, int ub) {
        int index = this.V2I.get(aLB);
        if (index == -1 || !this.INDICES.get(index)) {
            index = ArrayUtils.binarySearchInc(this.VALUES, lb, ub + 1, aLB, true);
            index = index < lb || index > ub ? -1 : this.INDICES.nextSetBit(index);
        }
        return index;
    }

    private int indexOfUpperBound(int value, int lb, int ub) {
        int index = this.V2I.get(value);
        if (index == -1 || !this.INDICES.get(index)) {
            index = ArrayUtils.binarySearchInc(this.VALUES, lb, ub + 1, value, false);
            index = index < lb || index > ub ? -1 : this.INDICES.prevSetBit(index);
        }
        return index;
    }

    @Override
    public boolean isInstantiated() {
        return this.SIZE.get() == 1;
    }

    @Override
    public boolean isInstantiatedTo(int value) {
        return this.isInstantiated() && this.contains(value);
    }

    @Override
    public boolean contains(int aValue) {
        if (aValue >= this.getLB() && aValue <= this.getUB()) {
            int i = this.V2I.get(aValue);
            return i > -1 && this.INDICES.get(this.V2I.get(aValue));
        }
        return false;
    }

    @Override
    public int getValue() {
        assert (this.isInstantiated()) : this.name + " not instantiated";
        return this.getLB();
    }

    @Override
    public int getLB() {
        assert (this.LB.get() >= 0 && this.LB.get() < this.LENGTH);
        return this.VALUES[this.LB.get()];
    }

    @Override
    public int getUB() {
        assert (this.UB.get() >= 0 && this.UB.get() < this.LENGTH);
        return this.VALUES[this.UB.get()];
    }

    @Override
    public int getDomainSize() {
        return this.SIZE.get();
    }

    @Override
    public int getRange() {
        return this.getUB() - this.getLB() + 1;
    }

    @Override
    public int nextValue(int aValue) {
        int lb = this.LB.get();
        if (aValue < this.VALUES[lb]) {
            return this.VALUES[lb];
        }
        int ub = this.UB.get();
        if (aValue >= this.VALUES[ub]) {
            return Integer.MAX_VALUE;
        }
        int i = this.V2I.get(aValue);
        i = i > -1 ? this.INDICES.nextSetBit(i + 1) : ((i = ArrayUtils.binarySearchInc(this.VALUES, lb, ub + 1, aValue, true)) < lb || i > ub ? -1 : this.INDICES.nextSetBit(i));
        return i >= 0 ? this.VALUES[i] : Integer.MAX_VALUE;
    }

    @Override
    public int nextValueOut(int aValue) {
        int lb = this.LB.get();
        int ub = this.UB.get();
        if (this.VALUES[lb] - 1 <= aValue && aValue <= this.VALUES[ub]) {
            int i = this.V2I.get(aValue);
            if (i == -1) {
                i = ArrayUtils.binarySearchInc(this.VALUES, lb, ub + 1, aValue, true);
            }
            while (i < this.VALUES.length && this.VALUES[i] == aValue + 1 && this.INDICES.get(i)) {
                aValue = this.VALUES[i];
                ++i;
            }
        }
        return aValue + 1;
    }

    @Override
    public int previousValue(int aValue) {
        int ub = this.UB.get();
        if (aValue > this.VALUES[ub]) {
            return this.VALUES[ub];
        }
        int lb = this.LB.get();
        if (aValue <= this.VALUES[lb]) {
            return Integer.MIN_VALUE;
        }
        int i = this.V2I.get(aValue);
        i = i > -1 ? this.INDICES.prevSetBit(i - 1) : ((i = ArrayUtils.binarySearchInc(this.VALUES, lb, ub + 1, aValue, false)) < lb || i > ub ? -1 : this.INDICES.prevSetBit(i));
        return i >= 0 ? this.VALUES[i] : Integer.MIN_VALUE;
    }

    @Override
    public int previousValueOut(int aValue) {
        int lb = this.LB.get();
        int ub = this.UB.get();
        if (this.VALUES[lb] <= aValue && aValue <= this.VALUES[ub] + 1) {
            int i = this.V2I.get(aValue);
            if (i == -1) {
                i = ArrayUtils.binarySearchInc(this.VALUES, lb, ub + 1, aValue, true) - 1;
            }
            while (i > -1 && this.VALUES[i] == aValue - 1 && this.INDICES.get(i)) {
                aValue = this.VALUES[i];
                --i;
            }
        }
        return aValue - 1;
    }

    @Override
    public boolean hasEnumeratedDomain() {
        return true;
    }

    @Override
    public IEnumDelta getDelta() {
        return this.delta;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(20);
        s.append(this.name).append(" = ");
        if (this.SIZE.get() == 1) {
            s.append(this.getLB());
        } else {
            int nb;
            s.append('{').append(this.getLB());
            int i = this.nextValue(this.getLB());
            for (nb = 5; i < Integer.MAX_VALUE && nb > 0; --nb) {
                s.append(',').append(i);
                i = this.nextValue(i);
            }
            if (nb == 0 && this.SIZE.get() > 6) {
                s.append("...,").append(this.getUB());
            }
            s.append('}');
        }
        return s.toString();
    }

    @Override
    public void createDelta() {
        if (!this.reactOnRemoval) {
            this.delta = new EnumDelta(this.model.getEnvironment());
            this.reactOnRemoval = true;
        }
    }

    @Override
    public IIntDeltaMonitor monitorDelta(ICause propagator) {
        this.createDelta();
        return new EnumDeltaMonitor(this.delta, propagator);
    }

    @Override
    public void notifyMonitors(IEventType event) throws ContradictionException {
        for (int i = this.mIdx - 1; i >= 0; --i) {
            this.monitors[i].onUpdate(this, event);
        }
    }

    @Override
    public int getTypeAndKind() {
        return 9;
    }

    @Override
    public DisposableValueIterator getValueIterator(boolean bottomUp) {
        if (this._viterator == null || this._viterator.isNotReusable()) {
            this._viterator = new DisposableValueIterator(){
                int index;

                @Override
                public void bottomUpInit() {
                    super.bottomUpInit();
                    this.index = BitsetArrayIntVarImpl.this.INDICES.nextSetBit(BitsetArrayIntVarImpl.this.LB.get());
                }

                @Override
                public void topDownInit() {
                    super.topDownInit();
                    this.index = BitsetArrayIntVarImpl.this.INDICES.prevSetBit(BitsetArrayIntVarImpl.this.UB.get());
                }

                @Override
                public boolean hasNext() {
                    return this.index != -1;
                }

                @Override
                public boolean hasPrevious() {
                    return this.index != -1;
                }

                @Override
                public int next() {
                    int old = BitsetArrayIntVarImpl.this.VALUES[this.index];
                    this.index = BitsetArrayIntVarImpl.this.INDICES.nextSetBit(this.index + 1);
                    return old;
                }

                @Override
                public int previous() {
                    int old = BitsetArrayIntVarImpl.this.VALUES[this.index];
                    this.index = BitsetArrayIntVarImpl.this.INDICES.prevSetBit(this.index - 1);
                    return old;
                }
            };
        }
        if (bottomUp) {
            this._viterator.bottomUpInit();
        } else {
            this._viterator.topDownInit();
        }
        return this._viterator;
    }

    @Override
    public DisposableRangeIterator getRangeIterator(boolean bottomUp) {
        if (this._riterator == null || this._riterator.isNotReusable()) {
            this._riterator = new DisposableRangeIterator(){
                int from;
                int to;

                @Override
                public void bottomUpInit() {
                    super.bottomUpInit();
                    this.to = this.from = BitsetArrayIntVarImpl.this.INDICES.nextSetBit(BitsetArrayIntVarImpl.this.LB.get());
                    while (BitsetArrayIntVarImpl.this.INDICES.get(this.to + 1) && BitsetArrayIntVarImpl.this.VALUES[this.to] == BitsetArrayIntVarImpl.this.VALUES[this.to + 1] - 1) {
                        ++this.to;
                    }
                }

                @Override
                public void topDownInit() {
                    super.topDownInit();
                    this.from = this.to = BitsetArrayIntVarImpl.this.INDICES.prevSetBit(BitsetArrayIntVarImpl.this.UB.get());
                    while (BitsetArrayIntVarImpl.this.INDICES.get(this.from - 1) && BitsetArrayIntVarImpl.this.VALUES[this.from - 1] == BitsetArrayIntVarImpl.this.VALUES[this.from] - 1) {
                        --this.from;
                    }
                }

                @Override
                public boolean hasNext() {
                    return this.from != -1;
                }

                @Override
                public boolean hasPrevious() {
                    return this.to != -1;
                }

                @Override
                public void next() {
                    this.to = this.from = BitsetArrayIntVarImpl.this.INDICES.nextSetBit(this.to + 1);
                    while (this.to > -1 && BitsetArrayIntVarImpl.this.INDICES.get(this.to + 1) && BitsetArrayIntVarImpl.this.VALUES[this.to] == BitsetArrayIntVarImpl.this.VALUES[this.to + 1] - 1) {
                        ++this.to;
                    }
                }

                @Override
                public void previous() {
                    this.from = this.to = BitsetArrayIntVarImpl.this.INDICES.prevSetBit(this.from - 1);
                    while (this.from > -1 && BitsetArrayIntVarImpl.this.INDICES.get(this.from - 1) && BitsetArrayIntVarImpl.this.VALUES[this.from - 1] == BitsetArrayIntVarImpl.this.VALUES[this.from] - 1) {
                        --this.from;
                    }
                }

                @Override
                public int min() {
                    return BitsetArrayIntVarImpl.this.VALUES[this.from];
                }

                @Override
                public int max() {
                    return BitsetArrayIntVarImpl.this.VALUES[this.to];
                }
            };
        }
        if (bottomUp) {
            this._riterator.bottomUpInit();
        } else {
            this._riterator.topDownInit();
        }
        return this._riterator;
    }

    @Override
    public Iterator<Integer> iterator() {
        this._javaIterator.reset();
        return this._javaIterator;
    }
}

