/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import java.util.Arrays;
import org.chocosolver.solver.Cause;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IVariableMonitor;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.impl.scheduler.BoolEvtScheduler;
import org.chocosolver.solver.variables.impl.scheduler.IntEvtScheduler;
import org.chocosolver.solver.variables.impl.scheduler.RealEvtScheduler;
import org.chocosolver.solver.variables.impl.scheduler.SetEvtScheduler;
import org.chocosolver.solver.variables.view.IView;
import org.chocosolver.util.iterators.EvtScheduler;

public abstract class AbstractVariable
implements Variable {
    protected static final String MSG_REMOVE = "remove last value";
    protected static final String MSG_EMPTY = "empty domain";
    protected static final String MSG_INST = "already instantiated";
    protected static final String MSG_UNKNOWN = "unknown value";
    protected static final String MSG_UPP = "new lower bound is greater than upper bound";
    protected static final String MSG_LOW = "new upper bound is lesser than lower bound";
    protected static final String MSG_BOUND = "new bounds are incorrect";
    private final int ID;
    protected final Model model;
    protected final String name;
    protected Propagator[] propagators;
    protected int[] pindices;
    private int[] dindices;
    private IView[] views;
    private int vIdx;
    protected IVariableMonitor[] monitors;
    protected int mIdx;
    private EvtScheduler scheduler;

    protected AbstractVariable(String name, Model model) {
        this.name = name;
        this.model = model;
        this.views = new IView[2];
        this.monitors = new IVariableMonitor[2];
        this.propagators = new Propagator[8];
        this.pindices = new int[8];
        this.dindices = new int[6];
        this.ID = this.model.nextId();
        this.model.associates(this);
        int kind = this.getTypeAndKind() & 0x3F8;
        switch (kind) {
            case 24: {
                this.scheduler = new BoolEvtScheduler();
                break;
            }
            case 8: {
                this.scheduler = new IntEvtScheduler();
                break;
            }
            case 64: {
                this.scheduler = new RealEvtScheduler();
                break;
            }
            case 32: {
                this.scheduler = new SetEvtScheduler();
                break;
            }
        }
    }

    @Override
    public final int getId() {
        return this.ID;
    }

    @Override
    public final int link(Propagator propagator, int idxInProp) {
        if (this.dindices[5] == this.propagators.length) {
            Propagator[] tmp = this.propagators;
            this.propagators = new Propagator[tmp.length * 3 / 2 + 1];
            System.arraycopy(tmp, 0, this.propagators, 0, this.dindices[5]);
            int[] itmp = this.pindices;
            this.pindices = new int[itmp.length * 3 / 2 + 1];
            System.arraycopy(itmp, 0, this.pindices, 0, this.dindices[5]);
            if (this.pindices.length != this.propagators.length) {
                throw new UnsupportedOperationException("error: pindices.length != propagators.length in " + this);
            }
        }
        int pc = propagator.getPropagationConditions(idxInProp);
        int pos = -1;
        if (pc > 0) {
            pos = this.subscribe(propagator, idxInProp, this.scheduler.select(pc));
        }
        return pos;
    }

    private void move(int from, int to) {
        if (this.propagators[from] != null) {
            this.propagators[to] = this.propagators[from];
            this.pindices[to] = this.pindices[from];
            this.propagators[to].setVIndices(this.pindices[from], to);
            this.propagators[from] = null;
        }
    }

    int subscribe(Propagator p, int ip, int i) {
        for (int j = 4; j >= i; --j) {
            this.move(this.dindices[j], this.dindices[j + 1]);
            int n = j + 1;
            this.dindices[n] = this.dindices[n] + 1;
        }
        this.propagators[this.dindices[i]] = p;
        this.pindices[this.dindices[i]] = ip;
        return this.dindices[i];
    }

    @Override
    public final void unlink(Propagator propagator, int idxInProp) {
        int i = propagator.getVIndice(idxInProp);
        assert (this.propagators[i] == propagator) : "Try to unlink :\n" + propagator + "\nfrom " + this.getName() + " but found:\n" + this.propagators[i];
        this.cancel(i, this.scheduler.select(propagator.getPropagationConditions(this.pindices[i])));
    }

    void cancel(int pp, int i) {
        this.move(this.dindices[i + 1] - 1, pp);
        int j = i + 1;
        while (j < 5) {
            this.move(this.dindices[j + 1] - 1, this.dindices[j] - 1);
            int n = j++;
            this.dindices[n] = this.dindices[n] - 1;
        }
        this.dindices[5] = this.dindices[5] - 1;
    }

    @Override
    public final Propagator[] getPropagators() {
        return this.propagators;
    }

    @Override
    public final Propagator getPropagator(int idx) {
        return this.propagators[idx];
    }

    @Override
    public final int getNbProps() {
        return this.dindices[5];
    }

    @Override
    public final int[] getPIndices() {
        return this.pindices;
    }

    @Override
    public final void setPIndice(int pos, int val) {
        this.pindices[pos] = val;
    }

    @Override
    public final int getDindex(int i) {
        return this.dindices[i];
    }

    @Override
    public final int getIndexInPropagator(int pidx) {
        return this.pindices[pidx];
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public void notifyPropagators(IEventType event, ICause cause) throws ContradictionException {
        assert (cause != null);
        this.model.getSolver().getEngine().onVariableUpdate(this, event, cause);
        this.notifyMonitors(event);
        this.notifyViews(event, cause);
    }

    @Override
    public void notifyViews(IEventType event, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (cause == Cause.Null) {
            for (int i = this.vIdx - 1; i >= 0; --i) {
                this.views[i].notifyPropagators(event, cause);
            }
        } else {
            for (int i = this.vIdx - 1; i >= 0; --i) {
                if (this.views[i] == cause) continue;
                this.views[i].notifyPropagators(event, cause);
            }
        }
    }

    @Override
    public void addMonitor(IVariableMonitor monitor) {
        for (int i = 0; i < this.mIdx; ++i) {
            if (this.monitors[i] != monitor) continue;
            return;
        }
        if (this.mIdx == this.monitors.length) {
            IVariableMonitor[] tmp = this.monitors;
            this.monitors = new IVariableMonitor[tmp.length * 3 / 2 + 1];
            System.arraycopy(tmp, 0, this.monitors, 0, this.mIdx);
        }
        this.monitors[this.mIdx++] = monitor;
    }

    @Override
    public void removeMonitor(IVariableMonitor monitor) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public void subscribeView(IView view) {
        if (this.vIdx == this.views.length) {
            IView[] tmp = this.views;
            this.views = new IView[tmp.length * 3 / 2 + 1];
            System.arraycopy(tmp, 0, this.views, 0, this.vIdx);
        }
        this.views[this.vIdx++] = view;
    }

    @Override
    public final void contradiction(ICause cause, String message) throws ContradictionException {
        assert (cause != null);
        this.model.getSolver().throwsException(cause, this, message);
    }

    @Override
    public final Model getModel() {
        return this.model;
    }

    @Override
    public final IView[] getViews() {
        return Arrays.copyOfRange(this.views, 0, this.vIdx);
    }

    @Override
    public int compareTo(Variable o) {
        return this.getId() - o.getId();
    }

    public String toString() {
        return this.getName();
    }

    public final boolean isBool() {
        return (this.getTypeAndKind() & 0x3F8) == 24;
    }

    @Override
    public final boolean isAConstant() {
        return (this.getTypeAndKind() & 7) == 2;
    }

    public final EvtScheduler _schedIter() {
        return this.scheduler;
    }
}

