/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.delta.monitor;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.TimeStampedObject;
import org.chocosolver.solver.variables.delta.ISetDelta;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.procedure.IntProcedure;

public class SetDeltaMonitor
extends TimeStampedObject
implements ISetDeltaMonitor {
    protected final ISetDelta delta;
    protected int[] first;
    protected int[] last;
    protected int[] frozenFirst;
    protected int[] frozenLast;
    protected ICause propagator;

    public SetDeltaMonitor(ISetDelta delta, ICause propagator) {
        super(delta.getEnvironment());
        this.delta = delta;
        this.first = new int[2];
        this.last = new int[2];
        this.frozenFirst = new int[2];
        this.frozenLast = new int[2];
        this.propagator = propagator;
    }

    @Override
    public void freeze() {
        int i;
        if (this.needReset()) {
            this.delta.lazyClear();
            for (i = 0; i < 2; ++i) {
                this.last[i] = 0;
                this.first[i] = 0;
            }
            this.resetStamp();
        }
        assert (this.getTimeStamp() == ((TimeStampedObject)((Object)this.delta)).getTimeStamp()) : "Delta and monitor desynchronized. deltamonitor.freeze() is calledbut no value has been removed since the last call.";
        for (i = 0; i < 2; ++i) {
            this.frozenFirst[i] = this.first[i];
            this.frozenLast[i] = this.last[i] = this.delta.getSize(i);
            this.first[i] = this.last[i];
        }
    }

    @Override
    public void unfreeze() {
        this.delta.lazyClear();
        this.resetStamp();
        for (int i = 0; i < 2; ++i) {
            this.first[i] = this.last[i] = this.delta.getSize(i);
        }
    }

    @Override
    public void forEach(IntProcedure proc, SetEventType evt) throws ContradictionException {
        int x;
        if (evt == SetEventType.ADD_TO_KER) {
            x = 0;
        } else if (evt == SetEventType.REMOVE_FROM_ENVELOPE) {
            x = 1;
        } else {
            throw new UnsupportedOperationException("The event in parameter should be ADD_TO_KER or REMOVE_FROM_ENVELOPE");
        }
        for (int i = this.frozenFirst[x]; i < this.frozenLast[x]; ++i) {
            if (this.delta.getCause(i, x) == this.propagator) continue;
            proc.execute(this.delta.get(i, x));
        }
    }
}

