/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.delta.monitor;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.TimeStampedObject;
import org.chocosolver.solver.variables.delta.IEnumDelta;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.procedure.SafeIntProcedure;

public class OneValueDeltaMonitor
extends TimeStampedObject
implements IIntDeltaMonitor {
    protected final IEnumDelta delta;
    protected boolean used;
    protected ICause propagator;

    public OneValueDeltaMonitor(IEnumDelta delta, ICause propagator) {
        super(delta.getEnvironment());
        this.delta = delta;
        this.used = false;
        this.propagator = propagator;
    }

    @Override
    public void freeze() {
        if (this.needReset()) {
            this.delta.lazyClear();
            this.used = false;
            this.resetStamp();
        }
        this.used = this.delta.size() == 1;
    }

    @Override
    public void unfreeze() {
        this.used = false;
        this.delta.lazyClear();
    }

    @Override
    public void forEachRemVal(SafeIntProcedure proc) {
        if (this.used && this.propagator != this.delta.getCause(0)) {
            proc.execute(this.delta.get(0));
        }
    }

    @Override
    public void forEachRemVal(IntProcedure proc) throws ContradictionException {
        if (this.used && this.propagator != this.delta.getCause(0)) {
            proc.execute(this.delta.get(0));
        }
    }

    @Override
    public int sizeApproximation() {
        return this.used && this.propagator != this.delta.getCause(0) ? 1 : 0;
    }
}

