/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.delta.monitor;

import org.chocosolver.solver.Cause;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.TimeStampedObject;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.delta.IIntervalDelta;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.procedure.SafeIntProcedure;

public class IntervalDeltaMonitor
extends TimeStampedObject
implements IIntDeltaMonitor {
    protected final IIntervalDelta delta;
    protected int first;
    protected int last;
    protected int frozenFirst;
    protected int frozenLast;
    protected ICause propagator;

    public IntervalDeltaMonitor(IIntervalDelta delta, ICause propagator) {
        super(delta.getEnvironment());
        this.delta = delta;
        this.first = 0;
        this.last = 0;
        this.frozenFirst = 0;
        this.frozenLast = 0;
        this.propagator = propagator;
    }

    @Override
    public void freeze() {
        if (this.needReset()) {
            this.delta.lazyClear();
            this.last = 0;
            this.first = 0;
            this.resetStamp();
        }
        assert (this.getTimeStamp() == ((TimeStampedObject)((Object)this.delta)).getTimeStamp()) : "Delta and monitor desynchronized. deltamonitor.freeze() is calledbut no value has been removed since the last call.";
        this.frozenFirst = this.first;
        this.frozenLast = this.last = this.delta.size();
    }

    @Override
    public void unfreeze() {
        this.delta.lazyClear();
        this.resetStamp();
        this.first = this.last = this.delta.size();
    }

    @Override
    public void forEachRemVal(SafeIntProcedure proc) {
        for (int i = this.frozenFirst; i < this.frozenLast; ++i) {
            if (this.propagator != Cause.Null && this.propagator == this.delta.getCause(i)) continue;
            int ub = this.delta.getUB(i);
            for (int lb = this.delta.getLB(i); lb <= ub; ++lb) {
                proc.execute(lb);
            }
        }
    }

    @Override
    public void forEachRemVal(IntProcedure proc) throws ContradictionException {
        for (int i = this.frozenFirst; i < this.frozenLast; ++i) {
            if (this.propagator != Cause.Null && this.propagator == this.delta.getCause(i)) continue;
            int ub = this.delta.getUB(i);
            for (int lb = this.delta.getLB(i); lb <= ub; ++lb) {
                proc.execute(lb);
            }
        }
    }

    public String toString() {
        return String.format("(%d,%d) => (%d,%d) :: %d", this.first, this.last, this.frozenFirst, this.frozenLast, this.delta.size());
    }

    @Override
    public int sizeApproximation() {
        return this.frozenLast - this.frozenFirst;
    }
}

