/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.delta.monitor;

import org.chocosolver.solver.Cause;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.TimeStampedObject;
import org.chocosolver.solver.variables.delta.IEnumDelta;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.procedure.SafeIntProcedure;

public class EnumDeltaMonitor
extends TimeStampedObject
implements IIntDeltaMonitor {
    protected final IEnumDelta delta;
    protected int first;
    protected int last;
    protected int frozenFirst;
    protected int frozenLast;
    protected ICause propagator;

    public EnumDeltaMonitor(IEnumDelta delta, ICause propagator) {
        super(delta.getEnvironment());
        this.delta = delta;
        this.first = 0;
        this.last = 0;
        this.frozenFirst = 0;
        this.frozenLast = 0;
        this.propagator = propagator;
    }

    @Override
    public void freeze() {
        if (this.needReset()) {
            this.delta.lazyClear();
            this.last = 0;
            this.first = 0;
            this.resetStamp();
        }
        this.frozenFirst = this.first;
        this.frozenLast = this.last = this.delta.size();
    }

    @Override
    public void unfreeze() {
        this.delta.lazyClear();
        this.resetStamp();
        this.first = this.last = this.delta.size();
    }

    @Override
    public void forEachRemVal(SafeIntProcedure proc) {
        for (int i = this.frozenFirst; i < this.frozenLast; ++i) {
            if (this.propagator != Cause.Null && this.propagator == this.delta.getCause(i)) continue;
            proc.execute(this.delta.get(i));
        }
    }

    @Override
    public void forEachRemVal(IntProcedure proc) throws ContradictionException {
        for (int i = this.frozenFirst; i < this.frozenLast; ++i) {
            if (this.propagator != Cause.Null && this.propagator == this.delta.getCause(i)) continue;
            proc.execute(this.delta.get(i));
        }
    }

    public String toString() {
        return String.format("(%d,%d) => (%d,%d) :: %d", this.first, this.last, this.frozenFirst, this.frozenLast, this.delta.size());
    }

    @Override
    public int sizeApproximation() {
        return this.frozenLast - this.frozenFirst;
    }
}

