/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables;

import java.util.ArrayList;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.variables.IVariableMonitor;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;

public class Task {
    private IntVar start;
    private IntVar duration;
    private IntVar end;
    private IVariableMonitor<IntVar> update;

    public Task(IntVar s, IntVar d, IntVar e) {
        this.start = s;
        this.duration = d;
        this.end = e;
        this.update = s.hasEnumeratedDomain() || d.hasEnumeratedDomain() || e.hasEnumeratedDomain() ? new TaskMonitorEnum(s, d, e) : new TaskMonitorBound(s, d, e);
        Model model = s.getModel();
        ArrayList<Task> tset = (ArrayList<Task>)model.getHook("H_TASKSET");
        if (tset == null) {
            tset = new ArrayList<Task>();
            model.addHook("H_TASKSET", tset);
        }
        tset.add(this);
    }

    public void ensureBoundConsistency() throws ContradictionException {
        this.update.onUpdate(this.start, IntEventType.REMOVE);
    }

    public IntVar getStart() {
        return this.start;
    }

    public IntVar getDuration() {
        return this.duration;
    }

    public IntVar getEnd() {
        return this.end;
    }

    public String toString() {
        return "Task[start=" + this.start + ", duration=" + this.duration + ", end=" + this.end + ']';
    }

    private class TaskMonitorBound
    implements IVariableMonitor<IntVar> {
        private IntVar S;
        private IntVar D;
        private IntVar E;

        public TaskMonitorBound(IntVar S, IntVar D2, IntVar E) {
            this.S = S;
            this.D = D2;
            this.E = E;
            S.addMonitor(this);
            D2.addMonitor(this);
            E.addMonitor(this);
        }

        @Override
        public void onUpdate(IntVar var, IEventType evt) throws ContradictionException {
            this.S.updateBounds(this.E.getLB() - this.D.getUB(), this.E.getUB() - this.D.getLB(), this);
            this.E.updateBounds(this.S.getLB() + this.D.getLB(), this.S.getUB() + this.D.getUB(), this);
            this.D.updateBounds(this.E.getLB() - this.S.getUB(), this.E.getUB() - this.S.getLB(), this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean why(RuleStore ruleStore, IntVar var, IEventType evt, int value) {
            boolean nrules = false;
            if (var == this.S) {
                if (evt == IntEventType.INCLOW) {
                    nrules = ruleStore.addLowerBoundRule(this.E);
                    nrules |= ruleStore.addUpperBoundRule(this.D);
                    return nrules;
                } else {
                    if (evt != IntEventType.DECUPP) throw new SolverException("TaskMonitor exception");
                    nrules = ruleStore.addUpperBoundRule(this.E);
                    nrules |= ruleStore.addLowerBoundRule(this.D);
                }
                return nrules;
            } else if (var == this.E) {
                if (evt == IntEventType.INCLOW) {
                    nrules = ruleStore.addLowerBoundRule(this.S);
                    nrules |= ruleStore.addLowerBoundRule(this.D);
                    return nrules;
                } else {
                    if (evt != IntEventType.DECUPP) throw new SolverException("TaskMonitor exception");
                    nrules = ruleStore.addUpperBoundRule(this.S);
                    nrules |= ruleStore.addUpperBoundRule(this.D);
                }
                return nrules;
            } else {
                if (var != this.D) return nrules;
                if (evt == IntEventType.INCLOW) {
                    nrules = ruleStore.addLowerBoundRule(this.E);
                    nrules |= ruleStore.addUpperBoundRule(this.S);
                    return nrules;
                } else {
                    if (evt != IntEventType.DECUPP) throw new SolverException("TaskMonitor exception");
                    nrules = ruleStore.addLowerBoundRule(this.S);
                    nrules |= ruleStore.addUpperBoundRule(this.E);
                }
            }
            return nrules;
        }
    }

    private class TaskMonitorEnum
    implements IVariableMonitor<IntVar> {
        private IntVar S;
        private IntVar D;
        private IntVar E;

        public TaskMonitorEnum(IntVar S, IntVar D2, IntVar E) {
            this.S = S;
            this.D = D2;
            this.E = E;
            S.addMonitor(this);
            D2.addMonitor(this);
            E.addMonitor(this);
        }

        @Override
        public void onUpdate(IntVar var, IEventType evt) throws ContradictionException {
            for (boolean fixpoint = true; fixpoint; fixpoint |= this.D.updateUpperBound(this.E.getUB() - this.S.getLB(), this)) {
                fixpoint = this.S.updateLowerBound(this.E.getLB() - this.D.getUB(), this);
                fixpoint |= this.S.updateUpperBound(this.E.getUB() - this.D.getLB(), this);
                fixpoint |= this.E.updateLowerBound(this.S.getLB() + this.D.getLB(), this);
                fixpoint |= this.E.updateUpperBound(this.S.getUB() + this.D.getUB(), this);
                fixpoint |= this.D.updateLowerBound(this.E.getLB() - this.S.getUB(), this);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean why(RuleStore ruleStore, IntVar var, IEventType evt, int value) {
            boolean nrules = false;
            if (var == this.S) {
                if (evt == IntEventType.INCLOW) {
                    nrules = ruleStore.addLowerBoundRule(this.E);
                    nrules |= ruleStore.addUpperBoundRule(this.D);
                    return nrules;
                } else {
                    if (evt != IntEventType.DECUPP) throw new SolverException("TaskMonitor exception");
                    nrules = ruleStore.addUpperBoundRule(this.E);
                    nrules |= ruleStore.addLowerBoundRule(this.D);
                }
                return nrules;
            } else if (var == this.E) {
                if (evt == IntEventType.INCLOW) {
                    nrules = ruleStore.addLowerBoundRule(this.S);
                    nrules |= ruleStore.addLowerBoundRule(this.D);
                    return nrules;
                } else {
                    if (evt != IntEventType.DECUPP) throw new SolverException("TaskMonitor exception");
                    nrules = ruleStore.addUpperBoundRule(this.S);
                    nrules |= ruleStore.addUpperBoundRule(this.D);
                }
                return nrules;
            } else {
                if (var != this.D) return nrules;
                if (evt == IntEventType.INCLOW) {
                    nrules = ruleStore.addLowerBoundRule(this.E);
                    nrules |= ruleStore.addUpperBoundRule(this.S);
                    return nrules;
                } else {
                    if (evt != IntEventType.DECUPP) throw new SolverException("TaskMonitor exception");
                    nrules = ruleStore.addLowerBoundRule(this.S);
                    nrules |= ruleStore.addUpperBoundRule(this.E);
                }
            }
            return nrules;
        }
    }
}

