/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.expression.discrete.arithmetic.ArExpression;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSet;

public interface IntVar
extends ICause,
Variable,
Iterable<Integer>,
ArExpression {
    public static final int MIN_INT_BOUND = -21474836;
    public static final int MAX_INT_BOUND = 21474836;

    public boolean removeValue(int var1, ICause var2) throws ContradictionException;

    public boolean removeValues(IntIterableSet var1, ICause var2) throws ContradictionException;

    public boolean removeAllValuesBut(IntIterableSet var1, ICause var2) throws ContradictionException;

    public boolean removeInterval(int var1, int var2, ICause var3) throws ContradictionException;

    public boolean instantiateTo(int var1, ICause var2) throws ContradictionException;

    public boolean updateLowerBound(int var1, ICause var2) throws ContradictionException;

    public boolean updateUpperBound(int var1, ICause var2) throws ContradictionException;

    public boolean updateBounds(int var1, int var2, ICause var3) throws ContradictionException;

    public boolean contains(int var1);

    public boolean isInstantiatedTo(int var1);

    public int getValue();

    public int getLB();

    public int getUB();

    public int getDomainSize();

    public int getRange();

    public int nextValue(int var1);

    public int nextValueOut(int var1);

    public int previousValue(int var1);

    public int previousValueOut(int var1);

    public DisposableValueIterator getValueIterator(boolean var1);

    public DisposableRangeIterator getRangeIterator(boolean var1);

    public boolean hasEnumeratedDomain();

    public IIntDeltaMonitor monitorDelta(ICause var1);

    public boolean isBool();

    @Override
    default public boolean why(RuleStore ruleStore, IntVar modifiedVar, IEventType evt, int value) {
        IntEventType ievt;
        boolean observed;
        boolean newrules = false;
        boolean bl = observed = modifiedVar == this;
        if (observed) {
            value = this.transformValue(value);
            ievt = (IntEventType)this.transformEvent(evt);
        } else {
            value = modifiedVar.reverseValue(value);
            ievt = (IntEventType)modifiedVar.transformEvent(evt);
        }
        switch (ievt) {
            case REMOVE: {
                newrules = ruleStore.addRemovalRule(this, value);
                break;
            }
            case DECUPP: {
                newrules = ruleStore.addUpperBoundRule(this);
                break;
            }
            case INCLOW: {
                newrules = ruleStore.addLowerBoundRule(this);
                break;
            }
            case INSTANTIATE: {
                newrules = ruleStore.addFullDomainRule(this);
            }
        }
        return newrules;
    }

    default public IEventType transformEvent(IEventType evt) {
        return evt;
    }

    default public int transformValue(int value) {
        return value;
    }

    default public int reverseValue(int value) {
        return value;
    }

    @Override
    default public IntVar intVar() {
        return this;
    }

    @Override
    default public boolean isExpressionLeaf() {
        return true;
    }
}

