/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables;

import org.chocosolver.solver.ISelf;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.real.IntEqRealConstraint;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.view.BoolNotView;
import org.chocosolver.solver.variables.view.MinusView;
import org.chocosolver.solver.variables.view.OffsetView;
import org.chocosolver.solver.variables.view.RealView;
import org.chocosolver.solver.variables.view.ScaleView;

public interface IViewFactory
extends ISelf<Model> {
    default public BoolVar boolNotView(BoolVar bool) {
        BoolVar not;
        if (bool.hasNot()) {
            return bool.not();
        }
        if (bool.isInstantiated()) {
            not = bool.getValue() == 1 ? ((Model)this._me()).boolVar(false) : ((Model)this._me()).boolVar(true);
        } else {
            if (((Model)this._me()).getSettings().enableViews()) {
                not = new BoolNotView(bool);
            } else {
                not = ((Model)this._me()).boolVar("not(" + bool.getName() + ")");
                ((Model)this._me()).arithm((IntVar)not, "!=", bool).post();
            }
            not.setNot(true);
        }
        bool._setNot(not);
        not._setNot(bool);
        return not;
    }

    default public IntVar intOffsetView(IntVar var, int cste) {
        if (cste == 0) {
            return var;
        }
        String name = "(" + var.getName() + (cste >= 0 ? "+" : "-") + Math.abs(cste) + ")";
        if (var.isInstantiated()) {
            return ((Model)this._me()).intVar(name, var.getValue() + cste);
        }
        if (((Model)this._me()).getSettings().enableViews()) {
            return new OffsetView(var, cste);
        }
        int lb = var.getLB() + cste;
        int ub = var.getUB() + cste;
        IntVar ov = var.hasEnumeratedDomain() ? ((Model)this._me()).intVar(name, lb, ub, false) : ((Model)this._me()).intVar(name, lb, ub, true);
        ((Model)this._me()).arithm(ov, "-", var, "=", cste).post();
        return ov;
    }

    default public IntVar intMinusView(IntVar var) {
        if (var.isInstantiated()) {
            return ((Model)this._me()).intVar(-var.getValue());
        }
        if (((Model)this._me()).getSettings().enableViews()) {
            if (var instanceof MinusView) {
                return ((MinusView)var).getVariable();
            }
            return new MinusView(var);
        }
        int ub = -var.getLB();
        int lb = -var.getUB();
        String name = "-(" + var.getName() + ")";
        IntVar ov = var.hasEnumeratedDomain() ? ((Model)this._me()).intVar(name, lb, ub, false) : ((Model)this._me()).intVar(name, lb, ub, true);
        ((Model)this._me()).arithm(ov, "+", var, "=", 0).post();
        return ov;
    }

    default public IntVar intScaleView(IntVar var, int cste) {
        IntVar v2;
        if (cste == -1) {
            return this.intMinusView(var);
        }
        if (cste < 0) {
            throw new UnsupportedOperationException("scale requires a coefficient >= -1 (found " + cste + ")");
        }
        if (cste == 0) {
            v2 = ((Model)this._me()).intVar(0);
        } else if (cste == 1) {
            v2 = var;
        } else {
            if (var.isInstantiated()) {
                return ((Model)this._me()).intVar(var.getValue() * cste);
            }
            if (((Model)this._me()).getSettings().enableViews()) {
                v2 = new ScaleView(var, cste);
            } else {
                int lb = var.getLB() * cste;
                int ub = var.getUB() * cste;
                String name = "(" + var.getName() + "*" + cste + ")";
                IntVar ov = var.hasEnumeratedDomain() ? ((Model)this._me()).intVar(name, lb, ub, false) : ((Model)this._me()).intVar(name, lb, ub, true);
                ((Model)this._me()).times(var, cste, ov).post();
                return ov;
            }
        }
        return v2;
    }

    default public IntVar intAbsView(IntVar var) {
        if (var.isInstantiated()) {
            return ((Model)this._me()).intVar(Math.abs(var.getValue()));
        }
        if (var.getLB() >= 0) {
            return var;
        }
        if (var.getUB() <= 0) {
            return this.intMinusView(var);
        }
        int ub = Math.max(-var.getLB(), var.getUB());
        String name = "|" + var.getName() + "|";
        IntVar abs = var.hasEnumeratedDomain() ? ((Model)this._me()).intVar(name, 0, ub, false) : ((Model)this._me()).intVar(name, 0, ub, true);
        ((Model)this._me()).absolute(abs, var).post();
        return abs;
    }

    default public RealVar realIntView(IntVar var, double precision) {
        if (((Model)this._me()).getSettings().enableViews()) {
            return new RealView(var, precision);
        }
        double lb = var.getLB();
        double ub = var.getUB();
        RealVar rv = ((Model)this._me()).realVar("(real)" + var.getName(), lb, ub, precision);
        new IntEqRealConstraint(var, rv, precision).post();
        return rv;
    }

    default public RealVar[] realIntViewArray(IntVar[] ints, double precision) {
        RealVar[] reals = new RealVar[ints.length];
        if (((Model)this._me()).getSettings().enableViews()) {
            for (int i = 0; i < ints.length; ++i) {
                reals[i] = this.realIntView(ints[i], precision);
            }
        } else {
            for (int i = 0; i < ints.length; ++i) {
                double lb = ints[i].getLB();
                double ub = ints[i].getUB();
                reals[i] = ((Model)this._me()).realVar("(real)" + ints[i].getName(), lb, ub, precision);
            }
            new IntEqRealConstraint(ints, reals, precision).post();
        }
        return reals;
    }

    default public RealVar[][] realIntViewMatrix(IntVar[][] ints, double precision) {
        RealVar[][] vars = new RealVar[ints.length][ints[0].length];
        for (int i = 0; i < ints.length; ++i) {
            vars[i] = this.realIntViewArray(ints[i], precision);
        }
        return vars;
    }
}

