/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables;

import org.chocosolver.solver.ISelf;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Task;
import org.chocosolver.solver.variables.impl.BitsetArrayIntVarImpl;
import org.chocosolver.solver.variables.impl.BitsetIntVarImpl;
import org.chocosolver.solver.variables.impl.BoolVarImpl;
import org.chocosolver.solver.variables.impl.FixedBoolVarImpl;
import org.chocosolver.solver.variables.impl.FixedIntVarImpl;
import org.chocosolver.solver.variables.impl.FixedRealVarImpl;
import org.chocosolver.solver.variables.impl.IntervalIntVarImpl;
import org.chocosolver.solver.variables.impl.RealVarImpl;
import org.chocosolver.solver.variables.impl.SetVarImpl;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.tools.ArrayUtils;
import org.chocosolver.util.tools.VariableUtils;

public interface IVariableFactory
extends ISelf<Model> {
    public static final String CSTE_NAME = "cste -- ";

    default public BoolVar boolVar(boolean value) {
        return this.boolVar(CSTE_NAME + (value ? 1 : 0), value);
    }

    default public BoolVar boolVar(String name, boolean value) {
        int intVal;
        int n = intVal = value ? 1 : 0;
        if (name.equals(CSTE_NAME + intVal) && ((Model)this._me()).getCachedConstants().containsKey(intVal)) {
            return (BoolVar)((Model)this._me()).getCachedConstants().get(intVal);
        }
        FixedBoolVarImpl cste = new FixedBoolVarImpl(name, intVal, (Model)this._me());
        if (name.equals(CSTE_NAME + intVal)) {
            ((Model)this._me()).getCachedConstants().put(intVal, cste);
        }
        return cste;
    }

    default public BoolVar boolVar() {
        return this.boolVar(this.generateName("BV_"));
    }

    default public BoolVar boolVar(String name) {
        return new BoolVarImpl(name, (Model)this._me());
    }

    default public BoolVar[] boolVarArray(int size) {
        return this.boolVarArray(this.generateName("BV_"), size);
    }

    default public BoolVar[] boolVarArray(String name, int size) {
        BoolVar[] vars = new BoolVar[size];
        for (int i = 0; i < size; ++i) {
            vars[i] = this.boolVar(name + "[" + i + "]");
        }
        return vars;
    }

    default public BoolVar[][] boolVarMatrix(int dim1, int dim2) {
        return this.boolVarMatrix(this.generateName("BV_"), dim1, dim2);
    }

    default public BoolVar[][] boolVarMatrix(String name, int dim1, int dim2) {
        BoolVar[][] vars = new BoolVar[dim1][];
        for (int i = 0; i < dim1; ++i) {
            vars[i] = this.boolVarArray(name + "[" + i + "]", dim2);
        }
        return vars;
    }

    default public IntVar intVar(int value) {
        return this.intVar(CSTE_NAME + value, value);
    }

    default public IntVar intVar(int[] values) {
        return this.intVar(this.generateName("IV_"), values);
    }

    default public IntVar intVar(int lb, int ub) {
        return this.intVar(this.generateName("IV_"), lb, ub);
    }

    default public IntVar intVar(int lb, int ub, boolean boundedDomain) {
        return this.intVar(this.generateName("IV_"), lb, ub, boundedDomain);
    }

    default public IntVar intVar(String name, int value) {
        this.checkIntDomainRange(name, value, value);
        if (value == 0 || value == 1) {
            return this.boolVar(name, value == 1);
        }
        if (name.equals(CSTE_NAME + value) && ((Model)this._me()).getCachedConstants().containsKey(value)) {
            return ((Model)this._me()).getCachedConstants().get(value);
        }
        FixedIntVarImpl cste = new FixedIntVarImpl(name, value, (Model)this._me());
        if (name.equals(CSTE_NAME + value)) {
            ((Model)this._me()).getCachedConstants().put(value, cste);
        }
        return cste;
    }

    default public IntVar intVar(String name, int lb, int ub, boolean boundedDomain) {
        this.checkIntDomainRange(name, lb, ub);
        if (lb == ub) {
            return this.intVar(name, lb);
        }
        if (lb == 0 && ub == 1) {
            return this.boolVar(name);
        }
        if (boundedDomain) {
            return new IntervalIntVarImpl(name, lb, ub, (Model)this._me());
        }
        return new BitsetIntVarImpl(name, lb, ub, (Model)this._me());
    }

    default public IntVar intVar(String name, int lb, int ub) {
        boolean bounded = ub - lb + 1 >= ((Model)this._me()).getSettings().getMaxDomSizeForEnumerated();
        return this.intVar(name, lb, ub, bounded);
    }

    default public IntVar intVar(String name, int[] values) {
        values = ArrayUtils.mergeAndSortIfNot((int[])values.clone());
        this.checkIntDomainRange(name, values[0], values[values.length - 1]);
        if (values.length == 1) {
            return this.intVar(name, values[0]);
        }
        if (values.length == 2 && values[0] == 0 && values[1] == 1) {
            return this.boolVar(name);
        }
        int gap = values[values.length - 1] - values[0];
        if (gap > 30 && gap / values.length > 5) {
            return new BitsetArrayIntVarImpl(name, values, (Model)this._me());
        }
        return new BitsetIntVarImpl(name, values, (Model)this._me());
    }

    default public IntVar[] intVarArray(int size, int[] values) {
        return this.intVarArray(this.generateName("IV_"), size, values);
    }

    default public IntVar[] intVarArray(int size, int lb, int ub) {
        return this.intVarArray(this.generateName("IV_"), size, lb, ub);
    }

    default public IntVar[] intVarArray(int size, int lb, int ub, boolean boundedDomain) {
        return this.intVarArray(this.generateName("IV_"), size, lb, ub, boundedDomain);
    }

    default public IntVar[] intVarArray(String name, int size, int lb, int ub, boolean boundedDomain) {
        IntVar[] vars = new IntVar[size];
        for (int i = 0; i < size; ++i) {
            vars[i] = this.intVar(name + "[" + i + "]", lb, ub, boundedDomain);
        }
        return vars;
    }

    default public IntVar[] intVarArray(String name, int size, int lb, int ub) {
        IntVar[] vars = new IntVar[size];
        for (int i = 0; i < size; ++i) {
            vars[i] = this.intVar(name + "[" + i + "]", lb, ub);
        }
        return vars;
    }

    default public IntVar[] intVarArray(String name, int size, int[] values) {
        IntVar[] vars = new IntVar[size];
        for (int i = 0; i < size; ++i) {
            vars[i] = this.intVar(name + "[" + i + "]", values);
        }
        return vars;
    }

    default public IntVar[][] intVarMatrix(int dim1, int dim2, int[] values) {
        return this.intVarMatrix(this.generateName("IV_"), dim1, dim2, values);
    }

    default public IntVar[][] intVarMatrix(int dim1, int dim2, int lb, int ub) {
        return this.intVarMatrix(this.generateName("IV_"), dim1, dim2, lb, ub);
    }

    default public IntVar[][] intVarMatrix(int dim1, int dim2, int lb, int ub, boolean boundedDomain) {
        return this.intVarMatrix(this.generateName("IV_"), dim1, dim2, lb, ub, boundedDomain);
    }

    default public IntVar[][] intVarMatrix(String name, int dim1, int dim2, int lb, int ub, boolean boundedDomain) {
        IntVar[][] vars = new IntVar[dim1][dim2];
        for (int i = 0; i < dim1; ++i) {
            vars[i] = this.intVarArray(name + "[" + i + "]", dim2, lb, ub, boundedDomain);
        }
        return vars;
    }

    default public IntVar[][] intVarMatrix(String name, int dim1, int dim2, int lb, int ub) {
        IntVar[][] vars = new IntVar[dim1][dim2];
        for (int i = 0; i < dim1; ++i) {
            vars[i] = this.intVarArray(name + "[" + i + "]", dim2, lb, ub);
        }
        return vars;
    }

    default public IntVar[][] intVarMatrix(String name, int dim1, int dim2, int[] values) {
        IntVar[][] vars = new IntVar[dim1][dim2];
        for (int i = 0; i < dim1; ++i) {
            vars[i] = this.intVarArray(name + "[" + i + "]", dim2, values);
        }
        return vars;
    }

    default public Task taskVar(IntVar s, int p) {
        return new Task(s, ((Model)this._me()).intVar(p), ((Model)this._me()).intOffsetView(s, p));
    }

    default public Task taskVar(IntVar s, IntVar p) {
        int[] bounds = VariableUtils.boundsForAddition(s, p);
        IntVar end = ((Model)this._me()).intVar(bounds[0], bounds[1]);
        return new Task(s, p, end);
    }

    default public Task taskVar(IntVar s, IntVar p, IntVar e) {
        return new Task(s, p, e);
    }

    default public Task[] taskVarArray(IntVar[] s, IntVar[] p, IntVar[] e) {
        if (s.length != p.length || s.length != e.length) {
            throw new SolverException("Wrong arrays size");
        }
        Task[] tasks = new Task[s.length];
        for (int i = 0; i < s.length; ++i) {
            tasks[i] = this.taskVar(s[i], p[i], e[i]);
        }
        return tasks;
    }

    default public Task[][] taskVarMatrix(IntVar[][] s, IntVar[][] p, IntVar[][] e) {
        if (s.length != p.length || s.length != e.length) {
            throw new SolverException("Wrong arrays size");
        }
        Task[][] tasks = new Task[s.length][];
        for (int i = 0; i < s.length; ++i) {
            tasks[i] = this.taskVarArray(s[i], p[i], e[i]);
        }
        return tasks;
    }

    default public RealVar realVar(double value) {
        return this.realVar(CSTE_NAME + value, value);
    }

    default public RealVar realVar(String name, double value) {
        return new FixedRealVarImpl(name, value, (Model)this._me());
    }

    default public RealVar realVar(double value, double precision) {
        return this.realVar(CSTE_NAME + value, value, value, precision);
    }

    default public RealVar realVar(double lb, double ub, double precision) {
        return this.realVar(this.generateName("RV_"), lb, ub, precision);
    }

    default public RealVar realVar(String name, double lb, double ub, double precision) {
        this.checkRealDomainRange(name, lb, ub);
        return new RealVarImpl(name, lb, ub, precision, (Model)this._me());
    }

    default public RealVar[] realVarArray(int size, double lb, double ub, double precision) {
        return this.realVarArray(this.generateName("RV_"), size, lb, ub, precision);
    }

    default public RealVar[] realVarArray(String name, int size, double lb, double ub, double precision) {
        RealVar[] vars = new RealVar[size];
        for (int i = 0; i < size; ++i) {
            vars[i] = this.realVar(name + "[" + i + "]", lb, ub, precision);
        }
        return vars;
    }

    default public RealVar[][] realVarMatrix(int dim1, int dim2, double lb, double ub, double precision) {
        return this.realVarMatrix(this.generateName("RV_"), dim1, dim2, lb, ub, precision);
    }

    default public RealVar[][] realVarMatrix(String name, int dim1, int dim2, double lb, double ub, double precision) {
        RealVar[][] vars = new RealVar[dim1][];
        for (int i = 0; i < dim1; ++i) {
            vars[i] = this.realVarArray(name + "[" + i + "]", dim2, lb, ub, precision);
        }
        return vars;
    }

    default public SetVar setVar(int[] lb, int[] ub) {
        return this.setVar(this.generateName("RV_"), lb, ub);
    }

    default public SetVar setVar(int ... value) {
        String name = "cste -- {";
        for (int i = 0; i < value.length; ++i) {
            name = name + value[i] + (i < value.length - 1 ? ", " : "");
        }
        name = name + "}";
        return this.setVar(name, value);
    }

    default public SetVar setVar(String name, int[] lb, int[] ub) {
        return new SetVarImpl(name, lb, SetType.BITSET, ub, SetType.BITSET, (Model)this._me());
    }

    default public SetVar setVar(String name, int ... value) {
        if (value == null) {
            value = new int[]{};
        }
        return new SetVarImpl(name, value, (Model)this._me());
    }

    default public SetVar[] setVarArray(int size, int[] lb, int[] ub) {
        return this.setVarArray(this.generateName("SV_"), size, lb, ub);
    }

    default public SetVar[] setVarArray(String name, int size, int[] lb, int[] ub) {
        SetVar[] vars = new SetVar[size];
        for (int i = 0; i < size; ++i) {
            vars[i] = this.setVar(name + "[" + i + "]", lb, ub);
        }
        return vars;
    }

    default public SetVar[][] setVarMatrix(int dim1, int dim2, int[] lb, int[] ub) {
        return this.setVarMatrix(this.generateName("SV_"), dim1, dim2, lb, ub);
    }

    default public SetVar[][] setVarMatrix(String name, int dim1, int dim2, int[] lb, int[] ub) {
        SetVar[][] vars = new SetVar[dim1][dim2];
        for (int i = 0; i < dim1; ++i) {
            vars[i] = this.setVarArray(name + "[" + i + "]", dim2, lb, ub);
        }
        return vars;
    }

    default public void checkIntDomainRange(String NAME, int MIN, int MAX) {
        if (MIN - Integer.MIN_VALUE == 0 || MAX - Integer.MAX_VALUE == 0) {
            throw new SolverException(NAME + ": consider reducing the bounds to avoid unexpected results");
        }
        if (MAX < MIN) {
            throw new SolverException(NAME + ": wrong domain definition, lower bound > upper bound");
        }
    }

    default public void checkRealDomainRange(String NAME, double MIN, double MAX) {
        if (MIN - Double.MIN_VALUE == 0.0 || MAX - Double.MAX_VALUE == 0.0) {
            throw new SolverException(NAME + ": consider reducing the bounds to avoid unexpected results");
        }
        if (MAX < MIN) {
            throw new SolverException(NAME + ": wrong domain definition, lower bound > upper bound");
        }
    }

    default public BoolVar[] toBoolVar(IntVar ... ivars) {
        BoolVar[] bvars = new BoolVar[ivars.length];
        for (int i = ivars.length - 1; i >= 0; --i) {
            bvars[i] = (BoolVar)ivars[i];
        }
        return bvars;
    }

    default public String generateName() {
        return "TMP_" + ((Model)this._me()).nextNameId();
    }

    default public String generateName(String prefix) {
        return prefix + ((Model)this._me()).nextNameId();
    }
}

