/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.trace;

import java.io.PrintStream;
import org.chocosolver.solver.ISelf;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.search.loop.monitors.IMonitorClose;
import org.chocosolver.solver.search.loop.monitors.IMonitorDownBranch;
import org.chocosolver.solver.search.loop.monitors.IMonitorInitialize;
import org.chocosolver.solver.trace.IMessage;
import org.chocosolver.solver.trace.LogStatEveryXXms;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.tools.StringUtils;

public interface IOutputFactory
extends ISelf<Solver> {
    public void setOut(PrintStream var1);

    public PrintStream getOut();

    public void setErr(PrintStream var1);

    public PrintStream getErr();

    default public void printVersion() {
        this.getOut().println(((Solver)this._me()).getModel().getSettings().getWelcomeMessage());
    }

    default public void printFeatures() {
        ((Solver)this._me()).getOut().printf("- Model[%s] features:\n", ((Solver)this._me()).getModel().getName());
        ((Solver)this._me()).getOut().printf("\tVariables : %d\n", ((Solver)this._me()).getModel().getNbVars());
        ((Solver)this._me()).getOut().printf("\tConstraints : %d\n", ((Solver)this._me()).getModel().getNbCstrs());
        ((Solver)this._me()).getOut().printf("\tBuilding time : %.3fs\n", Float.valueOf((float)(System.nanoTime() - ((Solver)this._me()).getModel().getCreationTime()) / 1.0E9f));
        ((Solver)this._me()).getOut().printf("\tUser-defined search strategy : %s\n", ((Solver)this._me()).getModel().getSolver().isDefaultSearchUsed() ? "yes" : "no");
        ((Solver)this._me()).getOut().printf("\tComplementary search strategy : %s\n", ((Solver)this._me()).isSearchCompleted() ? "yes" : "no");
    }

    default public void printShortFeatures() {
        StringBuilder st = new StringBuilder(256);
        st.append("Model[").append(((Solver)this._me()).getModelName()).append("], ");
        st.append(String.format("%d variables, %d constraints, building time: %.3fs, %s user-defined search strategy, %s complementary search strategy", ((Solver)this._me()).getModel().getNbVars(), ((Solver)this._me()).getModel().getNbCstrs(), Float.valueOf((float)(System.nanoTime() - ((Solver)this._me()).getModel().getCreationTime()) / 1.0E9f), ((Solver)this._me()).getModel().getSolver().isDefaultSearchUsed() ? "w/" : "w/o", ((Solver)this._me()).isSearchCompleted() ? "w/" : "w/o"));
        this.getOut().println(st.toString());
    }

    default public void printStatistics() {
        this.printVersion();
        this.printFeatures();
        this.getOut().println(((Solver)this._me()).getMeasures().toString());
    }

    default public void printShortStatistics() {
        this.getOut().println(((Solver)this._me()).getMeasures().toOneLineString());
    }

    default public void printCSVStatistics() {
        this.getOut().println(((Solver)this._me()).getMeasures().toCSV());
    }

    default public void showStatistics() {
        ((Solver)this._me()).plugMonitor(new IMonitorInitialize(){

            @Override
            public void beforeInitialize() {
                IOutputFactory.this.printVersion();
                IOutputFactory.this.printFeatures();
            }
        });
        ((Solver)this._me()).plugMonitor(new IMonitorClose(){

            @Override
            public void afterClose() {
                IOutputFactory.this.getOut().println(((Solver)IOutputFactory.this._me()).getMeasures().toString());
            }
        });
    }

    default public void showShortStatistics() {
        ((Solver)this._me()).plugMonitor(new IMonitorClose(){

            @Override
            public void beforeClose() {
                IOutputFactory.this.getOut().println(((Solver)IOutputFactory.this._me()).getMeasures().toOneLineString());
            }
        });
    }

    default public void showSolutions(IMessage message) {
        ((Solver)this._me()).plugMonitor(() -> this.getOut().println(message.print()));
    }

    default public void showSolutions() {
        this.showSolutions(new DefaultSolutionMessage((Solver)this._me()));
    }

    default public void showDecisions(final IMessage message) {
        ((Solver)this._me()).plugMonitor(new IMonitorDownBranch(){

            @Override
            public void beforeDownBranch(boolean left) {
                IOutputFactory.this.getOut().printf("%s %s ", StringUtils.pad("", ((Solver)IOutputFactory.this._me()).getEnvironment().getWorldIndex(), "."), ((Solver)IOutputFactory.this._me()).getDecisionPath().lastDecisionToString());
                IOutputFactory.this.getOut().printf(" // %s \n", message.print());
            }
        });
    }

    default public void showDecisions() {
        this.showDecisions(new DefaultDecisionMessage((Solver)this._me()));
    }

    default public void showContradiction() {
        ((Solver)this._me()).plugMonitor(cex -> this.getOut().println(String.format("\t/!\\ %s", cex.toString())));
    }

    default public void showStatisticsDuringResolution(long f) {
        if (f > 0L) {
            ((Solver)this._me()).plugMonitor(new LogStatEveryXXms((Solver)this._me(), f));
        }
    }

    public static class DefaultDecisionMessage
    implements IMessage {
        private Solver solver;

        public DefaultDecisionMessage(Solver solver) {
            this.solver = solver;
        }

        @Override
        public String print() {
            int limit = 120;
            Variable[] vars = this.solver.getSearch().getVariables();
            StringBuilder s = new StringBuilder(32);
            for (int i = 0; i < vars.length && s.length() < limit; ++i) {
                s.append(vars[i]).append(' ');
            }
            if (s.length() >= limit) {
                s.append("...");
            }
            return s.toString();
        }
    }

    public static class DefaultSolutionMessage
    implements IMessage {
        private Solver solver;

        public DefaultSolutionMessage(Solver solver) {
            this.solver = solver;
        }

        @Override
        public String print() {
            return String.format("- Solution #%s found. %s \n\t%s.", this.solver.getSolutionCount(), this.solver.getMeasures().toOneLineString(), this.print(this.solver.getSearch().getVariables()));
        }

        private String print(Variable[] vars) {
            StringBuilder s = new StringBuilder(32);
            for (Variable v : vars) {
                s.append(v).append(' ');
            }
            return s.toString();
        }
    }
}

