/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.strategy;

import org.chocosolver.solver.search.strategy.assignments.DecisionOperator;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperatorFactory;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.selectors.values.SetValueSelector;
import org.chocosolver.solver.search.strategy.selectors.variables.VariableSelector;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;

public class SetStrategy
extends AbstractStrategy<SetVar> {
    protected VariableSelector<SetVar> varSelector;
    protected SetValueSelector valSelector;
    protected DecisionOperator<SetVar> operator;

    public SetStrategy(SetVar[] scope, VariableSelector<SetVar> varS, SetValueSelector valS, boolean enforceFirst) {
        super((Variable[])scope);
        this.varSelector = varS;
        this.valSelector = valS;
        this.operator = enforceFirst ? DecisionOperatorFactory.makeSetForce() : DecisionOperatorFactory.makeSetRemove();
    }

    @Override
    public boolean init() {
        return true;
    }

    @Override
    public Decision<SetVar> getDecision() {
        SetVar variable = (SetVar)this.varSelector.getVariable(this.vars);
        return this.computeDecision(variable);
    }

    @Override
    public Decision<SetVar> computeDecision(SetVar s) {
        if (s == null) {
            return null;
        }
        assert (!s.isInstantiated());
        return s.getModel().getSolver().getDecisionPath().makeSetDecision(s, this.operator, this.valSelector.selectValue(s));
    }
}

