/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.strategy;

import org.chocosolver.solver.search.strategy.assignments.DecisionOperator;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperatorFactory;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.selectors.values.IntValueSelector;
import org.chocosolver.solver.search.strategy.selectors.variables.VariableSelector;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;

public class IntStrategy
extends AbstractStrategy<IntVar> {
    private VariableSelector<IntVar> variableSelector;
    protected IntValueSelector valueSelector;
    private DecisionOperator<IntVar> decisionOperator;

    public IntStrategy(IntVar[] scope, VariableSelector<IntVar> varSelector, IntValueSelector valSelector) {
        this(scope, varSelector, valSelector, DecisionOperatorFactory.makeIntEq());
    }

    public IntStrategy(IntVar[] scope, VariableSelector<IntVar> varSelector, IntValueSelector valSelector, DecisionOperator<IntVar> decOperator) {
        super((Variable[])scope);
        this.variableSelector = varSelector;
        this.valueSelector = valSelector;
        this.decisionOperator = decOperator;
    }

    @Override
    public boolean init() {
        return true;
    }

    @Override
    public Decision<IntVar> computeDecision(IntVar variable) {
        if (variable == null || variable.isInstantiated()) {
            return null;
        }
        int value = this.valueSelector.selectValue(variable);
        return variable.getModel().getSolver().getDecisionPath().makeIntDecision(variable, this.decisionOperator, value);
    }

    @Override
    public Decision getDecision() {
        IntVar variable = (IntVar)this.variableSelector.getVariable(this.vars);
        return this.computeDecision(variable);
    }

    public VariableSelector<IntVar> getVarSelector() {
        return this.variableSelector;
    }

    public IntValueSelector getValSelector() {
        return this.valueSelector;
    }

    public DecisionOperator<IntVar> getDecisionOperator() {
        return this.decisionOperator;
    }
}

