/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.strategy;

import org.chocosolver.solver.search.strategy.assignments.DecisionOperatorFactory;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.IntDecision;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;

public abstract class AbstractStrategy<V extends Variable> {
    protected final V[] vars;

    protected AbstractStrategy(V ... variables) {
        this.vars = (Variable[])variables.clone();
    }

    public boolean init() {
        return true;
    }

    public abstract Decision<V> getDecision();

    public String toString() {
        StringBuilder s = new StringBuilder(32);
        for (V v : this.vars) {
            s.append(v).append(' ');
        }
        return s.toString();
    }

    protected Decision<V> computeDecision(V var) {
        return null;
    }

    public V[] getVariables() {
        return this.vars;
    }

    protected final IntDecision makeIntDecision(IntVar var, int val) {
        return var.getModel().getSolver().getDecisionPath().makeIntDecision(var, DecisionOperatorFactory.makeIntEq(), val);
    }
}

