/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.selectors.variables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;
import org.chocosolver.solver.search.strategy.selectors.variables.VariableEvaluator;
import org.chocosolver.solver.search.strategy.selectors.variables.VariableSelector;
import org.chocosolver.solver.variables.Variable;

public class VariableSelectorWithTies<V extends Variable>
implements VariableSelector<V> {
    private final VariableEvaluator<V>[] heuristics;
    private ArrayList<V> oldv = new ArrayList();
    private ArrayList<V> newv = new ArrayList();

    @SafeVarargs
    public VariableSelectorWithTies(VariableEvaluator<V> ... heuristics) {
        this.heuristics = heuristics;
    }

    @Override
    public V getVariable(V[] variables) {
        this.oldv.clear();
        this.newv.clear();
        Collections.addAll(this.oldv, variables);
        this.newv.addAll(this.oldv.stream().filter(v -> !v.isInstantiated()).collect(Collectors.toList()));
        if (this.newv.size() == 0) {
            return null;
        }
        for (VariableEvaluator<Variable> variableEvaluator : this.heuristics) {
            double minValue = Double.MAX_VALUE;
            this.oldv.clear();
            this.oldv.addAll(this.newv);
            this.newv.clear();
            for (Variable v2 : this.oldv) {
                double val = variableEvaluator.evaluate(v2);
                if (val < minValue) {
                    this.newv.clear();
                    this.newv.add(v2);
                    minValue = val;
                    continue;
                }
                if (val != minValue) continue;
                this.newv.add(v2);
            }
        }
        switch (this.oldv.size()) {
            case 0: {
                return null;
            }
        }
        return (V)((Variable)this.oldv.get(0));
    }
}

