/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.selectors.variables;

import java.util.Random;
import org.chocosolver.memory.IStateDouble;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.monitors.IMonitorContradiction;
import org.chocosolver.solver.search.loop.monitors.IMonitorDownBranch;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperatorFactory;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.objects.IntList;

public class ImpactBased
extends AbstractStrategy<IntVar>
implements IMonitorDownBranch,
IMonitorContradiction,
ICause {
    private final int aging;
    private double[][] Ilabel;
    private int[] offsets;
    private int split;
    private IStateDouble searchSpaceSize;
    private int currentVar = -1;
    private int currentVal = -1;
    private IntList bests = new IntList();
    private Random random;
    private int nodeImpact;
    private Model model;
    private boolean asgntFailed;
    private boolean learnsAndFails;
    private long timeLimit = Integer.MAX_VALUE;

    public ImpactBased(IntVar[] ivariables, int alpha, int split, int nodeImpact, long seed, boolean initOnly) {
        super((Variable[])ivariables);
        this.model = ivariables[0].getModel();
        this.aging = alpha;
        this.split = (int)Math.pow(2.0, split);
        this.searchSpaceSize = this.model.getEnvironment().makeFloat();
        this.random = new Random(seed);
        this.nodeImpact = nodeImpact;
        if (!initOnly) {
            this.model.getSolver().plugMonitor(this);
        }
    }

    public ImpactBased(IntVar[] vars, boolean initOnly) {
        this(vars, 2, 3, 10, 0L, initOnly);
    }

    @Override
    public Decision<IntVar> computeDecision(IntVar variable) {
        if (variable == null || variable.isInstantiated()) {
            return null;
        }
        if (this.currentVar == -1 || ((IntVar[])this.vars)[this.currentVar] != variable) {
            for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
                if (((IntVar[])this.vars)[i] != variable) continue;
                this.currentVar = i;
            }
            assert (((IntVar[])this.vars)[this.currentVar] == variable);
        }
        this.bests.clear();
        double bestImpact = 1.0;
        if (variable.hasEnumeratedDomain()) {
            DisposableValueIterator it = variable.getValueIterator(true);
            int o = this.offsets[this.currentVar];
            while (it.hasNext()) {
                int val = it.next();
                double impact = this.Ilabel[this.currentVar][val - o];
                if (impact < bestImpact) {
                    this.bests.clear();
                    this.bests.add(val);
                    bestImpact = impact;
                    continue;
                }
                if (impact != bestImpact) continue;
                this.bests.add(val);
            }
            it.dispose();
            this.currentVal = this.bests.get(this.random.nextInt(this.bests.size()));
        } else {
            int lb = variable.getLB();
            int ub = variable.getUB();
            this.currentVal = this.random.nextBoolean() ? lb : ub;
        }
        return this.model.getSolver().getDecisionPath().makeIntDecision(variable, DecisionOperatorFactory.makeIntEq(), this.currentVal);
    }

    @Override
    public Decision<IntVar> getDecision() {
        IntVar best = null;
        this.bests.clear();
        double bestImpact = -1.7976931348623157E308;
        for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
            if (((IntVar[])this.vars)[i].isInstantiated()) continue;
            double imp = this.computeImpact(i);
            if (imp > bestImpact) {
                this.bests.clear();
                this.bests.add(i);
                bestImpact = imp;
                continue;
            }
            if (imp != bestImpact) continue;
            this.bests.add(i);
        }
        if (this.bests.size() > 0) {
            this.currentVar = this.bests.get(this.random.nextInt(this.bests.size()));
            best = ((IntVar[])this.vars)[this.currentVar];
        }
        return this.computeDecision(best);
    }

    public void setTimeLimit(long timeLimit) {
        if (timeLimit > -1L) {
            this.timeLimit = timeLimit;
        }
    }

    @Override
    public boolean init() {
        int dsz;
        int UB;
        int offset;
        IntVar v;
        int i;
        long tl = System.currentTimeMillis() + this.timeLimit;
        this.Ilabel = new double[((IntVar[])this.vars).length][];
        this.offsets = new int[((IntVar[])this.vars).length];
        double before = this.searchSpaceSize();
        this.searchSpaceSize.set(before);
        this.learnsAndFails = false;
        block0: for (i = 0; i < ((IntVar[])this.vars).length; ++i) {
            v = ((IntVar[])this.vars)[i];
            offset = v.getLB();
            UB = v.getUB();
            dsz = UB - offset + 1;
            if (v.isInstantiated()) continue;
            this.Ilabel[i] = new double[v.hasEnumeratedDomain() ? dsz : 1];
            this.offsets[i] = offset;
            if (v.hasEnumeratedDomain()) {
                if (v.getDomainSize() < this.split) {
                    DisposableValueIterator it = v.getValueIterator(true);
                    while (it.hasNext()) {
                        double im;
                        if (System.currentTimeMillis() > tl) break block0;
                        int a = it.next();
                        this.Ilabel[i][a - offset] = im = this.computeImpact(v, a, before);
                    }
                    it.dispose();
                    continue;
                }
                int step = 0;
                int size = dsz / this.split;
                DisposableValueIterator it = v.getValueIterator(true);
                while (it.hasNext()) {
                    if (System.currentTimeMillis() > tl) break block0;
                    int a = it.next();
                    double im = step % size == 0 ? this.computeImpact(v, a, before) : this.Ilabel[i][a - 1 - offset];
                    this.Ilabel[i][a - offset] = im;
                    ++step;
                }
                it.dispose();
                continue;
            }
            if (System.currentTimeMillis() > tl) break;
            double i1 = this.computeImpact(v, v.getLB(), before);
            double i2 = this.computeImpact(v, v.getUB(), before);
            double i3 = this.computeImpact(v, (v.getLB() + v.getUB()) / 2, before);
            this.Ilabel[i][0] = (i1 + i2 + i3) / 3.0;
        }
        if (this.learnsAndFails) {
            this.learnsAndFails = false;
            return false;
        }
        if (System.currentTimeMillis() > tl) {
            if (this.model.getSettings().warnUser()) {
                this.model.getSolver().getErr().printf("impact Search stops its init phase -- reach time limit!", new Object[0]);
            }
            for (i = 0; i < ((IntVar[])this.vars).length; ++i) {
                v = ((IntVar[])this.vars)[i];
                offset = v.getLB();
                UB = v.getUB();
                dsz = UB - offset + 1;
                if (v.isInstantiated() || this.Ilabel[i] != null) continue;
                this.Ilabel[i] = new double[v.hasEnumeratedDomain() ? dsz : 1];
                this.offsets[i] = offset;
            }
        }
        return true;
    }

    @Override
    public void onContradiction(ContradictionException cex) {
        this.asgntFailed = true;
    }

    @Override
    public void beforeDownBranch(boolean left) {
    }

    @Override
    public void afterDownBranch(boolean left) {
        if (left) {
            if (this.currentVar > -1) {
                if (this.asgntFailed) {
                    this.updateImpact(1.0, this.currentVar, this.currentVal);
                } else {
                    double sssz = this.searchSpaceSize();
                    this.updateImpact(sssz / this.searchSpaceSize.get(), this.currentVar, this.currentVal);
                    this.searchSpaceSize.set(sssz);
                }
                this.currentVar = -1;
            }
            this.asgntFailed = false;
        }
        this.reevaluateImpact();
    }

    private double computeImpact(int idx) {
        IntVar var = ((IntVar[])this.vars)[idx];
        if (var.hasEnumeratedDomain()) {
            int of = this.offsets[idx];
            DisposableValueIterator it = var.getValueIterator(true);
            double impact = 0.0;
            while (it.hasNext()) {
                int val = it.next();
                impact += this.Ilabel[idx][val - of];
            }
            it.dispose();
            return impact - (double)var.getDomainSize();
        }
        return this.Ilabel[idx][0] - (double)var.getDomainSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double computeImpact(IntVar v, int a, double before) {
        this.model.getEnvironment().worldPush();
        try {
            v.instantiateTo(a, this);
            this.model.getSolver().getEngine().propagate();
            double after = this.searchSpaceSize();
            double d = 1.0 - after / before;
            return d;
        }
        catch (ContradictionException e) {
            this.model.getSolver().getEngine().flush();
            this.model.getEnvironment().worldPop();
            this.model.getEnvironment().worldPush();
            try {
                v.removeValue(a, this);
                this.model.getSolver().getEngine().propagate();
            }
            catch (ContradictionException ex) {
                this.learnsAndFails = true;
                this.model.getSolver().getEngine().flush();
            }
            double d = 1.0;
            return d;
        }
        finally {
            this.model.getEnvironment().worldPop();
        }
    }

    private void updateImpact(double nImpact, int varIdx, int valIdx) {
        valIdx = this.Ilabel[varIdx].length > 1 ? valIdx - this.offsets[varIdx] : 0;
        double impact = this.Ilabel[varIdx][valIdx] * (double)(this.aging - 1);
        impact += nImpact;
        this.Ilabel[varIdx][valIdx] = impact /= (double)this.aging;
    }

    private double searchSpaceSize() {
        double size = 1.0;
        for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
            assert ((size *= (double)((IntVar[])this.vars)[i].getDomainSize()) > 0.0) : "Search space is not correct!";
        }
        if (size == Double.POSITIVE_INFINITY) {
            size = Double.MAX_VALUE;
        }
        return size;
    }

    private void reevaluateImpact() {
        if (this.nodeImpact > 0 && this.model.getSolver().getNodeCount() % (long)this.nodeImpact == 0L) {
            double before = this.searchSpaceSize.get();
            this.learnsAndFails = false;
            for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
                IntVar v = ((IntVar[])this.vars)[i];
                int dsz = v.getDomainSize();
                if (v.isInstantiated()) continue;
                int offset = v.getLB();
                if (v.hasEnumeratedDomain()) {
                    if (v.getDomainSize() < this.split) {
                        DisposableValueIterator it = v.getValueIterator(true);
                        while (it.hasNext()) {
                            int a = it.next();
                            double im = this.computeImpact(v, a, before);
                            this.updateImpact(im, i, a);
                        }
                        it.dispose();
                        continue;
                    }
                    int step = 0;
                    int size = dsz / this.split;
                    DisposableValueIterator it = v.getValueIterator(true);
                    while (it.hasNext()) {
                        int a = it.next();
                        double im = step % size == 0 ? this.computeImpact(v, a, before) : this.Ilabel[i][a - 1 - offset];
                        this.updateImpact(im, i, a);
                        ++step;
                    }
                    it.dispose();
                    continue;
                }
                double i1 = this.computeImpact(v, v.getLB(), before);
                double i2 = this.computeImpact(v, v.getUB(), before);
                double i3 = this.computeImpact(v, (v.getLB() + v.getUB()) / 2, before);
                this.updateImpact((i1 + i2 + i3) / 3.0, i, 0);
            }
            if (this.learnsAndFails) {
                this.learnsAndFails = false;
            }
        }
    }
}

